/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.utils;

import fr.gouv.vitam.tools.mailextractlib.core.StoreMessage;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.InternetHeaders;
import jakarta.mail.internet.MimeUtility;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RFC822Headers
extends InternetHeaders {
    StoreMessage message;
    private static final Pattern ENCODED_WORD_PATTERN_BEGIN = Pattern.compile("(=\\?[^?]+\\?[BbQq]\\?[^?]+)");
    private static final Pattern ENCODED_WORD_PATTERN = Pattern.compile("(=\\?[^?]+\\?[BbQq]\\?[^?]+\\?=)");
    private static final Pattern Q_ENCODING_PATTERN = Pattern.compile("=\\?[^?]+\\?[Qq]\\?[^?]+\\?=");
    private static final Pattern BASE64_BLOCK_PATTERN = Pattern.compile("=\\?([^?]+)\\?[Bb]\\?([^?]+)\\?=");
    public static final Pattern SIMPLE_EMAIL_WITH_NAME_PATTERN = Pattern.compile("^\\s*.*?<\\s*[a-zA-Z0-9](?:[a-zA-Z0-9._%+-]{0,62}[a-zA-Z0-9])?@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,}\\s*>\\s*$");

    static ByteArrayInputStream getBAIS(String headersString) {
        if (headersString == null) {
            headersString = "";
        }
        headersString = (String)headersString + "\n\n";
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(((String)headersString).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return bais;
    }

    public RFC822Headers(String headersString, StoreMessage message) throws MessagingException {
        super(RFC822Headers.getBAIS(headersString), true);
        this.message = message;
    }

    public static String getHeaderValue(String line) {
        char c;
        int j;
        int i = line.indexOf(58);
        if (i < 0) {
            return line;
        }
        for (j = i + 1; j < line.length() && ((c = line.charAt(j)) == ' ' || c == '\t' || c == '\r' || c == '\n'); ++j) {
        }
        return line.substring(j);
    }

    public List<String> getReferences() {
        ArrayList<String> result = null;
        String refHeader = this.getHeader("References", " ");
        if (refHeader != null) {
            String[] refList;
            result = new ArrayList<String>();
            for (String tmp : refList = RFC822Headers.getHeaderValue(refHeader).split(" ")) {
                try {
                    result.add(MimeUtility.decodeText(tmp));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private static String getElementalStringAddress(InternetAddress address) {
        Object result;
        if (address != null) {
            String s = address.getPersonal();
            result = s != null && !s.isEmpty() ? s + " " : "";
            s = address.getAddress();
            if (s != null && !s.isEmpty()) {
                result = (String)result + "<" + s + ">";
            }
        } else {
            result = "";
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getStringAddress(InternetAddress address) {
        if (address == null) return "";
        try {
            Object result = RFC822Headers.getElementalStringAddress(address);
            if (!address.isGroup()) return result;
            result = (String)result + ":";
            InternetAddress[] group = address.getGroup(false);
            int k = 0;
            while (k < group.length) {
                if (k > 0) {
                    result = (String)result + ",";
                }
                result = (String)result + RFC822Headers.getElementalStringAddress(group[k]);
                ++k;
            }
            return result;
        }
        catch (AddressException e) {
            return "";
        }
    }

    public List<String> getAddressHeader(String name) throws InterruptedException {
        String addressHeaderString = this.getHeader(name, ", ");
        return RFC822Headers.treatAddressHeaderString(name, this.message, addressHeaderString);
    }

    public static List<String> treatAddressHeaderString(String name, StoreMessage message, String addressHeaderString) throws InterruptedException {
        ArrayList<String> result = new ArrayList<String>();
        if (addressHeaderString != null) {
            InternetAddress[] iAddressArray;
            try {
                iAddressArray = InternetAddress.parseHeader(addressHeaderString, false);
            }
            catch (AddressException e) {
                addressHeaderString = RFC822Headers.decodeRfc2047Flexible(addressHeaderString);
                message.logMessageWarning("mailextractlib.rfc822: wrongly formatted address " + addressHeaderString + ", keep raw address list in metadata in header " + name, e);
                result.add(addressHeaderString);
                return result;
            }
            for (InternetAddress ia : iAddressArray) {
                String address = RFC822Headers.getStringAddress(ia);
                if (address.contains("=?")) {
                    address = RFC822Headers.decodeRfc2047Flexible(address);
                }
                result.add(address);
            }
        }
        return result;
    }

    public static String decodeRfc2047Flexible(String input) {
        if (input == null || ((String)input).isEmpty()) {
            return input;
        }
        if (ENCODED_WORD_PATTERN_BEGIN.matcher((CharSequence)(input = ((String)input).replaceAll("\\r?\\n[ \t]*", ""))).find() && !((String)input).trim().endsWith("?=")) {
            input = (String)input + "?=";
        }
        Matcher matcher = ENCODED_WORD_PATTERN.matcher((CharSequence)input);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            Object encoded = matcher.group(1);
            try {
                if (Q_ENCODING_PATTERN.matcher((CharSequence)encoded).matches()) {
                    encoded = ((String)encoded).replace(" ", "_");
                    encoded = ((String)encoded).replace("\t", "");
                } else {
                    Matcher base64matcher = BASE64_BLOCK_PATTERN.matcher((CharSequence)encoded);
                    if (base64matcher.matches()) {
                        String charset = base64matcher.group(1);
                        Object encodedText = base64matcher.group(2);
                        int mod = ((String)encodedText).length() % 4;
                        if (mod != 0) {
                            int missing = 4 - mod;
                            encodedText = (String)encodedText + "=".repeat(missing);
                        }
                        encoded = "=?" + charset + "?B?" + (String)encodedText + "?=";
                    }
                }
                String decoded = MimeUtility.decodeText((String)encoded);
                matcher.appendReplacement(result, Matcher.quoteReplacement(decoded));
            }
            catch (UnsupportedEncodingException e) {
                matcher.appendReplacement(result, Matcher.quoteReplacement((String)encoded));
            }
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public static List<String> removeInvalidAndDuplicatesFromAddressesList(List<String> addressList) {
        if (addressList == null) {
            return Collections.emptyList();
        }
        if (addressList.size() <= 1) {
            return addressList;
        }
        List<Object> decodedList = new ArrayList();
        for (String address : addressList) {
            if (!SIMPLE_EMAIL_WITH_NAME_PATTERN.matcher(address).matches()) continue;
            decodedList.add(address.toLowerCase().trim());
        }
        if (decodedList.isEmpty()) {
            decodedList = addressList;
        }
        return new ArrayList<String>(new LinkedHashSet(decodedList));
    }
}

