/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.utils;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class MailExtractProgressLogger {
    public static final int GLOBAL = 10;
    public static final Marker GLOBAL_MARKER = MarkerFactory.getMarker("GLOBAL");
    public static final int WARNING = 20;
    public static final Marker WARNING_MARKER = MarkerFactory.getMarker("WARNING");
    public static final int FOLDER = 30;
    public static final Marker FOLDER_MARKER = MarkerFactory.getMarker("FOLDER");
    public static final int MESSAGE_GROUP = 40;
    public static final Marker MESSAGE_GROUP_MARKER = MarkerFactory.getMarker("MESSAGE_GROUP");
    public static final int MESSAGE = 50;
    public static final Marker MESSAGE_MARKER = MarkerFactory.getMarker("MESSAGE");
    public static final int MESSAGE_DETAILS = 60;
    public static final Marker MESSAGE_DETAILS_MARKER = MarkerFactory.getMarker("MESSAGE_DETAILS");
    private final ProgressLogFunc progressLogFunc;
    private final Logger logger;
    private final int step;
    private final int stepDuration;
    private long previousStepEpochSeconds;
    AtomicInteger counter;
    private int progressLogLevel;
    private int progressFuncLogLevel;
    private int progressFuncStep;
    private boolean debugFlag;

    public MailExtractProgressLogger(Logger logger, int progressLogLevel) {
        this.progressLogFunc = null;
        this.logger = logger;
        this.step = Integer.MAX_VALUE;
        this.progressLogLevel = progressLogLevel;
        this.progressFuncLogLevel = progressLogLevel;
        this.progressFuncStep = this.step;
        this.stepDuration = Integer.MAX_VALUE;
        this.previousStepEpochSeconds = Instant.now().getEpochSecond();
        this.counter = new AtomicInteger(0);
        this.debugFlag = false;
    }

    public MailExtractProgressLogger(Logger logger, int progressLogLevel, ProgressLogFunc progressConsumer, int step) {
        this.progressLogFunc = progressConsumer;
        this.logger = logger;
        this.step = step;
        this.progressLogLevel = progressLogLevel;
        this.progressFuncLogLevel = progressLogLevel;
        this.progressFuncStep = step;
        this.stepDuration = Integer.MAX_VALUE;
        this.previousStepEpochSeconds = Instant.now().getEpochSecond();
        this.counter = new AtomicInteger(0);
        this.debugFlag = false;
    }

    public MailExtractProgressLogger(Logger logger, int progressLogLevel, ProgressLogFunc progressConsumer, int step, int stepDuration) {
        this.progressLogFunc = progressConsumer;
        this.logger = logger;
        this.step = step;
        this.progressLogLevel = progressLogLevel;
        this.progressFuncLogLevel = progressLogLevel;
        this.progressFuncStep = step;
        this.stepDuration = stepDuration;
        this.previousStepEpochSeconds = Instant.now().getEpochSecond();
        this.counter = new AtomicInteger(0);
        this.debugFlag = false;
    }

    public MailExtractProgressLogger(Logger logger, int progressLogLevel, ProgressLogFunc progressConsumer, int step, int stepDuration, int progressFuncLogLevel, int progressFuncStep) {
        this.progressLogFunc = progressConsumer;
        this.logger = logger;
        this.step = step;
        this.progressLogLevel = progressLogLevel;
        this.progressFuncLogLevel = progressFuncLogLevel;
        this.progressFuncStep = progressFuncStep;
        this.stepDuration = stepDuration;
        this.previousStepEpochSeconds = Instant.now().getEpochSecond();
        this.counter = new AtomicInteger(0);
        this.debugFlag = false;
    }

    public void setDebugFlag(boolean debugFlag) {
        this.debugFlag = debugFlag;
    }

    public boolean getDebugFlag() {
        return this.debugFlag;
    }

    public static String getMessagesStackString(Throwable e) {
        String result = "-> " + e.getMessage();
        if (e.getCause() instanceof Exception) {
            result = result + "\n" + MailExtractProgressLogger.getMessagesStackString((Exception)e.getCause());
        }
        return result;
    }

    private static String getJavaStackString(Throwable e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        e.printStackTrace(ps);
        return baos.toString();
    }

    public static String getAllJavaStackString(Throwable e) {
        Object result = MailExtractProgressLogger.getJavaStackString(e);
        if (e.getCause() instanceof Exception) {
            result = (String)result + "\n------------------------------------\n" + MailExtractProgressLogger.getJavaStackString((Exception)e.getCause());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doProgressLogWithoutInterruption(MailExtractProgressLogger mepl, int level, String log, Throwable e) {
        if (mepl != null) {
            MailExtractProgressLogger mailExtractProgressLogger = mepl;
            synchronized (mailExtractProgressLogger) {
                if (level <= mepl.progressLogLevel) {
                    if (e != null) {
                        log = (String)log + "\n" + MailExtractProgressLogger.getMessagesStackString(e);
                    }
                    if (mepl.progressLogFunc != null && level <= mepl.progressFuncLogLevel) {
                        mepl.progressLogFunc.doProgressLog(-1, (String)log);
                    }
                    if (e != null && mepl.debugFlag) {
                        log = (String)log + "\n" + MailExtractProgressLogger.getAllJavaStackString(e);
                    }
                    mepl.log(level, (String)log);
                }
            }
        }
    }

    public static void doProgressLogIfDebug(MailExtractProgressLogger mepl, String log, Throwable e) {
        if (mepl != null && mepl.debugFlag) {
            MailExtractProgressLogger.doProgressLogWithoutInterruption(mepl, 10, log, e);
        }
    }

    public static void doProgressLog(MailExtractProgressLogger mepl, int level, String log, Throwable e) throws InterruptedException {
        if (mepl != null) {
            MailExtractProgressLogger.doProgressLogWithoutInterruption(mepl, level, log, e);
            Thread.sleep(1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doProgressLogOneMoreCountedObject(MailExtractProgressLogger mepl, int level, String log) throws InterruptedException {
        if (mepl != null) {
            MailExtractProgressLogger mailExtractProgressLogger = mepl;
            synchronized (mailExtractProgressLogger) {
                if (level <= mepl.progressLogLevel) {
                    long nowEpochSeconds = Instant.now().getEpochSecond();
                    int rank = mepl.counter.addAndGet(1);
                    if ((long)mepl.stepDuration < nowEpochSeconds - mepl.previousStepEpochSeconds) {
                        log = log.replace("%count", Integer.toString(rank));
                        if (mepl.progressLogFunc != null && level <= mepl.progressFuncLogLevel) {
                            mepl.progressLogFunc.doProgressLog(rank, (rank % mepl.progressFuncStep == 0 ? "" : "* ") + log);
                        }
                        mepl.log(level, log);
                        Thread.sleep(1L);
                        mepl.previousStepEpochSeconds = nowEpochSeconds;
                        return;
                    }
                    String countLog = null;
                    if (rank % mepl.step == 0) {
                        countLog = log.replace("%count", Integer.toString(rank));
                        mepl.log(level, countLog);
                    }
                    if (mepl.progressLogFunc != null && rank % mepl.progressFuncStep == 0) {
                        if (countLog == null) {
                            countLog = log.replace("%count", Integer.toString(rank));
                        }
                        mepl.progressLogFunc.doProgressLog(rank, countLog);
                        Thread.sleep(1L);
                    }
                }
            }
        }
    }

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    private Marker getMarker(int level) {
        switch (level) {
            case 10: {
                return GLOBAL_MARKER;
            }
            case 20: {
                return WARNING_MARKER;
            }
            case 30: {
                return FOLDER_MARKER;
            }
            case 40: {
                return MESSAGE_GROUP_MARKER;
            }
            case 50: {
                return MESSAGE_MARKER;
            }
            case 60: {
                return MESSAGE_DETAILS_MARKER;
            }
        }
        return GLOBAL_MARKER;
    }

    public String getLevelName() {
        return this.getMarker(this.progressLogLevel).getName();
    }

    public int getProgressLogLevel() {
        return this.progressLogLevel;
    }

    public void setProgressLogLevel(int progressLogLevel) {
        this.progressLogLevel = progressLogLevel;
    }

    private void log(int level, String message) {
        if (level <= this.progressLogLevel && this.logger != null) {
            this.logger.info(this.getMarker(level), message);
        }
    }

    public void close() {
    }

    @FunctionalInterface
    public static interface ProgressLogFunc {
        public void doProgressLog(int var1, String var2);
    }
}

