/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.utils;

import java.util.Map;

public class HtmlAndXmlEscape {
    private static final Map<String, Character> UNESCAPE_MAP = Map.ofEntries(Map.entry("nbsp", Character.valueOf('\u00a0')), Map.entry("iexcl", Character.valueOf('\u00a1')), Map.entry("cent", Character.valueOf('\u00a2')), Map.entry("pound", Character.valueOf('\u00a3')), Map.entry("curren", Character.valueOf('\u00a4')), Map.entry("yen", Character.valueOf('\u00a5')), Map.entry("brvbar", Character.valueOf('\u00a6')), Map.entry("sect", Character.valueOf('\u00a7')), Map.entry("uml", Character.valueOf('\u00a8')), Map.entry("copy", Character.valueOf('\u00a9')), Map.entry("ordf", Character.valueOf('\u00aa')), Map.entry("laquo", Character.valueOf('\u00ab')), Map.entry("not", Character.valueOf('\u00ac')), Map.entry("shy", Character.valueOf('\u00ad')), Map.entry("reg", Character.valueOf('\u00ae')), Map.entry("macr", Character.valueOf('\u00af')), Map.entry("deg", Character.valueOf('\u00b0')), Map.entry("plusmn", Character.valueOf('\u00b1')), Map.entry("sup2", Character.valueOf('\u00b2')), Map.entry("sup3", Character.valueOf('\u00b3')), Map.entry("acute", Character.valueOf('\u00b4')), Map.entry("micro", Character.valueOf('\u00b5')), Map.entry("para", Character.valueOf('\u00b6')), Map.entry("middot", Character.valueOf('\u00b7')), Map.entry("cedil", Character.valueOf('\u00b8')), Map.entry("sup1", Character.valueOf('\u00b9')), Map.entry("ordm", Character.valueOf('\u00ba')), Map.entry("raquo", Character.valueOf('\u00bb')), Map.entry("frac14", Character.valueOf('\u00bc')), Map.entry("frac12", Character.valueOf('\u00bd')), Map.entry("frac34", Character.valueOf('\u00be')), Map.entry("iquest", Character.valueOf('\u00bf')), Map.entry("Agrave", Character.valueOf('\u00c0')), Map.entry("Aacute", Character.valueOf('\u00c1')), Map.entry("Acirc", Character.valueOf('\u00c2')), Map.entry("Atilde", Character.valueOf('\u00c3')), Map.entry("Auml", Character.valueOf('\u00c4')), Map.entry("Aring", Character.valueOf('\u00c5')), Map.entry("AElig", Character.valueOf('\u00c6')), Map.entry("Ccedil", Character.valueOf('\u00c7')), Map.entry("Egrave", Character.valueOf('\u00c8')), Map.entry("Eacute", Character.valueOf('\u00c9')), Map.entry("Ecirc", Character.valueOf('\u00ca')), Map.entry("Euml", Character.valueOf('\u00cb')), Map.entry("Igrave", Character.valueOf('\u00cc')), Map.entry("Iacute", Character.valueOf('\u00cd')), Map.entry("Icirc", Character.valueOf('\u00ce')), Map.entry("Iuml", Character.valueOf('\u00cf')), Map.entry("ETH", Character.valueOf('\u00d0')), Map.entry("Ntilde", Character.valueOf('\u00d1')), Map.entry("Ograve", Character.valueOf('\u00d2')), Map.entry("Oacute", Character.valueOf('\u00d3')), Map.entry("Ocirc", Character.valueOf('\u00d4')), Map.entry("Otilde", Character.valueOf('\u00d5')), Map.entry("Ouml", Character.valueOf('\u00d6')), Map.entry("times", Character.valueOf('\u00d7')), Map.entry("Oslash", Character.valueOf('\u00d8')), Map.entry("Ugrave", Character.valueOf('\u00d9')), Map.entry("Uacute", Character.valueOf('\u00da')), Map.entry("Ucirc", Character.valueOf('\u00db')), Map.entry("Uuml", Character.valueOf('\u00dc')), Map.entry("Yacute", Character.valueOf('\u00dd')), Map.entry("THORN", Character.valueOf('\u00de')), Map.entry("szlig", Character.valueOf('\u00df')), Map.entry("agrave", Character.valueOf('\u00e0')), Map.entry("aacute", Character.valueOf('\u00e1')), Map.entry("acirc", Character.valueOf('\u00e2')), Map.entry("atilde", Character.valueOf('\u00e3')), Map.entry("auml", Character.valueOf('\u00e4')), Map.entry("aring", Character.valueOf('\u00e5')), Map.entry("aelig", Character.valueOf('\u00e6')), Map.entry("ccedil", Character.valueOf('\u00e7')), Map.entry("egrave", Character.valueOf('\u00e8')), Map.entry("eacute", Character.valueOf('\u00e9')), Map.entry("ecirc", Character.valueOf('\u00ea')), Map.entry("euml", Character.valueOf('\u00eb')), Map.entry("igrave", Character.valueOf('\u00ec')), Map.entry("iacute", Character.valueOf('\u00ed')), Map.entry("icirc", Character.valueOf('\u00ee')), Map.entry("iuml", Character.valueOf('\u00ef')), Map.entry("eth", Character.valueOf('\u00f0')), Map.entry("ntilde", Character.valueOf('\u00f1')), Map.entry("ograve", Character.valueOf('\u00f2')), Map.entry("oacute", Character.valueOf('\u00f3')), Map.entry("ocirc", Character.valueOf('\u00f4')), Map.entry("otilde", Character.valueOf('\u00f5')), Map.entry("ouml", Character.valueOf('\u00f6')), Map.entry("divide", Character.valueOf('\u00f7')), Map.entry("oslash", Character.valueOf('\u00f8')), Map.entry("ugrave", Character.valueOf('\u00f9')), Map.entry("uacute", Character.valueOf('\u00fa')), Map.entry("ucirc", Character.valueOf('\u00fb')), Map.entry("uuml", Character.valueOf('\u00fc')), Map.entry("yacute", Character.valueOf('\u00fd')), Map.entry("thorn", Character.valueOf('\u00fe')), Map.entry("yuml", Character.valueOf('\u00ff')), Map.entry("fnof", Character.valueOf('\u0192')), Map.entry("Alpha", Character.valueOf('\u0391')), Map.entry("Beta", Character.valueOf('\u0392')), Map.entry("Gamma", Character.valueOf('\u0393')), Map.entry("Delta", Character.valueOf('\u0394')), Map.entry("Epsilon", Character.valueOf('\u0395')), Map.entry("Zeta", Character.valueOf('\u0396')), Map.entry("Eta", Character.valueOf('\u0397')), Map.entry("Theta", Character.valueOf('\u0398')), Map.entry("Iota", Character.valueOf('\u0399')), Map.entry("Kappa", Character.valueOf('\u039a')), Map.entry("Lambda", Character.valueOf('\u039b')), Map.entry("Mu", Character.valueOf('\u039c')), Map.entry("Nu", Character.valueOf('\u039d')), Map.entry("Xi", Character.valueOf('\u039e')), Map.entry("Omicron", Character.valueOf('\u039f')), Map.entry("Pi", Character.valueOf('\u03a0')), Map.entry("Rho", Character.valueOf('\u03a1')), Map.entry("Sigma", Character.valueOf('\u03a3')), Map.entry("Tau", Character.valueOf('\u03a4')), Map.entry("Upsilon", Character.valueOf('\u03a5')), Map.entry("Phi", Character.valueOf('\u03a6')), Map.entry("Chi", Character.valueOf('\u03a7')), Map.entry("Psi", Character.valueOf('\u03a8')), Map.entry("Omega", Character.valueOf('\u03a9')), Map.entry("alpha", Character.valueOf('\u03b1')), Map.entry("beta", Character.valueOf('\u03b2')), Map.entry("gamma", Character.valueOf('\u03b3')), Map.entry("delta", Character.valueOf('\u03b4')), Map.entry("epsilon", Character.valueOf('\u03b5')), Map.entry("zeta", Character.valueOf('\u03b6')), Map.entry("eta", Character.valueOf('\u03b7')), Map.entry("theta", Character.valueOf('\u03b8')), Map.entry("iota", Character.valueOf('\u03b9')), Map.entry("kappa", Character.valueOf('\u03ba')), Map.entry("lambda", Character.valueOf('\u03bb')), Map.entry("mu", Character.valueOf('\u03bc')), Map.entry("nu", Character.valueOf('\u03bd')), Map.entry("xi", Character.valueOf('\u03be')), Map.entry("omicron", Character.valueOf('\u03bf')), Map.entry("pi", Character.valueOf('\u03c0')), Map.entry("rho", Character.valueOf('\u03c1')), Map.entry("sigmaf", Character.valueOf('\u03c2')), Map.entry("sigma", Character.valueOf('\u03c3')), Map.entry("tau", Character.valueOf('\u03c4')), Map.entry("upsilon", Character.valueOf('\u03c5')), Map.entry("phi", Character.valueOf('\u03c6')), Map.entry("chi", Character.valueOf('\u03c7')), Map.entry("psi", Character.valueOf('\u03c8')), Map.entry("omega", Character.valueOf('\u03c9')), Map.entry("thetasym", Character.valueOf('\u03d1')), Map.entry("upsih", Character.valueOf('\u03d2')), Map.entry("piv", Character.valueOf('\u03d6')), Map.entry("bull", Character.valueOf('\u2022')), Map.entry("hellip", Character.valueOf('\u2026')), Map.entry("prime", Character.valueOf('\u2032')), Map.entry("Prime", Character.valueOf('\u2033')), Map.entry("oline", Character.valueOf('\u203e')), Map.entry("frasl", Character.valueOf('\u2044')), Map.entry("weierp", Character.valueOf('\u2118')), Map.entry("image", Character.valueOf('\u2111')), Map.entry("real", Character.valueOf('\u211c')), Map.entry("trade", Character.valueOf('\u2122')), Map.entry("alefsym", Character.valueOf('\u2135')), Map.entry("larr", Character.valueOf('\u2190')), Map.entry("uarr", Character.valueOf('\u2191')), Map.entry("rarr", Character.valueOf('\u2192')), Map.entry("darr", Character.valueOf('\u2193')), Map.entry("harr", Character.valueOf('\u2194')), Map.entry("crarr", Character.valueOf('\u21b5')), Map.entry("lArr", Character.valueOf('\u21d0')), Map.entry("uArr", Character.valueOf('\u21d1')), Map.entry("rArr", Character.valueOf('\u21d2')), Map.entry("dArr", Character.valueOf('\u21d3')), Map.entry("hArr", Character.valueOf('\u21d4')), Map.entry("forall", Character.valueOf('\u2200')), Map.entry("part", Character.valueOf('\u2202')), Map.entry("exist", Character.valueOf('\u2203')), Map.entry("empty", Character.valueOf('\u2205')), Map.entry("nabla", Character.valueOf('\u2207')), Map.entry("isin", Character.valueOf('\u2208')), Map.entry("notin", Character.valueOf('\u2209')), Map.entry("ni", Character.valueOf('\u220b')), Map.entry("prod", Character.valueOf('\u220f')), Map.entry("sum", Character.valueOf('\u2211')), Map.entry("minus", Character.valueOf('\u2212')), Map.entry("lowast", Character.valueOf('\u2217')), Map.entry("radic", Character.valueOf('\u221a')), Map.entry("prop", Character.valueOf('\u221d')), Map.entry("infin", Character.valueOf('\u221e')), Map.entry("ang", Character.valueOf('\u2220')), Map.entry("and", Character.valueOf('\u2227')), Map.entry("or", Character.valueOf('\u2228')), Map.entry("cap", Character.valueOf('\u2229')), Map.entry("cup", Character.valueOf('\u222a')), Map.entry("int", Character.valueOf('\u222b')), Map.entry("there4", Character.valueOf('\u2234')), Map.entry("sim", Character.valueOf('\u223c')), Map.entry("cong", Character.valueOf('\u2245')), Map.entry("asymp", Character.valueOf('\u2248')), Map.entry("ne", Character.valueOf('\u2260')), Map.entry("equiv", Character.valueOf('\u2261')), Map.entry("le", Character.valueOf('\u2264')), Map.entry("ge", Character.valueOf('\u2265')), Map.entry("sub", Character.valueOf('\u2282')), Map.entry("sup", Character.valueOf('\u2283')), Map.entry("nsub", Character.valueOf('\u2284')), Map.entry("sube", Character.valueOf('\u2286')), Map.entry("supe", Character.valueOf('\u2287')), Map.entry("oplus", Character.valueOf('\u2295')), Map.entry("otimes", Character.valueOf('\u2297')), Map.entry("perp", Character.valueOf('\u22a5')), Map.entry("sdot", Character.valueOf('\u22c5')), Map.entry("lceil", Character.valueOf('\u2308')), Map.entry("rceil", Character.valueOf('\u2309')), Map.entry("lfloor", Character.valueOf('\u230a')), Map.entry("rfloor", Character.valueOf('\u230b')), Map.entry("lang", Character.valueOf('\u2329')), Map.entry("rang", Character.valueOf('\u232a')), Map.entry("loz", Character.valueOf('\u25ca')), Map.entry("spades", Character.valueOf('\u2660')), Map.entry("clubs", Character.valueOf('\u2663')), Map.entry("hearts", Character.valueOf('\u2665')), Map.entry("diams", Character.valueOf('\u2666')), Map.entry("OElig", Character.valueOf('\u0152')), Map.entry("oelig", Character.valueOf('\u0153')), Map.entry("Scaron", Character.valueOf('\u0160')), Map.entry("scaron", Character.valueOf('\u0161')), Map.entry("Yuml", Character.valueOf('\u0178')), Map.entry("circ", Character.valueOf('\u02c6')), Map.entry("tilde", Character.valueOf('\u02dc')), Map.entry("ensp", Character.valueOf('\u2002')), Map.entry("emsp", Character.valueOf('\u2003')), Map.entry("thinsp", Character.valueOf('\u2009')), Map.entry("zwnj", Character.valueOf('\u200c')), Map.entry("zwj", Character.valueOf('\u200d')), Map.entry("lrm", Character.valueOf('\u200e')), Map.entry("rlm", Character.valueOf('\u200f')), Map.entry("ndash", Character.valueOf('\u2013')), Map.entry("mdash", Character.valueOf('\u2014')), Map.entry("lsquo", Character.valueOf('\u2018')), Map.entry("rsquo", Character.valueOf('\u2019')), Map.entry("sbquo", Character.valueOf('\u201a')), Map.entry("ldquo", Character.valueOf('\u201c')), Map.entry("rdquo", Character.valueOf('\u201d')), Map.entry("bdquo", Character.valueOf('\u201e')), Map.entry("dagger", Character.valueOf('\u2020')), Map.entry("Dagger", Character.valueOf('\u2021')), Map.entry("permil", Character.valueOf('\u2030')), Map.entry("lsaquo", Character.valueOf('\u2039')), Map.entry("rsaquo", Character.valueOf('\u203a')), Map.entry("euro", Character.valueOf('\u20ac')), Map.entry("quot", Character.valueOf('\"')), Map.entry("amp", Character.valueOf('&')), Map.entry("lt", Character.valueOf('<')), Map.entry("gt", Character.valueOf('>')), Map.entry("apos", Character.valueOf('\'')));

    public static String escapeXml(String input) {
        if (input == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(input.length());
        int length = input.length();
        block7: for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            if (Character.isHighSurrogate(c)) {
                if (i + 1 >= length || !Character.isLowSurrogate(input.charAt(i + 1))) continue;
                sb.append(c).append(input.charAt(i + 1));
                ++i;
                continue;
            }
            if (Character.isLowSurrogate(c) || c <= '\u001f' && c != '\t' && c != '\n' && c != '\r' || c >= '\u007f' && c <= '\u0084' || c >= '\u0086' && c <= '\u009f') continue;
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String unescapeHtmlAndXMLEntities(String input) {
        if (input == null || !input.contains("&")) {
            return input;
        }
        StringBuilder out = new StringBuilder(input.length());
        int len = input.length();
        for (int i = 0; i < len; ++i) {
            char c = input.charAt(i);
            if (c != '&') {
                out.append(c);
                continue;
            }
            int semi = input.indexOf(59, i + 1);
            if (semi == -1 || semi - i > 10) {
                out.append('&');
                continue;
            }
            String entity = input.substring(i + 1, semi);
            String full = input.substring(i, semi + 1);
            if (entity.startsWith("#")) {
                try {
                    int codePoint = entity.startsWith("#x") || entity.startsWith("#X") ? Integer.parseInt(entity.substring(2), 16) : Integer.parseInt(entity.substring(1));
                    out.appendCodePoint(codePoint);
                }
                catch (Exception e) {
                    out.append(full);
                }
                i = semi;
                continue;
            }
            Character repl = UNESCAPE_MAP.get(entity);
            if (repl != null) {
                out.append(repl);
            } else {
                out.append(full);
            }
            i = semi;
        }
        return out.toString();
    }

    private HtmlAndXmlEscape() {
    }
}

