/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateRange {
    private Date start = null;
    private Date end = null;
    private static SimpleDateFormat writeformat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public static String getISODateString(Date date) {
        if (date == null) {
            return null;
        }
        return writeformat.format(date);
    }

    public boolean isDefined() {
        return this.start != null && this.end != null;
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }

    public void extendRange(Date date) {
        if (date != null) {
            if (this.start == null) {
                this.start = date;
                this.end = date;
            } else if (this.start.after(date)) {
                this.start = date;
            } else if (this.end.before(date)) {
                this.end = date;
            }
        }
    }

    public void extendRange(DateRange dateRange) {
        if (dateRange.start != null) {
            if (this.start == null) {
                this.start = dateRange.start;
                this.end = dateRange.end;
            } else {
                if (this.start.after(dateRange.start)) {
                    this.start = dateRange.start;
                }
                if (this.end.before(dateRange.end)) {
                    this.end = dateRange.end;
                }
            }
        }
    }

    static {
        writeformat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

