/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.store.microsoft.pst;

import fr.gouv.vitam.tools.javalibpst.PSTAttachment;
import fr.gouv.vitam.tools.javalibpst.PSTException;
import fr.gouv.vitam.tools.javalibpst.PSTMessage;
import fr.gouv.vitam.tools.mailextractlib.store.microsoft.MicrosoftStoreMessageAttachment;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class PstStoreMessageAttachment
extends MicrosoftStoreMessageAttachment {
    public PstStoreMessageAttachment(PSTMessage message, int i) {
        try {
            PSTAttachment attachment = message.getAttachment(i);
            this.size = attachment.getAttachSize();
            this.attachMethod = attachment.getAttachMethod();
            this.creationTime = attachment.getCreationTime();
            this.modificationTime = attachment.getModificationTime();
            this.displayName = attachment.getDisplayName();
            try {
                int bytesRead;
                InputStream is = attachment.getFileInputStream();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[4096];
                while ((bytesRead = is.read(buf)) != -1) {
                    baos.write(buf, 0, bytesRead);
                }
                this.byteArray = baos.toByteArray();
            }
            catch (PSTException | IOException e) {
                this.byteArray = null;
            }
            this.filename = attachment.getFilename();
            this.longFilename = attachment.getLongFilename();
            try {
                this.embeddedMessage = attachment.getEmbeddedPSTMessage();
            }
            catch (PSTException | IOException e) {
                this.embeddedMessage = null;
            }
            this.mimeTag = attachment.getMimeTag();
            this.contentId = attachment.getContentId();
        }
        catch (PSTException | IOException exception) {
            // empty catch block
        }
    }
}

