/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.store.microsoft.pst;

import fr.gouv.vitam.tools.javalibpst.PSTConversationIndex;
import fr.gouv.vitam.tools.javalibpst.PSTException;
import fr.gouv.vitam.tools.javalibpst.PSTMessage;
import fr.gouv.vitam.tools.javalibpst.PSTRecipient;
import fr.gouv.vitam.tools.mailextractlib.core.StoreFolder;
import fr.gouv.vitam.tools.mailextractlib.store.microsoft.MicrosoftStoreMessage;
import fr.gouv.vitam.tools.mailextractlib.store.microsoft.MicrosoftStoreMessageAttachment;
import fr.gouv.vitam.tools.mailextractlib.store.microsoft.pst.PstStoreMessageAttachment;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class PstStoreMessage
extends MicrosoftStoreMessage {
    PSTMessage message;
    static final String EMBEDDED_MESSAGE = "pst.embeddedmsg";

    public PstStoreMessage(StoreFolder mBFolder, PSTMessage message) {
        super(mBFolder);
        this.message = message;
    }

    @Override
    protected long getNativeMessageSize() {
        return this.message.getMessageSize();
    }

    @Override
    protected String getNativeSmtpTransportHeader() {
        return this.message.getTransportMessageHeaders();
    }

    @Override
    protected String getNativeSubject() {
        return this.message.getSubject();
    }

    @Override
    protected String getNativeInternetMessageId() {
        return this.message.getInternetMessageId();
    }

    @Override
    protected String getNativeSenderName() {
        return this.message.getSenderName();
    }

    @Override
    protected String getNativeSentRepresentingName() {
        return this.message.getSentRepresentingName();
    }

    @Override
    protected String getNativeSenderAddrType() {
        return this.message.getSenderAddrtype();
    }

    @Override
    protected String getNativeSenderEmailAddress() {
        return this.message.getSenderEmailAddress();
    }

    @Override
    protected String getNativeSentRepresentingAddrType() {
        return this.message.getSentRepresentingAddressType();
    }

    @Override
    protected String getNativeSentRepresentingEmailAddress() {
        return this.message.getSentRepresentingEmailAddress();
    }

    @Override
    protected String getNativeReturnPath() {
        return this.message.getReturnPath();
    }

    @Override
    protected Date getNativeMessageDeliveryTime() {
        return this.message.getMessageDeliveryTime();
    }

    @Override
    protected Date getNativeClientSubmitTime() {
        return this.message.getClientSubmitTime();
    }

    @Override
    protected String getNativeInReplyToId() {
        return this.message.getInReplyToId();
    }

    @Override
    protected boolean hasNativeConversationIndex() {
        return this.message.getConversationIndex() != null && this.message.getConversationIndex().getGuid() != null;
    }

    @Override
    protected Date getNativeCIDeliveryTime() {
        return this.message.getConversationIndex().getDeliveryTime();
    }

    @Override
    protected UUID getNativeCIGuid() {
        return this.message.getConversationIndex().getGuid();
    }

    @Override
    protected int getNativeCINumberOfResponseLevels() {
        List<PSTConversationIndex.ResponseLevel> lResponseLevel = this.message.getConversationIndex().getResponseLevels();
        if (lResponseLevel == null) {
            return 0;
        }
        return lResponseLevel.size();
    }

    @Override
    protected short getNativeCIResponseLevelDeltaCode(int responseLevelNumber) {
        List<PSTConversationIndex.ResponseLevel> lResponseLevel = this.message.getConversationIndex().getResponseLevels();
        if (lResponseLevel == null) {
            return 0;
        }
        return lResponseLevel.get(responseLevelNumber).getDeltaCode();
    }

    @Override
    protected long getNativeCIResponseLevelTimeDelta(int responseLevelNumber) {
        List<PSTConversationIndex.ResponseLevel> lResponseLevel = this.message.getConversationIndex().getResponseLevels();
        if (lResponseLevel == null) {
            return 0L;
        }
        return lResponseLevel.get(responseLevelNumber).getTimeDelta();
    }

    @Override
    protected short getNativeCIResponseLevelRandom(int responseLevelNumber) {
        List<PSTConversationIndex.ResponseLevel> lResponseLevel = this.message.getConversationIndex().getResponseLevels();
        if (lResponseLevel == null) {
            return 0;
        }
        return lResponseLevel.get(responseLevelNumber).getRandom();
    }

    @Override
    protected int getNativeNumberOfRecipients() {
        try {
            return this.message.getNumberOfRecipients();
        }
        catch (PSTException | IOException e) {
            return 0;
        }
    }

    @Override
    protected String getNativeRecipientsSmtpAddress(int recipientNumber) {
        PSTRecipient recipient;
        try {
            recipient = this.message.getRecipient(recipientNumber);
        }
        catch (PSTException | IOException e) {
            return null;
        }
        return recipient.getSmtpAddress();
    }

    @Override
    protected String getNativeRecipientsEmailAddress(int recipientNumber) {
        PSTRecipient recipient;
        try {
            recipient = this.message.getRecipient(recipientNumber);
        }
        catch (PSTException | IOException e) {
            return null;
        }
        return recipient.getEmailAddress();
    }

    @Override
    protected String getNativeRecipientsDisplayName(int recipientNumber) {
        PSTRecipient recipient;
        try {
            recipient = this.message.getRecipient(recipientNumber);
        }
        catch (PSTException | IOException e) {
            return null;
        }
        return recipient.getDisplayName();
    }

    @Override
    protected int getNativeRecipientsType(int recipientNumber) {
        PSTRecipient recipient;
        try {
            recipient = this.message.getRecipient(recipientNumber);
        }
        catch (PSTException | IOException e) {
            return 0;
        }
        return recipient.getRecipientType();
    }

    @Override
    protected String getNativeBodyText() {
        return this.message.getBody();
    }

    @Override
    protected String getNativeBodyHTML() {
        return this.message.getBodyHTML();
    }

    @Override
    protected String getNativeRTFBody() {
        try {
            return this.message.getRTFBody();
        }
        catch (PSTException | IOException e) {
            return null;
        }
    }

    @Override
    public String getEmbeddedMessageScheme() {
        return EMBEDDED_MESSAGE;
    }

    @Override
    protected MicrosoftStoreMessageAttachment[] getNativeAttachments() {
        MicrosoftStoreMessageAttachment[] psmAttachment = new PstStoreMessageAttachment[this.message.getNumberOfAttachments()];
        for (int i = 0; i < this.message.getNumberOfAttachments(); ++i) {
            psmAttachment[i] = new PstStoreMessageAttachment(this.message, i);
        }
        return psmAttachment;
    }
}

