/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.store.microsoft.pst;

import fr.gouv.vitam.tools.javalibpst.PSTAppointment;
import fr.gouv.vitam.tools.javalibpst.PSTContact;
import fr.gouv.vitam.tools.javalibpst.PSTException;
import fr.gouv.vitam.tools.javalibpst.PSTFolder;
import fr.gouv.vitam.tools.javalibpst.PSTMessage;
import fr.gouv.vitam.tools.javalibpst.PSTObject;
import fr.gouv.vitam.tools.mailextractlib.core.StoreElement;
import fr.gouv.vitam.tools.mailextractlib.core.StoreExtractor;
import fr.gouv.vitam.tools.mailextractlib.core.StoreFolder;
import fr.gouv.vitam.tools.mailextractlib.nodes.ArchiveUnit;
import fr.gouv.vitam.tools.mailextractlib.store.microsoft.pst.PstStoreAppointment;
import fr.gouv.vitam.tools.mailextractlib.store.microsoft.pst.PstStoreContact;
import fr.gouv.vitam.tools.mailextractlib.store.microsoft.pst.PstStoreExtractor;
import fr.gouv.vitam.tools.mailextractlib.store.microsoft.pst.PstStoreMessage;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractLibException;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractProgressLogger;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class PstStoreFolder
extends StoreFolder {
    protected PSTFolder pstFolder;
    private String fullName;
    private String name;

    private PstStoreFolder(StoreExtractor storeExtractor, PSTFolder pstFolder) {
        super(storeExtractor);
        this.pstFolder = pstFolder;
        this.fullName = "";
        this.name = "";
    }

    private PstStoreFolder(StoreExtractor storeExtractor, PSTFolder pstFolder, PstStoreFolder father) {
        super(storeExtractor);
        this.pstFolder = pstFolder;
        this.name = pstFolder.getDisplayName();
        if (this.name == null) {
            this.name = "";
        }
        this.fullName = father.getFullName().isEmpty() ? this.name : father.fullName + File.separator + this.name;
        this.finalizeStoreFolder(father);
    }

    public static PstStoreFolder createRootFolder(PstStoreExtractor storeExtractor, PSTFolder pstFolder, ArchiveUnit rootArchiveUnit) {
        PstStoreFolder result = new PstStoreFolder(storeExtractor, pstFolder);
        result.folderArchiveUnit = rootArchiveUnit;
        return result;
    }

    private void logMessageWarning(String msg, Exception e) throws InterruptedException {
        if (this.getStoreExtractor().getOptions().warningMsgProblem) {
            MailExtractProgressLogger.doProgressLog(this.getProgressLogger(), 20, msg, e);
        } else {
            MailExtractProgressLogger.doProgressLog(this.getProgressLogger(), 60, msg, e);
        }
    }

    private PSTMessage getNextPSTObject(int count) throws MailExtractLibException, InterruptedException {
        boolean error;
        PSTObject po = null;
        do {
            try {
                po = this.pstFolder.getNextChild();
                error = false;
            }
            catch (IOException e) {
                throw new MailExtractLibException("mailextractlib.pst: can't use pst file", e);
            }
            catch (PSTException e) {
                throw new MailExtractLibException("mailextractlib.pst: can't get elements from folder " + this.getFullName(), e);
            }
            catch (Exception e) {
                this.logMessageWarning("mailextractlib.pst: end folder operation at message " + count + "/" + this.pstFolder.getContentCount() + " in folder " + this.getName(), e);
                error = true;
            }
        } while (error);
        return (PSTMessage)po;
    }

    private void extractPSTObject(PSTMessage message, int count, boolean writeFlag) throws InterruptedException {
        if (message instanceof PSTContact) {
            try {
                PstStoreContact extracted = new PstStoreContact(this, (PSTContact)message);
                ((StoreElement)extracted).processElement(writeFlag);
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                this.logMessageWarning("mailextractlib.pst: can't extract contact " + count + " in folder " + this.getName(), e);
            }
        } else if (message instanceof PSTAppointment) {
            try {
                PstStoreAppointment extracted = new PstStoreAppointment(this, (PSTAppointment)message);
                ((StoreElement)extracted).processElement(writeFlag);
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                this.logMessageWarning("mailextractlib.pst: can't extract appointment " + count + " in folder " + this.getName(), e);
            }
        } else {
            try {
                PstStoreMessage extracted = new PstStoreMessage(this, message);
                ((StoreElement)extracted).processElement(writeFlag);
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                this.logMessageWarning("mailextractlib.pst: can't extract message " + count + " in folder " + this.getName(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExtractFolderElements(boolean writeFlag) throws MailExtractLibException, InterruptedException {
        if (this.storeExtractor.isRoot()) {
            ExecutorService pool = Executors.newFixedThreadPool(this.storeExtractor.getMaxParallelThreads());
            ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(pool);
            int submittedTasks = 0;
            try {
                int messageRank;
                PSTMessage message;
                while ((message = this.getNextPSTObject(messageRank = submittedTasks + 1)) != null) {
                    PSTMessage msg = message;
                    completionService.submit(() -> {
                        this.extractPSTObject(msg, messageRank, writeFlag);
                        return null;
                    });
                    submittedTasks = messageRank;
                }
                for (int i = 0; i < submittedTasks; ++i) {
                    Future future = completionService.poll(60L, TimeUnit.SECONDS);
                    if (future == null) {
                        throw new MailExtractLibException("mailextractlib.pst: Timeout: no message extracted within 60 seconds, folder extraction aborted.", null);
                    }
                    try {
                        future.get();
                        continue;
                    }
                    catch (ExecutionException e) {
                        MailExtractProgressLogger.doProgressLogWithoutInterruption(this.getStoreExtractor().getProgressLogger(), 50, "mailextractlib.pst: Error during a message processing, it's dropped.", e);
                    }
                }
            }
            finally {
                pool.shutdownNow();
            }
        } else {
            PSTMessage message;
            int messageCount = 1;
            while ((message = this.getNextPSTObject(messageCount)) != null) {
                this.extractPSTObject(message, messageCount, writeFlag);
                ++messageCount;
            }
        }
    }

    @Override
    protected void doExtractSubFolders(int level, boolean writeFlag) throws MailExtractLibException, InterruptedException {
        try {
            Vector<PSTFolder> subfolders = this.pstFolder.getSubFolders();
            for (PSTFolder subfolder : subfolders) {
                PstStoreFolder lPMailBoxSubFolder = new PstStoreFolder(this.storeExtractor, subfolder, this);
                if (lPMailBoxSubFolder.extractFolder(level + 1, writeFlag)) {
                    this.incFolderSubFoldersCount();
                }
                this.extendDateRange(lPMailBoxSubFolder.getDateRange());
            }
        }
        catch (IOException e) {
            throw new MailExtractLibException("mailextract.pst: can't use pst file", e);
        }
        catch (PSTException e) {
            throw new MailExtractLibException("mailextract.pst: can't get sub folders from folder " + this.getFullName(), e);
        }
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasElements() throws MailExtractLibException {
        try {
            return this.pstFolder.getEmailCount() > 0 || this.pstFolder.getContentCount() > 0;
        }
        catch (IOException e) {
            throw new MailExtractLibException("mailextract.pst: can't use pst file", e);
        }
        catch (PSTException e) {
            throw new MailExtractLibException("mailextract.pst: can't get messages from folder " + this.getFullName(), e);
        }
    }

    @Override
    public boolean hasSubfolders() throws MailExtractLibException {
        return this.pstFolder.hasSubfolders();
    }

    private void listPSTObject(PSTMessage message, int count, boolean stats) throws InterruptedException {
        if (message instanceof PSTContact) {
            try {
                PstStoreContact extracted = new PstStoreContact(this, (PSTContact)message);
                ((StoreElement)extracted).listElement(stats);
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                this.logMessageWarning("mailextractlib.pst: can't list contact " + count + " in folder " + this.getName(), e);
            }
        } else if (message instanceof PSTAppointment) {
            try {
                PstStoreAppointment extracted = new PstStoreAppointment(this, (PSTAppointment)message);
                ((StoreElement)extracted).listElement(stats);
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                this.logMessageWarning("mailextractlib.pst: can't list appointment " + count + " in folder " + this.getName(), e);
            }
        } else {
            try {
                PstStoreMessage extracted = new PstStoreMessage(this, message);
                ((StoreElement)extracted).listElement(stats);
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                this.logMessageWarning("mailextractlib.pst: can't list message " + count + " in folder " + this.getName(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doListFolderElements(boolean stats) throws MailExtractLibException, InterruptedException {
        if (this.storeExtractor.isRoot()) {
            ExecutorService pool = Executors.newFixedThreadPool(this.storeExtractor.getMaxParallelThreads());
            ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(pool);
            int submittedTasks = 0;
            try {
                int messageRank;
                PSTMessage message;
                while ((message = this.getNextPSTObject(messageRank = submittedTasks + 1)) != null) {
                    PSTMessage msg = message;
                    completionService.submit(() -> {
                        this.listPSTObject(msg, messageRank, stats);
                        return null;
                    });
                    submittedTasks = messageRank;
                }
                for (int i = 0; i < submittedTasks; ++i) {
                    Future future = completionService.poll(60L, TimeUnit.SECONDS);
                    if (future == null) {
                        throw new MailExtractLibException("mailextractlib.pst: Timeout: no message listed within 60 seconds, folder extraction aborted.", null);
                    }
                    try {
                        future.get();
                        continue;
                    }
                    catch (ExecutionException e) {
                        MailExtractProgressLogger.doProgressLogWithoutInterruption(this.getStoreExtractor().getProgressLogger(), 50, "mailextractlib.pst: Error during a message processing, it's dropped.", e);
                    }
                }
            }
            finally {
                pool.shutdownNow();
            }
        } else {
            PSTMessage message;
            int messageCount = 1;
            while ((message = this.getNextPSTObject(messageCount)) != null) {
                this.listPSTObject(message, messageCount, stats);
                ++messageCount;
            }
        }
    }

    @Override
    protected void doListSubFolders(boolean stats) throws MailExtractLibException, InterruptedException {
        try {
            Vector<PSTFolder> subfolders = this.pstFolder.getSubFolders();
            for (PSTFolder subfolder : subfolders) {
                PstStoreFolder lPMailBoxSubFolder = new PstStoreFolder(this.storeExtractor, subfolder, this);
                lPMailBoxSubFolder.listFolder(stats);
                this.incFolderSubFoldersCount();
            }
        }
        catch (IOException e) {
            throw new MailExtractLibException("mailextract.pst: can't use pst file", e);
        }
        catch (PSTException e) {
            throw new MailExtractLibException("mailextract.pst: can't get sub folders from folder " + this.getFullName(), e);
        }
    }
}

