/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.store.microsoft.pst;

import fr.gouv.vitam.tools.javalibpst.PSTException;
import fr.gouv.vitam.tools.javalibpst.PSTFile;
import fr.gouv.vitam.tools.javalibpst.PSTFolder;
import fr.gouv.vitam.tools.mailextractlib.core.StoreAttachment;
import fr.gouv.vitam.tools.mailextractlib.core.StoreElement;
import fr.gouv.vitam.tools.mailextractlib.core.StoreExtractor;
import fr.gouv.vitam.tools.mailextractlib.core.StoreExtractorOptions;
import fr.gouv.vitam.tools.mailextractlib.nodes.ArchiveUnit;
import fr.gouv.vitam.tools.mailextractlib.store.microsoft.pst.PstStoreFolder;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractLibException;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractProgressLogger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Vector;

public class PstStoreExtractor
extends StoreExtractor {
    private StoreAttachment attachment;
    private File storeFile;
    private PSTFile pstFile;
    static final byte[] PST_MN = new byte[]{33, 66, 68, 78};

    public static void subscribeStoreExtractor() {
        PstStoreExtractor.addExtractionRelation("application/vnd.ms-outlook-pst", "x-fmt/248", "pst", true, PstStoreExtractor.class);
        PstStoreExtractor.addExtractionRelation("application/vnd.ms-outlook-pst", "x-fmt/249", "pst", true, PstStoreExtractor.class);
    }

    public PstStoreExtractor(String urlString, String storeFolder, String destPathString, StoreExtractorOptions options, StoreExtractor rootStoreExtractor, MailExtractProgressLogger logger) throws MailExtractLibException {
        super(urlString, storeFolder, destPathString, options, rootStoreExtractor, null, logger);
        try {
            this.pstFile = new PSTFile(this.path);
        }
        catch (Exception e) {
            throw new MailExtractLibException("mailextractlib.pst: can't open " + this.path + ", doesn't exist or is not a pst file", e);
        }
        this.pstFile.setGlobalCodepage(options.defaultCharsetName);
        PSTFile.setPrintErrors(logger.getDebugFlag());
        ArchiveUnit rootNode = new ArchiveUnit(this, this.destRootPath, this.destName);
        try {
            PSTFolder pstFolder = this.findChildFolder(this.pstFile.getRootFolder(), storeFolder);
            if (pstFolder == null) {
                throw new MailExtractLibException("mailextractlib.pst: can't find the root folder " + storeFolder + " in pst file", null);
            }
            PstStoreFolder lPRootMailBoxFolder = PstStoreFolder.createRootFolder(this, pstFolder, rootNode);
            this.setRootFolder(lPRootMailBoxFolder);
        }
        catch (IOException e) {
            throw new MailExtractLibException("mailextractlib.pst: can't use " + this.path + " pst file", e);
        }
        catch (PSTException e) {
            throw new MailExtractLibException("mailextractlib.pst: can't find extraction root folder " + storeFolder, e);
        }
    }

    private static File writeStoreFile(String dirPath, byte[] byteContent) throws MailExtractLibException {
        File storeFile;
        OutputStream output = null;
        try {
            Files.createDirectories(Paths.get(dirPath, new String[0]), new FileAttribute[0]);
            storeFile = PstStoreExtractor.getStoreTemporaryFile(dirPath);
            output = new BufferedOutputStream(new FileOutputStream(storeFile));
            if (byteContent != null) {
                output.write(byteContent);
            }
        }
        catch (IOException ex) {
            if (dirPath.length() + 8 > 250) {
                throw new MailExtractLibException("mailextractlib.pst: store file extraction illegal destination file (may be too long pathname), extracting unit in path " + dirPath, ex);
            }
            throw new MailExtractLibException("mailextractlib.pst: store file extraction illegal destination file, extracting unit in path " + dirPath, ex);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    throw new MailExtractLibException("mailextractlib.pst: can't close store file extraction, extracting unit in path " + dirPath, e);
                }
            }
        }
        return storeFile;
    }

    private static File getStoreTemporaryFile(String destPathString) {
        return new File(destPathString + File.separator + "tmpStore");
    }

    private static String generateFileAndUrl(StoreAttachment attachment, ArchiveUnit rootNode) throws MailExtractLibException {
        String result = null;
        File storeFile = PstStoreExtractor.writeStoreFile(rootNode.getFullName(), attachment.getRawAttachmentContent());
        try {
            result = "pst://localhost/" + URLEncoder.encode(storeFile.getAbsolutePath(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    private void deleteStoreFileAndContainerAndThrowException(String message, Exception e) throws MailExtractLibException {
        if (this.storeFile != null) {
            try {
                Files.deleteIfExists(this.storeFile.toPath());
                File parentDirectory = this.storeFile.getParentFile();
                if (parentDirectory != null && parentDirectory.isDirectory()) {
                    Files.deleteIfExists(parentDirectory.toPath());
                }
            }
            catch (IOException ee) {
                throw new MailExtractLibException(message + ", and unable to suppress temporary files (" + ee.getMessage() + ")", e);
            }
        }
        throw new MailExtractLibException(message, e);
    }

    public PstStoreExtractor(StoreAttachment attachment, ArchiveUnit rootNode, StoreExtractorOptions options, StoreExtractor rootStoreExtractor, StoreElement fatherElement, MailExtractProgressLogger logger) throws MailExtractLibException {
        super(PstStoreExtractor.generateFileAndUrl(attachment, rootNode), "", rootNode.getFullName(), options, rootStoreExtractor, fatherElement, logger);
        this.attachment = attachment;
        this.storeFile = new File(this.path);
        try {
            this.pstFile = new PSTFile(this.path);
        }
        catch (Exception e) {
            this.deleteStoreFileAndContainerAndThrowException("mailextractlib.pst: can't open " + this.path + ", doesn't exist or is not a pst file", e);
        }
        try {
            PSTFolder pstFolder = this.findChildFolder(this.pstFile.getRootFolder(), "");
            if (pstFolder == null) {
                this.deleteStoreFileAndContainerAndThrowException("mailextractlib.pst: Can't find the root folder in pst file", null);
            }
            PstStoreFolder lPRootMailBoxFolder = PstStoreFolder.createRootFolder(this, pstFolder, rootNode);
            this.setRootFolder(lPRootMailBoxFolder);
        }
        catch (IOException e) {
            this.deleteStoreFileAndContainerAndThrowException("mailextractlib.pst: Can't use " + this.path + " pst file", e);
        }
        catch (PSTException e) {
            this.deleteStoreFileAndContainerAndThrowException("mailextractlib.pst: Can't find extraction root folder", e);
        }
    }

    private PSTFolder getNamedSubFolder(PSTFolder father, String folderName) throws PSTException, IOException {
        PSTFolder result = null;
        Vector<PSTFolder> pstFolderChilds = father.getSubFolders();
        for (PSTFolder p : pstFolderChilds) {
            if (!p.getDisplayName().equals(folderName)) continue;
            result = p;
            break;
        }
        return result;
    }

    private PSTFolder findChildFolder(PSTFolder father, String folderFullName) throws PSTException, IOException {
        PSTFolder result = father;
        if (folderFullName == null || folderFullName.isEmpty()) {
            return result;
        }
        String regex = File.separator;
        if (regex.equals("\\")) {
            regex = "\\\\";
        }
        String[] folderHierarchy = folderFullName.split(regex);
        for (int i = 0; i < folderHierarchy.length && (folderHierarchy[i].isEmpty() || (result = this.getNamedSubFolder(result, folderHierarchy[i])) != null); ++i) {
        }
        return result;
    }

    @Override
    public void endStoreExtractor() throws MailExtractLibException {
        super.endStoreExtractor();
        try {
            if (this.pstFile != null) {
                this.pstFile.close();
            }
        }
        catch (IOException e) {
            throw new MailExtractLibException("mailextractlib.pst: Can't close temporary file tmpstore", e);
        }
        if (this.storeFile != null && !this.storeFile.delete()) {
            throw new MailExtractLibException("mailextractlib.pst: Can't delete temporary file tmpstore", null);
        }
    }

    @Override
    public StoreAttachment getAttachment() {
        return this.attachment;
    }

    @Override
    public boolean canExtractObjectsLists() {
        return true;
    }

    public static String getVerifiedScheme(byte[] content) {
        if (PstStoreExtractor.hasMagicNumber(content, PST_MN)) {
            return "pst";
        }
        return null;
    }
}

