/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.store.microsoft.pst;

import fr.gouv.vitam.tools.javalibpst.PSTAttachment;
import fr.gouv.vitam.tools.javalibpst.PSTContact;
import fr.gouv.vitam.tools.javalibpst.PSTException;
import fr.gouv.vitam.tools.mailextractlib.core.StoreContact;
import fr.gouv.vitam.tools.mailextractlib.store.microsoft.pst.PstStoreFolder;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractLibException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashSet;

public class PstStoreContact
extends StoreContact {
    private PstStoreFolder pstStoreFolder;
    private PSTContact contact;

    public PstStoreContact(PstStoreFolder pstStoreFolder, PSTContact contact) {
        super(pstStoreFolder);
        this.contact = contact;
    }

    private String getFullName() {
        String tmp1 = this.contact.getAccount();
        String tmp2 = this.contact.getDisplayName();
        if (tmp1 == null || tmp1.isEmpty()) {
            return tmp2;
        }
        if (tmp2 == null || tmp2.isEmpty()) {
            return tmp1;
        }
        if (tmp1.toLowerCase().equals(tmp2.toLowerCase())) {
            return tmp1;
        }
        return tmp1 + "/" + tmp2;
    }

    private String getStringFromSet(LinkedHashSet<String> set) {
        Object result = "";
        for (String s : set) {
            if (s == null || s.isEmpty()) continue;
            result = (String)result + s + ";";
        }
        if (!((String)result).isEmpty()) {
            result = ((String)result).substring(0, ((String)result).length() - 1);
        }
        return result;
    }

    private String getOtherMailAddresses() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add(this.contact.getEmail1EmailAddress());
        set.add(this.contact.getEmail2EmailAddress());
        set.add(this.contact.getEmail3EmailAddress());
        return this.getStringFromSet(set);
    }

    private String getBusinessTelephoneNumbers() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add(this.contact.getBusinessTelephoneNumber());
        set.add(this.contact.getBusiness2TelephoneNumber());
        set.add(this.contact.getCompanyMainPhoneNumber());
        return this.getStringFromSet(set);
    }

    private String getHomeTelephoneNumbers() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add(this.contact.getHomeTelephoneNumber());
        set.add(this.contact.getHome2TelephoneNumber());
        return this.getStringFromSet(set);
    }

    private String getMobileTelephoneNumbers() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add(this.contact.getMobileTelephoneNumber());
        set.add(this.contact.getRadioTelephoneNumber());
        return this.getStringFromSet(set);
    }

    private String getOtherTelephoneNumbers() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.add(this.contact.getCarTelephoneNumber());
        set.add(this.contact.getOtherTelephoneNumber());
        set.add(this.contact.getPagerTelephoneNumber());
        set.add(this.contact.getPrimaryFaxNumber());
        set.add(this.contact.getBusinessFaxNumber());
        set.add(this.contact.getHomeFaxNumber());
        set.add(this.contact.getIsdnNumber());
        return this.getStringFromSet(set);
    }

    private String getTitle() {
        String tmp1 = this.contact.getTitle();
        String tmp2 = this.contact.getProfession();
        if (tmp1 == null || tmp1.isEmpty()) {
            return tmp2;
        }
        if (tmp2 == null || tmp2.isEmpty()) {
            return tmp1;
        }
        if (tmp1.toLowerCase().equals(tmp2.toLowerCase())) {
            return tmp1;
        }
        return tmp1 + "/" + tmp2;
    }

    private String getBusinessAddress() {
        Object line = "";
        Object result = "";
        String tmp = this.contact.getBusinessAddressStreet();
        if (!tmp.isEmpty()) {
            result = "L1:" + tmp + "\n";
        }
        if (!(tmp = this.contact.getBusinessPostalCode()).isEmpty()) {
            line = tmp + " ";
        }
        if (!(tmp = this.contact.getBusinessAddressCity()).isEmpty()) {
            line = (String)line + tmp + " ";
        }
        if (!(tmp = this.contact.getBusinessPoBox()).isEmpty()) {
            line = (String)line + "POB:" + tmp + " ";
        }
        if (!((String)line).isEmpty()) {
            result = (String)result + "L2:" + ((String)line).substring(0, ((String)line).length() - 1) + "\n";
            line = "";
        }
        if (!(tmp = this.contact.getBusinessAddressCountry()).isEmpty()) {
            line = (String)line + tmp;
        }
        if (!(tmp = this.contact.getBusinessAddressStateOrProvince()).isEmpty() && !tmp.toLowerCase().equals(((String)line).toLowerCase())) {
            line = ((String)line).isEmpty() ? tmp : (String)line + "/" + tmp;
        }
        if (!((String)line).isEmpty()) {
            result = (String)result + "L3:" + (String)line + "\n";
        }
        return result;
    }

    private String getHomeAddress() {
        Object line = "";
        Object result = "";
        String tmp = this.contact.getHomeAddressStreet();
        if (!tmp.isEmpty()) {
            result = "L1:" + tmp + "\n";
        }
        if (!(tmp = this.contact.getHomeAddressPostalCode()).isEmpty()) {
            line = tmp + " ";
        }
        if (!(tmp = this.contact.getHomeAddressCity()).isEmpty()) {
            line = (String)line + tmp + " ";
        }
        if (!((String)line).isEmpty()) {
            result = (String)result + "L2:" + ((String)line).substring(0, ((String)line).length() - 1) + "\n";
            line = "";
        }
        if (!(tmp = this.contact.getHomeAddressPostOfficeBox()).isEmpty()) {
            line = (String)line + "POB:" + tmp + " ";
        }
        if (!(tmp = this.contact.getHomeAddressCountry()).isEmpty()) {
            line = (String)line + tmp;
        }
        if (!(tmp = this.contact.getHomeAddressStateOrProvince()).isEmpty() && !tmp.toLowerCase().equals(((String)line).toLowerCase())) {
            line = ((String)line).isEmpty() ? tmp : (String)line + "/" + tmp;
        }
        if (!((String)line).isEmpty()) {
            result = (String)result + "L3:" + (String)line + "\n";
        }
        return result;
    }

    @Override
    public void analyzeAllContactInformations() throws MailExtractLibException, InterruptedException {
        this.fullName = this.getFullName();
        this.givenName = this.contact.getGivenName();
        this.lastName = this.contact.getSurname();
        this.miscNotes = this.contact.getBody();
        this.companyName = this.contact.getCompanyName();
        this.departmentName = this.contact.getDepartmentName();
        this.title = this.getTitle();
        this.postalAddress = this.contact.getPostalAddress();
        this.smtpAddress = this.contact.getSMTPAddress();
        this.primaryTelephoneNumber = this.contact.getPrimaryTelephoneNumber();
        this.mobileTelephoneNumbers = this.getMobileTelephoneNumbers();
        this.businessHomePage = this.contact.getBusinessHomePage();
        this.businessLocation = this.contact.getOfficeLocation();
        this.businessTelephoneNumbers = this.getBusinessTelephoneNumbers();
        this.businessAddress = this.getBusinessAddress();
        this.customerId = this.contact.getCustomerId();
        this.otherMailAddresses = this.getOtherMailAddresses();
        this.otherTelephoneNumbers = this.getOtherTelephoneNumbers();
        this.assistantName = this.contact.getAssistant();
        this.assistantTelephoneNumber = this.contact.getAssistantTelephoneNumber();
        this.personalHomePage = this.contact.getPersonalHomePage();
        this.homeLocation = this.contact.getLocation();
        this.homeTelephoneNumbers = this.getHomeTelephoneNumbers();
        this.homeAddress = this.getHomeAddress();
        this.nickName = this.contact.getNickname();
    }

    @Override
    public void analyzeContactPicture() throws MailExtractLibException, InterruptedException {
        this.pictureFileName = null;
        this.pictureData = null;
        if (this.contact.getNumberOfAttachments() == 0) {
            return;
        }
        for (int i = 0; i < this.contact.getNumberOfAttachments(); ++i) {
            try {
                PSTAttachment attachment = this.contact.getAttachment(i);
                if (!attachment.isContactPhoto()) continue;
                this.pictureFileName = attachment.getLongFilename();
                try {
                    int bytesRead;
                    InputStream is = attachment.getFileInputStream();
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    byte[] buf = new byte[4096];
                    while ((bytesRead = is.read(buf)) != -1) {
                        baos.write(buf, 0, bytesRead);
                    }
                    this.pictureData = baos.toByteArray();
                    break;
                }
                catch (PSTException | IOException e) {
                    this.pictureFileName = null;
                    continue;
                }
            }
            catch (PSTException | IOException exception) {
                // empty catch block
            }
        }
    }
}

