/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.store.microsoft.pst;

import fr.gouv.vitam.tools.javalibpst.PSTAppointment;
import fr.gouv.vitam.tools.javalibpst.PSTAppointmentException;
import fr.gouv.vitam.tools.javalibpst.PSTAppointmentRecurrence;
import fr.gouv.vitam.tools.javalibpst.PSTException;
import fr.gouv.vitam.tools.javalibpst.PSTGlobalObjectId;
import fr.gouv.vitam.tools.javalibpst.PSTMessage;
import fr.gouv.vitam.tools.javalibpst.PSTTimeZone;
import fr.gouv.vitam.tools.mailextractlib.core.StoreAppointment;
import fr.gouv.vitam.tools.mailextractlib.core.StoreAttachment;
import fr.gouv.vitam.tools.mailextractlib.core.StoreFolder;
import fr.gouv.vitam.tools.mailextractlib.formattools.HTMLTextExtractor;
import fr.gouv.vitam.tools.mailextractlib.formattools.rtf.HTMLFromRTFExtractor;
import fr.gouv.vitam.tools.mailextractlib.store.microsoft.MicrosoftStoreElement;
import fr.gouv.vitam.tools.mailextractlib.store.microsoft.MicrosoftStoreMessageAttachment;
import fr.gouv.vitam.tools.mailextractlib.store.microsoft.pst.PstStoreFolder;
import fr.gouv.vitam.tools.mailextractlib.store.microsoft.pst.PstStoreMessageAttachment;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractLibException;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class PstStoreAppointment
extends StoreAppointment
implements MicrosoftStoreElement {
    static final String EMBEDDED_MESSAGE = "pst.embeddedmsg";
    private PstStoreFolder pstStoreFolder;
    private PSTAppointment appointment;
    static HashMap<String, ZoneId> normalizedZoneIdMap = new HashMap();

    protected PstStoreAppointment(PstStoreFolder pstStoreFolder, PSTAppointment appointment) {
        super(pstStoreFolder);
        this.appointment = appointment;
    }

    protected PstStoreAppointment(StoreFolder storeFolder, String uniqId, int sequenceNumber, String subject, String location, String from, String toAttendees, String ccAttendees, ZonedDateTime startTime, ZonedDateTime endTime, String miscNotes, String otherMiscNotes, int messageStatus, List<StoreAttachment> attachments, boolean isRecurrenceDeletion, ZonedDateTime exceptionDate) {
        super(storeFolder);
        this.uniqId = uniqId;
        this.sequenceNumber = sequenceNumber;
        this.subject = subject;
        this.location = location;
        this.from = from;
        this.toAttendees = toAttendees;
        this.ccAttendees = ccAttendees;
        this.startTime = startTime;
        this.endTime = endTime;
        this.miscNotes = miscNotes;
        this.otherMiscNotes = otherMiscNotes;
        this.attachments = attachments;
        this.messageStatus = messageStatus;
        this.recurencePattern = "";
        this.startRecurrenceTime = null;
        this.endRecurrenceTime = null;
        this.exceptions = null;
        this.isRecurrenceDeletion = isRecurrenceDeletion;
        this.exceptionDate = exceptionDate;
    }

    @Override
    public String getEmbeddedMessageScheme() {
        return EMBEDDED_MESSAGE;
    }

    private String getUniqId() {
        String result;
        PSTGlobalObjectId id = this.appointment.getCleanGlobalObjectId();
        if (id == null) {
            result = this.appointment.getGlobalObjectId().toString();
        } else {
            result = id.toString();
            if (result.isEmpty()) {
                result = this.appointment.getGlobalObjectId().toString();
            }
        }
        return result;
    }

    private static String getFrom(PSTAppointment appointment) {
        String fromAddr = appointment.getSenderEmailAddress();
        String fromName = appointment.getSenderName();
        Object result = "";
        if (fromName != null && !fromName.isEmpty()) {
            result = fromName + " ";
        }
        if (fromAddr != null && !fromAddr.isEmpty()) {
            result = (String)result + "<" + fromAddr + ">";
        }
        return ((String)result).trim();
    }

    private ZoneId getNormalizedZoneId(Date date, PSTTimeZone pstTimeZone) throws InterruptedException {
        ZoneId result = normalizedZoneIdMap.get(pstTimeZone.getName());
        if (result != null) {
            return result;
        }
        try {
            result = ZoneId.of(pstTimeZone.getName());
        }
        catch (DateTimeException e) {
            result = ZoneOffset.ofTotalSeconds(pstTimeZone.getSimpleTimeZone().getOffset(date.getTime()) / 1000);
            this.logMessageWarning("mailextractlib: can't determine time zone id [" + pstTimeZone.getName() + "], replace by " + result.toString() + " format", null);
        }
        normalizedZoneIdMap.put(pstTimeZone.getName(), result);
        return result;
    }

    private ZonedDateTime getZonedDateTime(Date date, PSTTimeZone pstTimeZone) throws InterruptedException {
        ZoneId zoneId = pstTimeZone == null ? ZoneId.of("UTC") : this.getNormalizedZoneId(date, pstTimeZone);
        return ZonedDateTime.ofInstant(date.toInstant(), zoneId);
    }

    private void analyzeMiscNotes() throws InterruptedException {
        String test;
        String text = this.appointment.getBody().trim();
        String html = this.appointment.getBodyHTML().trim();
        String rtf = "";
        try {
            rtf = this.appointment.getRTFBody().trim();
            if (!rtf.isEmpty()) {
                HTMLFromRTFExtractor htmlExtractor = new HTMLFromRTFExtractor(rtf);
                if (htmlExtractor.isEncapsulatedTEXTinRTF()) {
                    test = htmlExtractor.getDeEncapsulateHTMLFromRTF();
                    if (text.isEmpty()) {
                        text = test;
                    } else if (!text.equals(test)) {
                        this.logMessageWarning("mailextractlib: rtf version different from text version, rtf version dropped", null);
                    }
                    rtf = "";
                } else if (htmlExtractor.isEncapsulatedHTMLinRTF()) {
                    test = htmlExtractor.getDeEncapsulateHTMLFromRTF();
                    if (html.isEmpty()) {
                        html = test;
                    } else if (!html.equals(test)) {
                        this.logMessageWarning("mailextractlib: rtf version different from html version, rtf version dropped", null);
                    }
                    rtf = "";
                } else {
                    test = htmlExtractor.getDeEncapsulateHTMLFromRTF().trim();
                    if (test.isEmpty()) {
                        rtf = "";
                    }
                }
            }
        }
        catch (PSTException | MailExtractLibException | IOException exception) {
            // empty catch block
        }
        test = HTMLTextExtractor.getInstance().act(html).trim();
        if (test.isEmpty()) {
            html = "";
        }
        this.miscNotes = text;
        this.otherMiscNotes = !html.isEmpty() ? html : rtf;
    }

    private List<StoreAttachment> getAttachments(PSTMessage message) throws InterruptedException {
        ArrayList<PstStoreMessageAttachment> nativeAttachments = new ArrayList<PstStoreMessageAttachment>(10);
        for (int i = 0; i < message.getNumberOfAttachments(); ++i) {
            try {
                PSTMessage child = message.getAttachment(i).getEmbeddedPSTMessage();
                if (child instanceof PSTAppointment) {
                    continue;
                }
            }
            catch (PSTException | IOException exception) {
                // empty catch block
            }
            nativeAttachments.add(new PstStoreMessageAttachment(message, i));
        }
        if (nativeAttachments.isEmpty()) {
            return new ArrayList<StoreAttachment>(0);
        }
        return MicrosoftStoreElement.getAttachments(this, nativeAttachments.toArray(new MicrosoftStoreMessageAttachment[0]));
    }

    private int getMessageStatus() {
        String messageClass = this.appointment.getMessageClass();
        if (messageClass.contains("Appointment")) {
            return 1;
        }
        if (messageClass.contains("Meeting.Request")) {
            return 2;
        }
        if (messageClass.contains("Meeting.Resp.Pos")) {
            return 3;
        }
        if (messageClass.contains("Meeting.Resp.Tent")) {
            return 4;
        }
        if (messageClass.contains("Meeting.Resp.Neg")) {
            return 5;
        }
        return 0;
    }

    private StoreAppointment generateDeletionAppointment(ZonedDateTime zdt) {
        PstStoreAppointment result = new PstStoreAppointment(this.storeFolder, this.uniqId, this.sequenceNumber, this.subject, this.location, this.from, this.toAttendees, this.ccAttendees, null, null, "", "", this.messageStatus, null, true, zdt);
        result.listLineId = this.getStoreExtractor().incElementCounter(this.getClass());
        return result;
    }

    private String getChangedFrom(PSTAppointmentException exception) {
        if (exception.getEmbeddedMessage() == null) {
            return this.from;
        }
        return PstStoreAppointment.getFrom(exception.getEmbeddedMessage());
    }

    private String getChangedToAttendees(PSTAppointmentException exception) {
        if (exception.getEmbeddedMessage() == null) {
            return this.toAttendees;
        }
        return exception.getEmbeddedMessage().getToAttendees();
    }

    private String getChangedCCAttendees(PSTAppointmentException exception) {
        if (exception.getEmbeddedMessage() == null) {
            return this.ccAttendees;
        }
        return exception.getEmbeddedMessage().getCCAttendees();
    }

    private ZonedDateTime getChangedZonedDateTime(ZonedDateTime zdt, Date d) {
        return ZonedDateTime.ofInstant(d.toInstant(), zdt.getZone());
    }

    private StoreAppointment generateExceptionAppointment(ZonedDateTime zdt, PSTAppointmentException exception) throws InterruptedException {
        PstStoreAppointment result = new PstStoreAppointment(this.storeFolder, this.uniqId, this.sequenceNumber, exception.getSubject(), exception.getLocation(), this.getChangedFrom(exception), this.getChangedToAttendees(exception), this.getChangedCCAttendees(exception), this.getChangedZonedDateTime(this.startTime, exception.getStartDate()), this.getChangedZonedDateTime(this.startTime, exception.getEndDate()), "", "", this.messageStatus, null, false, zdt);
        if (exception.getEmbeddedMessage() != null) {
            result.appointment = exception.getEmbeddedMessage();
            result.analyzeMiscNotes();
            result.attachments = this.getAttachments(result.appointment);
        }
        result.listLineId = this.getStoreExtractor().incElementCounter(this.getClass());
        return result;
    }

    @Override
    public void analyzeAppointment() throws MailExtractLibException, InterruptedException {
        this.uniqId = this.getUniqId();
        this.subject = this.appointment.getSubject();
        this.location = this.appointment.getLocation();
        this.from = PstStoreAppointment.getFrom(this.appointment);
        this.toAttendees = this.appointment.getToAttendees();
        this.ccAttendees = this.appointment.getCCAttendees();
        this.startTime = this.getZonedDateTime(this.appointment.getStartTime(), this.appointment.getStartTimeZone());
        this.endTime = this.getZonedDateTime(this.appointment.getEndTime(), this.appointment.getEndTimeZone());
        this.analyzeMiscNotes();
        this.attachments = this.getAttachments(this.appointment);
        this.sequenceNumber = this.appointment.getAppointmentSequence();
        this.modificationTime = this.getZonedDateTime(this.appointment.getLastModificationTime(), null);
        this.messageStatus = this.getMessageStatus();
        if (this.appointment.isRecurring()) {
            PSTTimeZone tz = this.appointment.getRecurrenceTimeZone();
            if (tz == null) {
                tz = new PSTTimeZone("Unknown", PSTTimeZone.utcTimeZone);
            }
            PSTAppointmentRecurrence par = new PSTAppointmentRecurrence(this.appointment.getRecurrenceStructure(), this.appointment, tz);
            this.recurencePattern = this.appointment.getRecurrencePattern();
            this.startRecurrenceTime = this.getZonedDateTime(par.getStartDate(), this.appointment.getRecurrenceTimeZone());
            this.endRecurrenceTime = this.getZonedDateTime(par.getEndDate(), this.appointment.getRecurrenceTimeZone());
            this.exceptions = new ArrayList(10);
            for (Date d : par.getDeletedInstanceDates()) {
                ZonedDateTime zdt = this.getZonedDateTime(d, par.getTimeZone());
                this.exceptions.add(this.generateDeletionAppointment(zdt));
            }
            for (int i = 0; i < par.getExceptionCount(); ++i) {
                ZonedDateTime zdt = this.getZonedDateTime(par.getModifiedInstanceDates()[i], par.getTimeZone());
                this.exceptions.add(this.generateExceptionAppointment(zdt, par.getException(i)));
            }
        } else {
            this.recurencePattern = "";
            this.startRecurrenceTime = null;
            this.endRecurrenceTime = null;
            this.exceptions = new ArrayList(0);
        }
        this.isRecurrenceDeletion = false;
    }
}

