/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.store.microsoft.msg;

import fr.gouv.vitam.tools.mailextractlib.store.microsoft.MicrosoftStoreMessageAttachment;
import java.io.IOException;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.poi.hsmf.datatypes.AttachmentChunks;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.hsmf.datatypes.PropertyValue;
import org.apache.poi.hsmf.datatypes.StoragePropertiesChunk;
import org.apache.poi.hsmf.datatypes.StringChunk;

public class MsgStoreMessageAttachment
extends MicrosoftStoreMessageAttachment {
    public MsgStoreMessageAttachment(AttachmentChunks attachmentChunks) {
        Chunk[] chunkArray;
        for (Chunk chunk : chunkArray = attachmentChunks.getAll()) {
            if (chunk instanceof StoragePropertiesChunk) {
                Calendar cal;
                StoragePropertiesChunk spChunk = (StoragePropertiesChunk)chunk;
                Map<MAPIProperty, List<PropertyValue>> mapProp = spChunk.getProperties();
                List<PropertyValue> lVal = mapProp.get(MAPIProperty.ATTACH_SIZE);
                this.size = lVal == null ? 0 : (Integer)lVal.get(0).getValue();
                lVal = mapProp.get(MAPIProperty.ATTACH_METHOD);
                this.attachMethod = lVal == null ? 0 : (Integer)lVal.get(0).getValue();
                lVal = mapProp.get(MAPIProperty.CREATION_TIME);
                if (lVal != null && (cal = (Calendar)lVal.get(0).getValue()) != null) {
                    this.creationTime = cal.getTime();
                }
                if ((lVal = mapProp.get(MAPIProperty.LAST_MODIFICATION_TIME)) == null || (cal = (Calendar)lVal.get(0).getValue()) == null) continue;
                this.modificationTime = cal.getTime();
                continue;
            }
            if (!(chunk instanceof StringChunk) || chunk.getChunkId() != MAPIProperty.DISPLAY_NAME.id) continue;
            this.displayName = ((StringChunk)chunk).getValue();
        }
        this.byteArray = attachmentChunks.getEmbeddedAttachmentObject();
        StringChunk tmpSC = attachmentChunks.getAttachFileName();
        if (tmpSC != null) {
            this.filename = tmpSC.getValue();
        }
        try {
            this.embeddedMessage = attachmentChunks.getEmbeddedMessage();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        tmpSC = attachmentChunks.getAttachLongFileName();
        if (tmpSC != null) {
            this.longFilename = tmpSC.getValue();
        }
        if ((tmpSC = attachmentChunks.getAttachMimeTag()) != null) {
            this.mimeTag = tmpSC.getValue();
        }
        if ((tmpSC = attachmentChunks.getAttachContentId()) != null) {
            this.contentId = tmpSC.getValue();
        }
    }
}

