/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.store.microsoft.msg;

import fr.gouv.vitam.tools.mailextractlib.core.StoreFolder;
import fr.gouv.vitam.tools.mailextractlib.store.microsoft.MicrosoftStoreMessage;
import fr.gouv.vitam.tools.mailextractlib.store.microsoft.MicrosoftStoreMessageAttachment;
import fr.gouv.vitam.tools.mailextractlib.store.microsoft.msg.MsgConversationIndex;
import fr.gouv.vitam.tools.mailextractlib.store.microsoft.msg.MsgStoreMessageAttachment;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.apache.poi.hsmf.MAPIMessage;
import org.apache.poi.hsmf.datatypes.AttachmentChunks;
import org.apache.poi.hsmf.datatypes.ByteChunk;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.hsmf.datatypes.PropertyValue;
import org.apache.poi.hsmf.datatypes.StringChunk;
import org.apache.poi.hsmf.exceptions.ChunkNotFoundException;

public class MsgStoreMessage
extends MicrosoftStoreMessage {
    MAPIMessage message;
    long size;
    MsgConversationIndex msgConversationIndex;
    static final String EMBEDDED_MESSAGE = "msg.embeddedmsg";
    public static final int CONVERSATION_INDEX = 113;
    public static final int SMTP_TRANSPORT_HEADER = 125;
    public static final int SUBJECT = 55;
    public static final int INTERNET_MESSAGE_ID = 4149;
    public static final int SENDER_NAME = 3098;
    public static final int SENT_REPRESENTING_NAME = 66;
    public static final int SENDER_ADDR_TYPE = 3102;
    public static final int SENDER_EMAIL_ADDRESS = 3103;
    public static final int SENT_REPRESENTING_ADDR_TYPE = 100;
    public static final int SENT_REPRESENTING_EMAIL_ADDRESS = 101;
    public static final int RETURN_PATH = 4166;
    public static final int MESSAGE_DELIVERY_TIME = 3590;
    public static final int CLIENT_SUBMIT_TIME = 57;
    public static final int IN_REPLY_TO_ID = 4162;
    public static final int MESSAGE_SIZE = 3592;

    public MsgStoreMessage(StoreFolder mBFolder, MAPIMessage message, long size) throws InterruptedException {
        super(mBFolder);
        this.message = message;
        this.size = size;
        this.getConversationIndex();
    }

    private void getConversationIndex() throws InterruptedException {
        byte[] byteConversationIndex = this.getByteItem(113);
        if (byteConversationIndex != null) {
            this.msgConversationIndex = new MsgConversationIndex(byteConversationIndex);
            if (this.msgConversationIndex.getGuid() == null) {
                this.msgConversationIndex = null;
            }
        }
    }

    @Override
    protected long getNativeMessageSize() {
        return this.size;
    }

    private String getStringItem(int item) throws InterruptedException {
        String result = "";
        MAPIProperty prop = MAPIProperty.get(item);
        List<Chunk> lChunk = this.message.getMainChunks().getAll().get(prop);
        if (lChunk != null) {
            if (lChunk.size() > 1) {
                this.logMessageWarning("mailextractlib.msg: multiple MSG object [" + prop.name + "], keep the first one", null);
            }
            if (lChunk.get(0) instanceof StringChunk) {
                StringChunk sChunk = (StringChunk)lChunk.get(0);
                result = sChunk.getValue();
            } else {
                this.logMessageWarning("mailextractlib.msg: unexpected MSG object type [" + prop.name + "]", null);
            }
        }
        return result;
    }

    private byte[] getByteItem(int item) throws InterruptedException {
        byte[] result = null;
        MAPIProperty prop = MAPIProperty.get(item);
        List<Chunk> lChunk = this.message.getMainChunks().getAll().get(prop);
        if (lChunk != null) {
            if (lChunk.size() > 1) {
                this.logMessageWarning("mailextractlib.msg: multiple MSG object [" + prop.name + "], keep the first one", null);
            }
            if (lChunk.get(0) instanceof ByteChunk) {
                ByteChunk bChunk = (ByteChunk)lChunk.get(0);
                result = bChunk.getValue();
            } else {
                this.logMessageWarning("mailextractlib.msg: unexpected MSG object type [" + prop.name + "]", null);
            }
        }
        return result;
    }

    private Date getDateItem(int item) {
        Calendar cal;
        Date result = null;
        MAPIProperty prop = MAPIProperty.get(item);
        List<PropertyValue> lVal = this.message.getMainChunks().getMessageProperties().getProperties().get(prop);
        if (lVal != null && (cal = (Calendar)lVal.get(0).getValue()) != null) {
            result = cal.getTime();
        }
        return result;
    }

    @Override
    protected String getNativeSmtpTransportHeader() throws InterruptedException {
        return this.getStringItem(125);
    }

    @Override
    protected String getNativeSubject() throws InterruptedException {
        return this.getStringItem(55);
    }

    @Override
    protected String getNativeInternetMessageId() throws InterruptedException {
        return this.getStringItem(4149);
    }

    @Override
    protected String getNativeSenderName() throws InterruptedException {
        return this.getStringItem(3098);
    }

    @Override
    protected String getNativeSentRepresentingName() throws InterruptedException {
        return this.getStringItem(66);
    }

    @Override
    protected String getNativeSenderAddrType() throws InterruptedException {
        return this.getStringItem(3102);
    }

    @Override
    protected String getNativeSenderEmailAddress() throws InterruptedException {
        return this.getStringItem(3103);
    }

    @Override
    protected String getNativeSentRepresentingAddrType() throws InterruptedException {
        return this.getStringItem(100);
    }

    @Override
    protected String getNativeSentRepresentingEmailAddress() throws InterruptedException {
        return this.getStringItem(101);
    }

    @Override
    protected String getNativeReturnPath() throws InterruptedException {
        return this.getStringItem(4166);
    }

    @Override
    protected Date getNativeMessageDeliveryTime() {
        return this.getDateItem(3590);
    }

    @Override
    protected Date getNativeClientSubmitTime() {
        return this.getDateItem(57);
    }

    @Override
    protected String getNativeInReplyToId() throws InterruptedException {
        return this.getStringItem(4162);
    }

    @Override
    protected boolean hasNativeConversationIndex() {
        return this.msgConversationIndex != null;
    }

    @Override
    protected Date getNativeCIDeliveryTime() {
        return this.msgConversationIndex.getDeliveryTime();
    }

    @Override
    protected UUID getNativeCIGuid() {
        return this.msgConversationIndex.getGuid();
    }

    @Override
    protected int getNativeCINumberOfResponseLevels() {
        return this.msgConversationIndex.getResponseLevels().size();
    }

    @Override
    protected short getNativeCIResponseLevelDeltaCode(int responseLevelNumber) {
        return this.msgConversationIndex.getResponseLevels().get((int)responseLevelNumber).deltaCode;
    }

    @Override
    protected long getNativeCIResponseLevelTimeDelta(int responseLevelNumber) {
        return this.msgConversationIndex.getResponseLevels().get((int)responseLevelNumber).timeDelta;
    }

    @Override
    protected short getNativeCIResponseLevelRandom(int responseLevelNumber) {
        return this.msgConversationIndex.getResponseLevels().get((int)responseLevelNumber).random;
    }

    @Override
    protected int getNativeNumberOfRecipients() {
        return this.message.getRecipientDetailsChunks().length;
    }

    @Override
    protected String getNativeRecipientsSmtpAddress(int recipientNumber) {
        return this.message.getRecipientDetailsChunks()[recipientNumber].getRecipientSMTPChunk().getValue();
    }

    @Override
    protected String getNativeRecipientsEmailAddress(int recipientNumber) {
        return this.message.getRecipientDetailsChunks()[recipientNumber].getRecipientEmailChunk().getValue();
    }

    @Override
    protected String getNativeRecipientsDisplayName(int recipientNumber) {
        return this.message.getRecipientDetailsChunks()[recipientNumber].getRecipientNameChunk().getValue();
    }

    @Override
    protected int getNativeRecipientsType(int recipientNumber) {
        return (Integer)this.message.getRecipientDetailsChunks()[recipientNumber].getProperties().get(MAPIProperty.RECIPIENT_TYPE).get(0).getValue();
    }

    @Override
    protected String getNativeBodyText() {
        String result;
        try {
            result = this.message.getTextBody();
        }
        catch (ChunkNotFoundException e) {
            result = "";
        }
        return result;
    }

    @Override
    protected String getNativeBodyHTML() {
        String result;
        try {
            result = this.message.getHtmlBody();
        }
        catch (ChunkNotFoundException e) {
            result = "";
        }
        return result;
    }

    @Override
    protected String getNativeRTFBody() {
        String result;
        try {
            result = this.message.getRtfBody();
        }
        catch (ChunkNotFoundException e) {
            result = "";
        }
        return result;
    }

    @Override
    public String getEmbeddedMessageScheme() {
        return EMBEDDED_MESSAGE;
    }

    @Override
    protected MicrosoftStoreMessageAttachment[] getNativeAttachments() {
        AttachmentChunks[] allAttachmentChunks = this.message.getAttachmentFiles();
        MicrosoftStoreMessageAttachment[] msgAttachments = new MsgStoreMessageAttachment[allAttachmentChunks.length];
        for (int i = 0; i < allAttachmentChunks.length; ++i) {
            msgAttachments[i] = new MsgStoreMessageAttachment(allAttachmentChunks[i]);
        }
        return msgAttachments;
    }
}

