/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.store.microsoft.msg;

import fr.gouv.vitam.tools.mailextractlib.core.StoreAttachment;
import fr.gouv.vitam.tools.mailextractlib.core.StoreFolder;
import fr.gouv.vitam.tools.mailextractlib.nodes.ArchiveUnit;
import fr.gouv.vitam.tools.mailextractlib.store.microsoft.msg.MsgStoreExtractor;
import fr.gouv.vitam.tools.mailextractlib.store.microsoft.msg.MsgStoreMessage;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractLibException;
import org.apache.poi.hsmf.MAPIMessage;

public class MsgStoreFolder
extends StoreFolder {
    MsgStoreMessage msgStoreMessage;

    public MsgStoreFolder(MsgStoreExtractor storeExtractor, MAPIMessage message, long size) throws InterruptedException {
        super(storeExtractor);
        this.msgStoreMessage = new MsgStoreMessage(this, message, size);
    }

    public static MsgStoreFolder createRootFolder(MsgStoreExtractor storeExtractor, MAPIMessage message, long size, ArchiveUnit rootArchiveUnit) throws InterruptedException {
        MsgStoreFolder result = new MsgStoreFolder(storeExtractor, message, size);
        result.folderArchiveUnit = rootArchiveUnit;
        return result;
    }

    @Override
    public boolean hasElements() throws MailExtractLibException {
        return true;
    }

    @Override
    public boolean hasSubfolders() throws MailExtractLibException {
        return false;
    }

    @Override
    protected void doExtractFolderElements(boolean writeFlag) throws MailExtractLibException, InterruptedException {
        this.msgStoreMessage.processElement(writeFlag);
        StoreAttachment attachment = ((MsgStoreExtractor)this.storeExtractor).getAttachment();
        if (attachment != null) {
            attachment.setStoreContent(this.msgStoreMessage.getMimeContent());
            attachment.setMimeType("message/rfc822");
            if (attachment.getName() == null || attachment.getName().isEmpty()) {
                attachment.setName(this.msgStoreMessage.getSubject() + ".eml");
            }
        }
    }

    @Override
    protected void doExtractSubFolders(int level, boolean writeFlag) throws MailExtractLibException {
    }

    @Override
    public String getFullName() {
        return "";
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    protected void doListFolderElements(boolean stats) throws MailExtractLibException, InterruptedException {
        this.msgStoreMessage.listElement(stats);
    }

    @Override
    protected void doListSubFolders(boolean stats) throws MailExtractLibException {
    }
}

