/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.store.microsoft.msg;

import fr.gouv.vitam.tools.mailextractlib.core.StoreAttachment;
import fr.gouv.vitam.tools.mailextractlib.core.StoreElement;
import fr.gouv.vitam.tools.mailextractlib.core.StoreExtractor;
import fr.gouv.vitam.tools.mailextractlib.core.StoreExtractorOptions;
import fr.gouv.vitam.tools.mailextractlib.nodes.ArchiveUnit;
import fr.gouv.vitam.tools.mailextractlib.store.microsoft.msg.MsgStoreFolder;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractLibException;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractProgressLogger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import org.apache.poi.hsmf.MAPIMessage;

public class MsgStoreExtractor
extends StoreExtractor {
    private StoreAttachment attachment;
    static final byte[] MSG_MN = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31};

    public static void subscribeStoreExtractor() {
        MsgStoreExtractor.addExtractionRelation("application/vnd.ms-outlook", "x-fmt/430", "msg", false, MsgStoreExtractor.class);
        MsgStoreExtractor.addExtractionRelation(null, null, "msg.embeddedmsg", false, MsgStoreExtractor.class);
    }

    public MsgStoreExtractor(String urlString, String folder, String destPathString, StoreExtractorOptions options, StoreExtractor rootStoreExtractor, MailExtractProgressLogger logger) throws MailExtractLibException, InterruptedException {
        super(urlString, folder, destPathString, options, rootStoreExtractor, null, logger);
        long size;
        MAPIMessage message;
        try {
            File messageFile = new File(this.path);
            message = new MAPIMessage(messageFile);
            size = Files.size(messageFile.toPath());
        }
        catch (Exception e) {
            throw new MailExtractLibException("mailextractlib.msg: can't open " + this.path + ", doesn't exist or is not a msg file", e);
        }
        ArchiveUnit rootNode = new ArchiveUnit(this, this.destRootPath, this.destName);
        this.setRootFolder(MsgStoreFolder.createRootFolder(this, message, size, rootNode));
    }

    public MsgStoreExtractor(StoreAttachment attachment, ArchiveUnit rootNode, StoreExtractorOptions options, StoreExtractor rootStoreExtractor, StoreElement fatherElement, MailExtractProgressLogger logger) throws MailExtractLibException, InterruptedException {
        super("msg.embeddedmsg://localhost/", "", rootNode.getFullName(), options, rootStoreExtractor, fatherElement, logger);
        MAPIMessage message;
        this.attachment = attachment;
        if (attachment.getStoreContent() instanceof MAPIMessage) {
            message = (MAPIMessage)attachment.getStoreContent();
        } else if (attachment.getStoreContent() instanceof byte[]) {
            ByteArrayInputStream bais = new ByteArrayInputStream((byte[])attachment.getStoreContent());
            try {
                message = new MAPIMessage(bais);
            }
            catch (IOException e) {
                throw new MailExtractLibException("mailextractlib.msg: can't extract msg store", e);
            }
        } else {
            throw new MailExtractLibException("mailextractlib.msg: can't extract msg store", null);
        }
        this.setRootFolder(MsgStoreFolder.createRootFolder(this, message, 0L, rootNode));
    }

    @Override
    public StoreAttachment getAttachment() {
        return this.attachment;
    }

    @Override
    public boolean canExtractObjectsLists() {
        return false;
    }

    public static String getVerifiedScheme(byte[] content) {
        if (MsgStoreExtractor.hasMagicNumber(content, MSG_MN)) {
            return "msg";
        }
        return null;
    }
}

