/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.store.microsoft.msg;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class MsgConversationIndex {
    private static final int HUNDRED_NS_TO_MS = 1000;
    private static final int MINIMUM_HEADER_SIZE = 22;
    private static final int RESPONSE_LEVEL_SIZE = 5;
    private Date deliveryTime;
    private UUID guid;
    private List<MicrosoftResponseLevel> responseLevels = new ArrayList<MicrosoftResponseLevel>();
    private static final long EPOCH_DIFF = 11644473600000L;

    public Date getDeliveryTime() {
        return this.deliveryTime;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public List<MicrosoftResponseLevel> getResponseLevels() {
        return this.responseLevels;
    }

    public String toString() {
        return this.guid + "@" + this.deliveryTime + " " + this.responseLevels.size() + " ResponseLevels";
    }

    protected MsgConversationIndex(byte[] rawConversationIndex) {
        if (rawConversationIndex != null && rawConversationIndex.length >= 22) {
            this.decodeHeader(rawConversationIndex);
            if (rawConversationIndex.length >= 27) {
                this.decodeResponseLevel(rawConversationIndex);
            }
        }
    }

    private static long convertBigEndianBytesToLong(byte[] data, int start, int end) {
        long offset = 0L;
        for (int x = start; x < end; ++x) {
            offset <<= 8;
            offset |= (long)data[x] & 0xFFL;
        }
        return offset;
    }

    private static Date filetimeToDate(int high, int low) {
        long filetime = (long)high << 32 | (long)low & 0xFFFFFFFFL;
        long ms_since_16010101 = filetime / 10000L;
        long ms_since_19700101 = ms_since_16010101 - 11644473600000L;
        return new Date(ms_since_19700101);
    }

    private void decodeHeader(byte[] rawConversationIndex) {
        long deliveryTimeHigh = MsgConversationIndex.convertBigEndianBytesToLong(rawConversationIndex, 0, 4);
        long deliveryTimeLow = MsgConversationIndex.convertBigEndianBytesToLong(rawConversationIndex, 4, 6) << 16;
        this.deliveryTime = MsgConversationIndex.filetimeToDate((int)deliveryTimeHigh, (int)deliveryTimeLow);
        long guidHigh = MsgConversationIndex.convertBigEndianBytesToLong(rawConversationIndex, 6, 14);
        long guidLow = MsgConversationIndex.convertBigEndianBytesToLong(rawConversationIndex, 14, 22);
        this.guid = new UUID(guidHigh, guidLow);
    }

    private void decodeResponseLevel(byte[] rawConversationIndex) {
        int responseLevelCount = (rawConversationIndex.length - 22) / 5;
        this.responseLevels = new ArrayList<MicrosoftResponseLevel>(responseLevelCount);
        int responseLevelIndex = 0;
        int position = 22;
        while (responseLevelIndex < responseLevelCount) {
            long responseLevelValue = MsgConversationIndex.convertBigEndianBytesToLong(rawConversationIndex, position, position + 5);
            short deltaCode = (short)(responseLevelValue >> 39);
            short random = (short)(responseLevelValue & 0xFFL);
            long deltaTime = responseLevelValue >> 8 & Integer.MAX_VALUE;
            deltaTime = deltaCode == 0 ? (deltaTime <<= 18) : (deltaTime <<= 23);
            this.responseLevels.add(responseLevelIndex, new MicrosoftResponseLevel(deltaCode, deltaTime /= 1000L, random));
            ++responseLevelIndex;
            position += 5;
        }
    }

    public class MicrosoftResponseLevel {
        short deltaCode;
        long timeDelta;
        short random;

        public MicrosoftResponseLevel(short deltaCode, long timeDelta, short random) {
            this.deltaCode = deltaCode;
            this.timeDelta = timeDelta;
            this.random = random;
        }

        public short getDeltaCode() {
            return this.deltaCode;
        }

        public long getTimeDelta() {
            return this.timeDelta;
        }

        public short getRandom() {
            return this.random;
        }

        public Date withOffset(Date anchorDate) {
            return new Date(anchorDate.getTime() + this.timeDelta);
        }
    }
}

