/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.store.microsoft;

import fr.gouv.vitam.tools.mailextractlib.core.StoreExtractor;
import fr.gouv.vitam.tools.mailextractlib.core.StoreFolder;
import fr.gouv.vitam.tools.mailextractlib.core.StoreMessage;
import fr.gouv.vitam.tools.mailextractlib.store.microsoft.MicrosoftStoreElement;
import fr.gouv.vitam.tools.mailextractlib.store.microsoft.MicrosoftStoreMessageAttachment;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractProgressLogger;
import fr.gouv.vitam.tools.mailextractlib.utils.RFC822Headers;
import jakarta.mail.MessagingException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public abstract class MicrosoftStoreMessage
extends StoreMessage
implements MicrosoftStoreElement {
    protected RFC822Headers rfc822Headers;
    protected MicrosoftStoreMessageAttachment[] nativeAttachments;
    public static final int MAPI_TO = 1;
    public static final int MAPI_CC = 2;
    public static final int MAPI_BCC = 3;

    public MicrosoftStoreMessage(StoreFolder mBFolder) {
        super(mBFolder);
    }

    @Override
    public long getMessageSize() {
        long result = this.getNativeMessageSize();
        if (result == 0L && this.mimeContent != null) {
            result = this.mimeContent.length;
        }
        return result;
    }

    protected abstract String getNativeSmtpTransportHeader() throws InterruptedException;

    protected abstract String getNativeSubject() throws InterruptedException;

    protected abstract String getNativeInternetMessageId() throws InterruptedException;

    protected abstract String getNativeSenderName() throws InterruptedException;

    protected abstract String getNativeSentRepresentingName() throws InterruptedException;

    protected abstract String getNativeSenderAddrType() throws InterruptedException;

    protected abstract String getNativeSenderEmailAddress() throws InterruptedException;

    protected abstract String getNativeSentRepresentingAddrType() throws InterruptedException;

    protected abstract String getNativeSentRepresentingEmailAddress() throws InterruptedException;

    protected abstract String getNativeReturnPath() throws InterruptedException;

    protected abstract Date getNativeMessageDeliveryTime();

    protected abstract Date getNativeClientSubmitTime();

    protected abstract String getNativeInReplyToId() throws InterruptedException;

    protected abstract long getNativeMessageSize();

    protected abstract boolean hasNativeConversationIndex();

    protected abstract Date getNativeCIDeliveryTime();

    protected abstract UUID getNativeCIGuid();

    protected abstract int getNativeCINumberOfResponseLevels();

    protected abstract short getNativeCIResponseLevelDeltaCode(int var1);

    protected abstract long getNativeCIResponseLevelTimeDelta(int var1);

    protected abstract short getNativeCIResponseLevelRandom(int var1);

    protected abstract int getNativeNumberOfRecipients();

    protected abstract String getNativeRecipientsSmtpAddress(int var1);

    protected abstract String getNativeRecipientsEmailAddress(int var1);

    protected abstract String getNativeRecipientsDisplayName(int var1);

    protected abstract int getNativeRecipientsType(int var1);

    protected abstract String getNativeBodyText();

    protected abstract String getNativeBodyHTML();

    protected abstract String getNativeRTFBody();

    protected abstract MicrosoftStoreMessageAttachment[] getNativeAttachments();

    private boolean hasRFC822Headers() {
        return this.rfc822Headers != null;
    }

    @Override
    protected void prepareAnalyze() throws InterruptedException {
        String headerString;
        if (!this.hasRFC822Headers() && (headerString = this.getNativeSmtpTransportHeader()) != null && !headerString.isEmpty()) {
            try {
                this.rfc822Headers = new RFC822Headers(headerString, this);
                this.mailHeader = Collections.list(this.rfc822Headers.getAllHeaderLines());
            }
            catch (MessagingException e) {
                this.logMessageWarning("mailextractlib.microsoft: can't decode smtp header", e);
                this.rfc822Headers = null;
                this.mailHeader = null;
            }
        }
        this.nativeAttachments = this.getNativeAttachments();
    }

    @Override
    protected void analyzeSubject() throws InterruptedException {
        String result = null;
        if (this.hasRFC822Headers()) {
            String[] sList = this.rfc822Headers.getHeader("Subject");
            if (sList != null) {
                if (sList.length > 1) {
                    this.logMessageWarning("mailextractlib.microsoft: multiple subjects, keep the first one in header", null);
                }
                if ((result = RFC822Headers.getHeaderValue(sList[0])) != null && result.contains("=?")) {
                    result = RFC822Headers.decodeRfc2047Flexible(result);
                }
            }
        } else {
            result = this.getNativeSubject();
            if (result.length() >= 2 && result.charAt(0) == '\u0001') {
                result = result.length() == 2 ? "" : result.substring(2);
            }
            if (result.isEmpty()) {
                result = null;
            }
        }
        if (result == null) {
            MailExtractProgressLogger.doProgressLog(this.getProgressLogger(), 60, "mailextractlib.microsoft: no subject in header", null);
        }
        this.subject = result;
    }

    @Override
    protected void analyzeMessageID() throws InterruptedException {
        Object result = null;
        if (this.hasRFC822Headers()) {
            String[] mList = this.rfc822Headers.getHeader("message-ID");
            if (mList != null) {
                if (mList.length > 1) {
                    this.logMessageWarning("mailextractlib.microsoft: multiple message ID, keep the first one in header", null);
                }
                result = RFC822Headers.getHeaderValue(mList[0]);
            }
        } else {
            try {
                result = this.getNativeInternetMessageId();
                if (((String)result).isEmpty() && this.hasNativeConversationIndex()) {
                    Instant inst = this.getNativeCIDeliveryTime().toInstant();
                    ZonedDateTime zdt = ZonedDateTime.ofInstant(inst, ZoneOffset.UTC);
                    result = "<MIC:" + this.getNativeCIGuid() + "@" + zdt.format(StoreExtractor.ISO_8601);
                    int responseLevelNumber = this.getNativeCINumberOfResponseLevels();
                    for (int i = 0; i < responseLevelNumber; ++i) {
                        result = (String)result + "+" + Integer.toHexString(this.getNativeCIResponseLevelDeltaCode(i));
                        result = (String)result + Long.toHexString(this.getNativeCIResponseLevelTimeDelta(i));
                        result = (String)result + Integer.toHexString(this.getNativeCIResponseLevelRandom(i));
                    }
                    result = (String)result + ">";
                }
            }
            catch (Exception e) {
                this.logMessageWarning("mailextractlib.microsoft: error during Message ID extraction", e);
                result = "NoMessageID";
            }
        }
        if (result == null) {
            this.logMessageWarning("mailextractlib.microsoft: no Message ID address in header", null);
            result = "NoMessageID";
        }
        this.messageID = result;
    }

    private String getSenderName() throws InterruptedException {
        String result = this.getNativeSenderName();
        if (result == null || result.isEmpty()) {
            result = this.getNativeSentRepresentingName();
        }
        if (result.isEmpty()) {
            result = null;
        }
        return result;
    }

    private String getSenderEmailAddress() throws InterruptedException {
        String result = "";
        if (this.getNativeSenderAddrType().equalsIgnoreCase("SMTP")) {
            result = this.getNativeSenderEmailAddress();
        }
        if (result.isEmpty() && this.getNativeSentRepresentingAddrType().equalsIgnoreCase("SMTP")) {
            result = this.getNativeSentRepresentingEmailAddress();
        }
        if (result.isEmpty()) {
            result = this.getNativeSenderEmailAddress();
        }
        if (result.isEmpty()) {
            result = this.getNativeSentRepresentingEmailAddress();
        }
        if (result.isEmpty()) {
            result = null;
        }
        return result;
    }

    static String getFormattedAddress(String name, String smtpAddress) {
        Object result = null;
        result = name != null ? (smtpAddress != null ? name + " <" + smtpAddress + ">" : name) : smtpAddress;
        return result;
    }

    @Override
    protected void analyzeFrom() throws InterruptedException {
        String result = null;
        if (this.hasRFC822Headers()) {
            String[] fromArray = this.rfc822Headers.getHeader("From");
            if (fromArray != null) {
                if (fromArray.length == 1) {
                    result = RFC822Headers.getHeaderValue(fromArray[0]);
                } else {
                    List<String> fromList = new ArrayList<String>();
                    for (String header : fromArray) {
                        fromList.add(RFC822Headers.getHeaderValue(header));
                    }
                    if ((fromList = RFC822Headers.removeInvalidAndDuplicatesFromAddressesList(fromList)).size() > 1) {
                        result = String.join((CharSequence)", ", fromList);
                        this.logMessageWarning("mailextractlib.microsoft: multiple From addresses [" + result + "]", null);
                    } else {
                        result = fromList.get(0);
                    }
                }
                if (result != null && result.contains("=?")) {
                    result = RFC822Headers.decodeRfc2047Flexible(result);
                }
            }
        } else {
            String fromName = this.getSenderName();
            String fromAddress = this.getSenderEmailAddress();
            result = MicrosoftStoreMessage.getFormattedAddress(fromName, fromAddress);
        }
        if (result == null) {
            this.logMessageWarning("mailextractlib.microsoft: no From address in header", null);
        }
        this.from = result;
    }

    @Override
    protected void analyzeRecipients() throws InterruptedException {
        if (this.hasRFC822Headers()) {
            this.recipientTo = this.rfc822Headers.getAddressHeader("To");
            this.recipientCc = this.rfc822Headers.getAddressHeader("cc");
            this.recipientBcc = this.rfc822Headers.getAddressHeader("bcc");
        } else {
            int recipientNumber;
            this.recipientTo = new ArrayList();
            this.recipientCc = new ArrayList();
            this.recipientBcc = new ArrayList();
            try {
                recipientNumber = this.getNativeNumberOfRecipients();
            }
            catch (Exception e) {
                this.logMessageWarning("mailextractlib.microsoft: can't determine recipient list", e);
                recipientNumber = 0;
            }
            for (int i = 0; i < recipientNumber; ++i) {
                try {
                    String emailAddress = this.getNativeRecipientsSmtpAddress(i);
                    if (emailAddress == null || emailAddress.isEmpty()) {
                        emailAddress = this.getNativeRecipientsEmailAddress(i);
                    }
                    String normAddress = MicrosoftStoreMessage.getFormattedAddress(this.getNativeRecipientsDisplayName(i), emailAddress);
                    switch (this.getNativeRecipientsType(i)) {
                        case 1: {
                            this.recipientTo.add(normAddress);
                            break;
                        }
                        case 2: {
                            this.recipientCc.add(normAddress);
                            break;
                        }
                        case 3: {
                            this.recipientBcc.add(normAddress);
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    this.logMessageWarning("mailextractlib.microsoft: can't get recipient number " + Integer.toString(i), e);
                }
            }
        }
    }

    @Override
    protected void analyzeReplyTo() throws InterruptedException {
        List<String> result = null;
        if (this.hasRFC822Headers()) {
            result = this.rfc822Headers.getAddressHeader("Reply-To");
        }
        this.replyTo = result;
    }

    @Override
    protected void analyzeReturnPath() throws InterruptedException {
        String[] rpArray;
        String result = null;
        if (this.hasRFC822Headers() && (rpArray = this.rfc822Headers.getHeader("Return-Path")) != null) {
            if (rpArray.length == 1) {
                result = RFC822Headers.getHeaderValue(rpArray[0]);
            } else {
                List<String> rpList = new ArrayList<String>();
                for (String header : rpArray) {
                    rpList.add(RFC822Headers.getHeaderValue(header));
                }
                if ((rpList = RFC822Headers.removeInvalidAndDuplicatesFromAddressesList(rpList)).size() > 1) {
                    result = String.join((CharSequence)", ", rpList);
                    this.logMessageWarning("mailextractlib.microsoft: multiple Return-Path addresses [" + result + "]", null);
                } else {
                    result = rpList.get(0);
                }
            }
            if (result != null && result.contains("=?")) {
                result = RFC822Headers.decodeRfc2047Flexible(result);
            }
        }
        this.returnPath = result;
    }

    @Override
    protected void analyzeDates() {
        this.receivedDate = this.getNativeMessageDeliveryTime();
        this.sentDate = this.getNativeClientSubmitTime();
    }

    @Override
    protected void analyzeInReplyToId() throws InterruptedException {
        Object result = null;
        if (this.hasRFC822Headers()) {
            String[] irtList = this.rfc822Headers.getHeader("In-Reply-To");
            if (irtList != null) {
                if (irtList.length > 1) {
                    this.logMessageWarning("mailextractlib.microsoft: multiple In-Reply-To identifiers, keep the first one in header", null);
                }
                result = RFC822Headers.getHeaderValue(irtList[0]);
            }
        } else {
            result = this.getNativeInReplyToId();
            if (((String)result).isEmpty()) {
                if (this.messageID == null) {
                    this.analyzeMessageID();
                }
                if (this.messageID != null && this.messageID.startsWith("<MIC:")) {
                    result = this.messageID.lastIndexOf(43) > this.messageID.lastIndexOf(64) ? this.messageID.substring(0, this.messageID.lastIndexOf(43)) + ">" : null;
                }
            }
        }
        this.inReplyToUID = result;
    }

    @Override
    protected void analyzeReferences() {
        List<String> result = null;
        if (this.hasRFC822Headers()) {
            result = this.rfc822Headers.getReferences();
        }
        this.references = result;
    }

    @Override
    protected void analyzeBodies() {
        String result = this.getNativeBodyText();
        if (result.isEmpty()) {
            result = null;
        }
        this.bodyContent[0] = result;
        result = this.getNativeBodyHTML();
        if (result.isEmpty()) {
            result = null;
        }
        this.bodyContent[1] = result;
        result = this.getNativeRTFBody();
        if (result.isEmpty()) {
            result = null;
        }
        this.bodyContent[2] = result;
    }

    @Override
    protected void analyzeAttachments() throws InterruptedException {
        this.attachments = MicrosoftStoreElement.getAttachments(this, this.nativeAttachments);
    }

    @Override
    protected byte[] getNativeMimeContent() {
        return null;
    }
}

