/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.store.microsoft;

import fr.gouv.vitam.tools.mailextractlib.core.StoreAttachment;
import fr.gouv.vitam.tools.mailextractlib.core.StoreElement;
import fr.gouv.vitam.tools.mailextractlib.store.microsoft.MicrosoftStoreMessageAttachment;
import java.util.ArrayList;
import java.util.List;

public interface MicrosoftStoreElement {
    public String getEmbeddedMessageScheme();

    public static String getAttachementFilename(MicrosoftStoreMessageAttachment nativeAttachment) {
        String result = nativeAttachment.longFilename;
        if (result.isEmpty()) {
            result = nativeAttachment.filename;
        }
        if (result.isEmpty()) {
            result = nativeAttachment.displayName;
        }
        return result;
    }

    public static List<StoreAttachment> getAttachments(StoreElement element, MicrosoftStoreMessageAttachment[] nativeAttachments) throws InterruptedException {
        int attachmentNumber;
        ArrayList<StoreAttachment> result = new ArrayList<StoreAttachment>();
        try {
            attachmentNumber = nativeAttachments.length;
        }
        catch (Exception e) {
            element.logMessageWarning("mailextractlib.microsoft: can't determine attachment list", e);
            attachmentNumber = 0;
        }
        for (int i = 0; i < attachmentNumber; ++i) {
            try {
                switch (nativeAttachments[i].attachMethod) {
                    case 0: {
                        break;
                    }
                    case 6: {
                        element.logMessageWarning("mailextractlib.microsoft: can't extract OLE attachment", null);
                        break;
                    }
                    case 1: {
                        StoreAttachment attachment = new StoreAttachment(element, nativeAttachments[i].byteArray, "file", MicrosoftStoreElement.getAttachementFilename(nativeAttachments[i]), nativeAttachments[i].creationTime, nativeAttachments[i].modificationTime, nativeAttachments[i].mimeTag, nativeAttachments[i].contentId, 1);
                        result.add(attachment);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        element.logMessageWarning("mailextractlib.microsoft: can't extract reference attachment", null);
                        break;
                    }
                    case 5: {
                        if (!(element instanceof MicrosoftStoreElement)) break;
                        StoreAttachment attachment = new StoreAttachment(element, nativeAttachments[i].embeddedMessage, ((MicrosoftStoreElement)((Object)element)).getEmbeddedMessageScheme(), MicrosoftStoreElement.getAttachementFilename(nativeAttachments[i]), nativeAttachments[i].creationTime, nativeAttachments[i].modificationTime, nativeAttachments[i].mimeTag, nativeAttachments[i].contentId, 2);
                        result.add(attachment);
                    }
                }
                continue;
            }
            catch (Exception e) {
                element.logMessageWarning("mailextractlib.microsoft: can't get attachment number " + Integer.toString(i), e);
            }
        }
        return result;
    }
}

