/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.store.javamail.thunderbird;

import fr.gouv.vitam.tools.mailextractlib.store.javamail.thunderbird.ThunderbirdFolder;
import jakarta.mail.Folder;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.URLName;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class ThunderbirdStore
extends Store {
    private String container;

    public String getContainer() {
        return this.container;
    }

    public ThunderbirdStore(Session session, URLName url) {
        super(session, url);
        try {
            this.container = URLDecoder.decode(url.getFile(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    @Override
    protected boolean protocolConnect(String host, int port, String user, String passwd) throws MessagingException {
        if (passwd != null && !passwd.isEmpty()) {
            throw new MessagingException("ThunderMBox: does not allow passwords");
        }
        if (port != -1) {
            throw new MessagingException("ThunderMBox: does not allow port selection");
        }
        File test = new File(this.container);
        if (!test.isDirectory()) {
            throw new MessagingException("ThunderMBox: " + this.container + " is not an existing directory");
        }
        return true;
    }

    @Override
    public Folder getDefaultFolder() throws MessagingException {
        return new ThunderbirdFolder(this, null, 2);
    }

    @Override
    public Folder getFolder(String name) throws MessagingException {
        if (name.equals(this.container)) {
            name = null;
        } else if (name.startsWith(this.container)) {
            name = name.substring(this.container.length() + 1);
        }
        return new ThunderbirdFolder(this, name);
    }

    @Override
    public Folder getFolder(URLName url) throws MessagingException {
        String filename = "";
        try {
            filename = URLDecoder.decode(url.getFile(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (!filename.startsWith(this.container)) {
            throw new MessagingException("ThunderMBox: folder must be in directory declared for the store");
        }
        return this.getFolder(url.getFile().substring(this.container.length()));
    }
}

