/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.store.javamail.thunderbird;

import fr.gouv.vitam.tools.mailextractlib.store.javamail.JMMimeMessage;
import fr.gouv.vitam.tools.mailextractlib.store.javamail.mbox.MboxReader;
import fr.gouv.vitam.tools.mailextractlib.store.javamail.thunderbird.ThunderbirdStore;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractProgressLogger;
import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.FolderNotFoundException;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.MethodNotSupportedException;
import jakarta.mail.URLName;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.angus.mail.imap.protocol.BASE64MailboxDecoder;

public class ThunderbirdFolder
extends Folder {
    private String folderFullName;
    private int total;
    private volatile boolean opened = false;
    private int holdsFlags;
    private List<MessageFork> messages;
    private ThunderbirdStore mstore;
    private File folderFile;
    private MboxReader mboxfilereader;
    private MailExtractProgressLogger logger;

    public void setLogger(MailExtractProgressLogger logger) {
        this.logger = logger;
    }

    public ThunderbirdFolder(ThunderbirdStore store, String folderFullName) throws MessagingException {
        super(store);
        this.mstore = store;
        this.folderFullName = folderFullName;
        this.holdsFlags = (this.isBoxHoldingMessages(folderFullName) ? 1 : 0) | (this.isBoxHoldingFolders(folderFullName) ? 2 : 0);
        if (folderFullName != null) {
            this.folderFile = new File(this.getFilePathFromFolderFullName(folderFullName));
        }
    }

    public ThunderbirdFolder(ThunderbirdStore store, String folderFullName, int holdsFlags) throws MessagingException {
        super(store);
        this.mstore = store;
        this.folderFullName = folderFullName;
        this.holdsFlags = holdsFlags;
        if (folderFullName != null) {
            this.folderFile = new File(this.getFilePathFromFolderFullName(folderFullName));
        }
    }

    private String getFilePathFromFolderFullName(String folderFullName) {
        return this.mstore.getContainer() + File.separator + folderFullName.replace(File.separator, ".sbd" + File.separator);
    }

    private String getSubFolderDirectoryPathFromFolderFullName(String folderPath) {
        return this.mstore.getContainer() + File.separator + folderPath.replace(File.separator, ".sbd" + File.separator) + ".sbd";
    }

    private String getIndexFilePathFromFolderFullName(String folderPath) {
        return this.mstore.getContainer() + File.separator + folderPath.replace(File.separator, ".sbd" + File.separator) + ".msf";
    }

    private String getFolderNameFromFileName(String fileName) {
        return fileName;
    }

    private String getFolderNameFromIndexFileName(String fileName) {
        if (fileName.endsWith(".msf")) {
            return fileName.substring(0, fileName.length() - 4);
        }
        return fileName;
    }

    private String getFolderNameFromSubFolderDirectoryName(String fileName) {
        if (fileName.endsWith(".sbd")) {
            return fileName.substring(0, fileName.length() - 4);
        }
        return fileName;
    }

    private String getFolderFullNameFromPath(String filePath) {
        String result = filePath.substring(this.mstore.getContainer().length() + 1);
        result = result.replace(".sbd" + File.separator, File.separator);
        return result;
    }

    private String getSubFolderFullName(String folderName) {
        return this.folderFullName == null ? folderName : this.folderFullName + File.separator + folderName;
    }

    @Override
    public String getName() {
        if (this.folderFullName == null) {
            return "";
        }
        return BASE64MailboxDecoder.decode(this.folderFile.getName());
    }

    @Override
    public String getFullName() {
        if (this.folderFullName == null) {
            return "";
        }
        return BASE64MailboxDecoder.decode(this.folderFullName);
    }

    private boolean isSubFoldersDirectory(File test) {
        if (!test.exists() || !test.isDirectory()) {
            return false;
        }
        if (!test.getName().endsWith(".sbd")) {
            MailExtractProgressLogger.doProgressLogWithoutInterruption(this.logger, 20, "ThunderMBox: Maybe sub folders directory " + test.getPath() + " without .sbd suffix is ignored", null);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isThundebirdMboxFile(File test) {
        if (!test.exists() || !test.isFile()) {
            return false;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(test)));
            String firstline = "";
            while (firstline.isEmpty() && (firstline = reader.readLine()) != null) {
                firstline = firstline.trim();
            }
            if (firstline == null || !firstline.startsWith("From")) {
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            MailExtractProgressLogger.doProgressLogWithoutInterruption(this.logger, 20, "ThunderMBox: Maybe mailbox file " + test.getPath() + " can't be opened and is ignored", e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
        test = new File(test.getPath() + ".msf");
        if (!test.exists()) {
            MailExtractProgressLogger.doProgressLogWithoutInterruption(this.logger, 20, "ThunderMBox: Maybe mailbox file " + test.getPath() + " don't have an index file but is analyzed", null);
        }
        return true;
    }

    private boolean isThunderIndexFile(File test) {
        if (!test.exists() || !test.isFile()) {
            return false;
        }
        return test.getName().endsWith(".msf");
    }

    private boolean isBoxHoldingMessages(String folderFullName) {
        if (folderFullName == null) {
            return false;
        }
        return this.isThundebirdMboxFile(new File(this.getFilePathFromFolderFullName(folderFullName)));
    }

    private boolean isBoxHoldingFolders(String folderFullName) {
        if (folderFullName == null) {
            return true;
        }
        return this.isSubFoldersDirectory(new File(this.getSubFolderDirectoryPathFromFolderFullName(folderFullName)));
    }

    private boolean isBox(String folderPath) {
        if (this.isThundebirdMboxFile(new File(this.getFilePathFromFolderFullName(folderPath)))) {
            return true;
        }
        if (this.isSubFoldersDirectory(new File(this.getSubFolderDirectoryPathFromFolderFullName(folderPath)))) {
            return true;
        }
        return this.isThunderIndexFile(new File(this.getIndexFilePathFromFolderFullName(folderPath)));
    }

    @Override
    public char getSeparator() {
        return File.separatorChar;
    }

    @Override
    public Folder[] list(String pattern) throws MessagingException {
        throw new MethodNotSupportedException("ThunderMBox: list with pattern not supported");
    }

    private static void addFlagHashMap(HashMap<String, Integer> hashMap, String name, int flag) {
        Integer oldFlag = hashMap.get(name);
        hashMap.put(name, oldFlag == null ? flag : oldFlag | flag);
    }

    @Override
    public Folder[] list() throws MessagingException {
        Folder[] result = new Folder[]{};
        Object sbdPath = this.folderFullName == null ? this.mstore.getContainer() : this.folderFile.getPath() + ".sbd";
        File folder = new File((String)sbdPath);
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles == null) {
            return result;
        }
        HashMap<String, Integer> boxes = new HashMap<String, Integer>();
        for (int i = 0; i < listOfFiles.length; ++i) {
            if (this.isSubFoldersDirectory(listOfFiles[i])) {
                ThunderbirdFolder.addFlagHashMap(boxes, this.getFolderNameFromSubFolderDirectoryName(listOfFiles[i].getName()), 2);
                continue;
            }
            if (this.isThundebirdMboxFile(listOfFiles[i])) {
                ThunderbirdFolder.addFlagHashMap(boxes, this.getFolderNameFromFileName(listOfFiles[i].getName()), 1);
                continue;
            }
            if (this.isThunderIndexFile(listOfFiles[i])) {
                ThunderbirdFolder.addFlagHashMap(boxes, this.getFolderNameFromIndexFileName(listOfFiles[i].getName()), 0);
                continue;
            }
            if (listOfFiles[i].isFile() && listOfFiles[i].length() == 0L) continue;
            MailExtractProgressLogger.doProgressLogWithoutInterruption(this.logger, 20, "ThunderMBox: Wrong mailbox file " + listOfFiles[i].getName() + " in " + (String)(this.folderFullName == null ? "root folder" : "folder " + this.folderFullName) + " is ignored", null);
        }
        ArrayList<ThunderbirdFolder> folders = new ArrayList<ThunderbirdFolder>();
        for (Map.Entry entry : boxes.entrySet()) {
            folders.add(new ThunderbirdFolder(this.mstore, this.getSubFolderFullName((String)entry.getKey()), (Integer)entry.getValue()));
        }
        result = folders.toArray(result);
        return result;
    }

    @Override
    public Folder getParent() throws MessagingException {
        if (this.folderFullName == null) {
            return this;
        }
        return this.getFolder(this.getFolderFullNameFromPath(this.folderFile.getParent()));
    }

    @Override
    public boolean exists() {
        if (this.folderFullName == null) {
            return true;
        }
        return this.isBox(this.folderFullName);
    }

    @Override
    public int getType() {
        return this.holdsFlags;
    }

    @Override
    public Flags getPermanentFlags() {
        return null;
    }

    @Override
    public boolean hasNewMessages() {
        return false;
    }

    @Override
    public Folder getFolder(String name) throws MessagingException {
        return new ThunderbirdFolder(this.mstore, this.getSubFolderFullName(name));
    }

    @Override
    public boolean create(int type) throws MessagingException {
        throw new MethodNotSupportedException("ThunderMBox: no writing supported");
    }

    @Override
    public boolean delete(boolean recurse) throws MessagingException {
        throw new MethodNotSupportedException("ThunderMBox: no writing supported");
    }

    @Override
    public boolean renameTo(Folder f) throws MessagingException {
        throw new MethodNotSupportedException("ThunderMBox: no writing supported");
    }

    @Override
    public boolean isOpen() {
        return this.opened;
    }

    @Override
    public void open(int mode) throws MessagingException {
        if (this.opened) {
            throw new IllegalStateException("ThunderMBox: Folder " + this.folderFullName + " is already open");
        }
        if ((this.getType() & 1) == 0) {
            throw new MessagingException("Folder " + this.folderFullName + " cannot contain messages");
        }
        if (!this.folderFile.exists()) {
            throw new FolderNotFoundException(this, "ThunderMBox: Folder " + this.folderFullName + " doesn't exist");
        }
        this.mode = mode;
        switch (mode) {
            case 2: {
                throw new MethodNotSupportedException("ThunderMBox: no writing supported");
            }
        }
        if (!this.folderFile.canRead()) {
            throw new MessagingException("ThunderMBox: open Failure, can't read: " + this.folderFile.getPath());
        }
        this.messages = new ArrayList<MessageFork>();
        try {
            this.mboxfilereader = new MboxReader(this.logger, this.folderFile);
            this.opened = true;
            this.mboxfilereader.getNextFromLineBeg();
            long beg = this.mboxfilereader.getLastFromLineEnd();
            while (beg != -1L) {
                long end = this.mboxfilereader.getNextFromLineBeg();
                MessageFork mf = new MessageFork(beg, end);
                this.messages.add(mf);
                beg = this.mboxfilereader.getLastFromLineEnd();
            }
        }
        catch (IOException e) {
            throw new MessagingException("ThunderMBox: open failure, can't read: " + this.folderFile.getPath());
        }
        this.total = this.messages.size();
    }

    @Override
    public void close(boolean expunge) throws MessagingException {
        if (!this.opened) {
            throw new IllegalStateException("ThunderMBox: Folder " + this.folderFullName + " is not Open");
        }
        this.messages = null;
        this.opened = false;
        try {
            this.mboxfilereader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int getMessageCount() throws MessagingException {
        if (!this.opened) {
            return -1;
        }
        return this.total;
    }

    @Override
    public Message getMessage(int msgno) throws MessagingException {
        if (msgno < 1) {
            throw new IndexOutOfBoundsException("message number " + msgno + " < 1");
        }
        if (msgno > this.total) {
            throw new IndexOutOfBoundsException("message number " + msgno + " > " + this.total);
        }
        JMMimeMessage m = new JMMimeMessage(this, this.mboxfilereader.newStream(this.messages.get((int)(msgno - 1)).beg, this.messages.get((int)(msgno - 1)).end), msgno);
        return m;
    }

    @Override
    public void appendMessages(Message[] msgs) throws MessagingException {
        throw new MethodNotSupportedException("ThunderMBox: no writing supported");
    }

    @Override
    public Message[] expunge() throws MessagingException {
        throw new MethodNotSupportedException("ThunderMBox: no writing supported");
    }

    @Override
    public URLName getURLName() {
        URLName storeURL = this.getStore().getURLName();
        return new URLName(storeURL.getProtocol(), storeURL.getHost(), storeURL.getPort(), this.mstore.getContainer() + File.separator + this.getFullName(), storeURL.getUsername(), null);
    }

    private class MessageFork {
        long beg;
        long end;

        MessageFork(long beg, long end) {
            this.beg = beg;
            this.end = end;
        }
    }
}

