/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.store.javamail.mbox;

import fr.gouv.vitam.tools.mailextractlib.store.javamail.JMEmbeddedStore;
import fr.gouv.vitam.tools.mailextractlib.store.javamail.mbox.MboxFolder;
import jakarta.mail.Folder;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.URLName;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

public class MboxStore
extends Store
implements JMEmbeddedStore {
    private String container;
    private byte[] objectContent;

    public String getContainer() {
        return this.container;
    }

    public MboxStore(Session session, URLName url) {
        super(session, url);
    }

    @Override
    protected boolean protocolConnect(String host, int port, String user, String passwd) throws MessagingException {
        if (this.objectContent == null) {
            if (!host.equals("localhost")) {
                throw new MessagingException("mbox: only support localhost");
            }
            if (passwd != null && !passwd.isEmpty()) {
                throw new MessagingException("mbox: does not allow passwords");
            }
            if (port != -1) {
                throw new MessagingException("mbox: does not allow port selection");
            }
            try {
                this.container = URLDecoder.decode(this.url.getFile(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new MessagingException("mbox: Can't decode the container file name");
            }
            File test = new File(this.container);
            if (!test.isFile()) {
                throw new MessagingException("mbox: " + this.container + " is not an existing file");
            }
        }
        return true;
    }

    @Override
    public Folder getDefaultFolder() throws MessagingException {
        return new MboxFolder(this);
    }

    @Override
    public Folder getFolder(String name) throws MessagingException {
        if (name == null || name.isEmpty()) {
            return new MboxFolder(this);
        }
        throw new MessagingException("mbox: only one root simulated folder, no " + name + " folder");
    }

    @Override
    public Folder getFolder(URLName url) throws MessagingException {
        if (url.getFile() == null || url.getFile().isEmpty()) {
            return new MboxFolder(this);
        }
        throw new MessagingException("mbox: only one root simulated folder, no " + url.getFile() + " folder");
    }

    @Override
    public void setObjectContent(Object objectContent) {
        if (objectContent instanceof byte[]) {
            this.objectContent = (byte[])objectContent;
        }
    }

    @Override
    public Object getObjectContent() {
        return this.objectContent;
    }
}

