/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.store.javamail.mbox;

import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractProgressLogger;
import jakarta.mail.internet.SharedInputStream;
import jakarta.mail.util.SharedByteArrayInputStream;
import jakarta.mail.util.SharedFileInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class MboxReader {
    private MailExtractProgressLogger logger;
    private String filePath;
    private RandomAccessFile raf;
    private SharedInputStream sifs;
    private static int BUFFER_SIZE = 4096;
    private byte[] buffer = new byte[BUFFER_SIZE];
    private int len = 0;
    private long bufferPos = 0L;
    private int curPos = 0;
    private int lineNum = 0;
    private long fromLineEnd = 0L;

    public MboxReader(MailExtractProgressLogger logger, File file) throws IOException {
        this.logger = logger;
        this.filePath = file.getPath();
        this.sifs = new SharedFileInputStream(file);
        this.raf = new RandomAccessFile(file, "r");
    }

    public MboxReader(MailExtractProgressLogger logger, byte[] source) {
        this.logger = logger;
        this.sifs = new SharedByteArrayInputStream(source);
    }

    public MailExtractProgressLogger getProgressLogger() {
        return this.logger;
    }

    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
        if (this.sifs instanceof InputStream) {
            ((InputStream)((Object)this.sifs)).close();
        }
    }

    public InputStream newStream(long start, long end) {
        return this.sifs.newStream(start, end);
    }

    private final int read() throws IOException {
        if (this.raf != null) {
            if (this.curPos >= this.len) {
                this.bufferPos = this.raf.getFilePointer();
                this.len = this.raf.read(this.buffer);
                if (this.len == -1) {
                    return -1;
                }
                this.curPos = 0;
            }
        } else if (this.curPos >= this.len) {
            this.bufferPos = this.sifs.getPosition();
            this.len = ((ByteArrayInputStream)((Object)this.sifs)).read(this.buffer);
            if (this.len == -1) {
                return -1;
            }
            this.curPos = 0;
        }
        return this.buffer[this.curPos++];
    }

    private final long getPointer() {
        return this.bufferPos + (long)this.curPos;
    }

    private final int readFirstBytesLine(byte[] buffer) throws IOException {
        int i = 0;
        ++this.lineNum;
        int b;
        while ((b = this.read()) != -1) {
            if (b == 10) {
                return i;
            }
            if (i >= 64) continue;
            buffer[i++] = (byte)b;
        }
        return -1;
    }

    private String constructLine(byte[] buffer, int len) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            char c = (char)buffer[i];
            if (c < ' ') continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private boolean isCompliantMBoxDelimiterLine(byte[] buffer, int len) {
        return buffer[0] == 70 && buffer[1] == 114 && buffer[2] == 111 && buffer[3] == 109 && buffer[4] == 32;
    }

    public long getNextFromLineBeg() throws IOException {
        long beg;
        int len;
        byte[] buffer = new byte[64];
        do {
            beg = this.getPointer();
            len = this.readFirstBytesLine(buffer);
            if (len != -1) continue;
            this.fromLineEnd = -1L;
            return -1L;
        } while (!this.isCompliantMBoxDelimiterLine(buffer, len));
        this.fromLineEnd = this.getPointer();
        return beg;
    }

    public long getLastFromLineEnd() throws IOException {
        return this.fromLineEnd;
    }
}

