/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.store.javamail.mbox;

import fr.gouv.vitam.tools.mailextractlib.store.javamail.JMMimeMessage;
import fr.gouv.vitam.tools.mailextractlib.store.javamail.mbox.MboxReader;
import fr.gouv.vitam.tools.mailextractlib.store.javamail.mbox.MboxStore;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractProgressLogger;
import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.MethodNotSupportedException;
import jakarta.mail.URLName;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MboxFolder
extends Folder {
    private volatile boolean opened = false;
    private MboxStore mboxstore;
    private MboxReader mboxfilereader;
    private MailExtractProgressLogger logger;
    private List<MessageFork> messages;
    private int total;

    public void setLogger(MailExtractProgressLogger logger) {
        this.logger = logger;
    }

    public MboxFolder(MboxStore store) throws MessagingException {
        super(store);
        this.mboxstore = store;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public String getFullName() {
        return "";
    }

    @Override
    public char getSeparator() {
        return File.separatorChar;
    }

    @Override
    public Folder[] list(String pattern) throws MessagingException {
        throw new MethodNotSupportedException("mbox: list with pattern not supported");
    }

    @Override
    public Folder[] list() throws MessagingException {
        Folder[] result = new MboxFolder[]{};
        return result;
    }

    @Override
    public Folder getParent() throws MessagingException {
        return this;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public Flags getPermanentFlags() {
        return null;
    }

    @Override
    public boolean hasNewMessages() {
        return false;
    }

    @Override
    public Folder getFolder(String name) throws MessagingException {
        if (name == null || name.isEmpty()) {
            return new MboxFolder(this.mboxstore);
        }
        throw new MethodNotSupportedException("mbox: no folder supported");
    }

    @Override
    public boolean create(int type) throws MessagingException {
        throw new MethodNotSupportedException("mbox: no writing supported");
    }

    @Override
    public boolean delete(boolean recurse) throws MessagingException {
        throw new MethodNotSupportedException("mbox: no writing supported");
    }

    @Override
    public boolean renameTo(Folder f) throws MessagingException {
        throw new MethodNotSupportedException("mbox: no writing supported");
    }

    @Override
    public boolean isOpen() {
        return this.opened;
    }

    @Override
    public void open(int mode) throws MessagingException {
        if (this.opened) {
            throw new IllegalStateException("mbox: file " + this.mboxstore.getContainer() + " is already open");
        }
        this.mode = mode;
        switch (mode) {
            case 2: {
                throw new MethodNotSupportedException("mbox: no writing supported");
            }
        }
        this.messages = new ArrayList<MessageFork>();
        try {
            this.mboxfilereader = this.mboxstore.getObjectContent() != null ? new MboxReader(this.logger, (byte[])this.mboxstore.getObjectContent()) : new MboxReader(this.logger, new File(this.mboxstore.getContainer()));
            this.opened = true;
            this.mboxfilereader.getNextFromLineBeg();
            long beg = this.mboxfilereader.getLastFromLineEnd();
            while (beg != -1L) {
                long end = this.mboxfilereader.getNextFromLineBeg();
                MessageFork mf = new MessageFork(beg, end);
                this.messages.add(mf);
                beg = this.mboxfilereader.getLastFromLineEnd();
            }
        }
        catch (IOException e) {
            throw new MessagingException("mbox: open failure, can't read: " + this.mboxstore.getContainer() + " file");
        }
        this.total = this.messages.size();
    }

    @Override
    public void close(boolean expunge) throws MessagingException {
        if (!this.opened) {
            throw new IllegalStateException("mbox: file " + this.mboxstore.getContainer() + " is not open");
        }
        this.messages = null;
        this.opened = false;
        try {
            this.mboxfilereader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int getMessageCount() throws MessagingException {
        if (!this.opened) {
            return -1;
        }
        return this.total;
    }

    @Override
    public Message getMessage(int msgno) throws MessagingException {
        if (msgno < 1) {
            throw new IndexOutOfBoundsException("message number " + msgno + " < 1");
        }
        if (msgno > this.total) {
            throw new IndexOutOfBoundsException("message number " + msgno + " > " + this.total);
        }
        JMMimeMessage m = new JMMimeMessage(this, this.mboxfilereader.newStream(this.messages.get((int)(msgno - 1)).beg, this.messages.get((int)(msgno - 1)).end), msgno);
        return m;
    }

    @Override
    public void appendMessages(Message[] msgs) throws MessagingException {
        throw new MethodNotSupportedException("mbox: no writing supported");
    }

    @Override
    public Message[] expunge() throws MessagingException {
        throw new MethodNotSupportedException("mbox: no writing supported");
    }

    @Override
    public URLName getURLName() {
        URLName storeURL = this.getStore().getURLName();
        return new URLName(storeURL.getProtocol(), storeURL.getHost(), storeURL.getPort(), this.mboxstore.getContainer(), storeURL.getUsername(), null);
    }

    private class MessageFork {
        long beg;
        long end;

        MessageFork(long beg, long end) {
            this.beg = beg;
            this.end = end;
        }
    }
}

