/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.store.javamail.eml;

import fr.gouv.vitam.tools.mailextractlib.store.javamail.JMMimeMessage;
import fr.gouv.vitam.tools.mailextractlib.store.javamail.eml.EmlStore;
import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.MethodNotSupportedException;
import jakarta.mail.URLName;
import jakarta.mail.util.SharedByteArrayInputStream;
import jakarta.mail.util.SharedFileInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class EmlFolder
extends Folder {
    private volatile boolean opened = false;
    private EmlStore emlstore;
    private InputStream emlInputStream;

    public EmlFolder(EmlStore store) throws MessagingException {
        super(store);
        this.emlstore = store;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public String getFullName() {
        return "";
    }

    @Override
    public char getSeparator() {
        return File.separatorChar;
    }

    @Override
    public Folder[] list(String pattern) throws MessagingException {
        throw new MethodNotSupportedException("eml: list with pattern not supported");
    }

    @Override
    public Folder[] list() throws MessagingException {
        Folder[] result = new EmlFolder[]{};
        return result;
    }

    @Override
    public Folder getParent() throws MessagingException {
        return this;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public Flags getPermanentFlags() {
        return null;
    }

    @Override
    public boolean hasNewMessages() {
        return false;
    }

    @Override
    public Folder getFolder(String name) throws MessagingException {
        if (name == null || name.isEmpty()) {
            return new EmlFolder(this.emlstore);
        }
        throw new MethodNotSupportedException("eml: no folder supported");
    }

    @Override
    public boolean create(int type) throws MessagingException {
        throw new MethodNotSupportedException("eml: no writing supported");
    }

    @Override
    public boolean delete(boolean recurse) throws MessagingException {
        throw new MethodNotSupportedException("eml: no writing supported");
    }

    @Override
    public boolean renameTo(Folder f) throws MessagingException {
        throw new MethodNotSupportedException("eml: no writing supported");
    }

    @Override
    public boolean isOpen() {
        return this.opened;
    }

    @Override
    public void open(int mode) throws MessagingException {
        if (this.opened) {
            throw new IllegalStateException("eml: simulated folder is already open");
        }
        this.mode = mode;
        switch (mode) {
            case 2: {
                throw new MethodNotSupportedException("eml: no writing supported");
            }
        }
        if (this.emlstore.getObjectContent() != null) {
            this.emlInputStream = new SharedByteArrayInputStream((byte[])this.emlstore.getObjectContent());
        } else {
            try {
                this.emlInputStream = new SharedFileInputStream(new File(this.emlstore.getContainer()));
            }
            catch (IOException e) {
                throw new MessagingException("eml: open failure, can't read: " + this.emlstore.getContainer());
            }
        }
        this.opened = true;
    }

    @Override
    public void close(boolean expunge) throws MessagingException {
        if (!this.opened) {
            throw new IllegalStateException("eml: simulated folder is not open");
        }
        this.opened = false;
        try {
            this.emlInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int getMessageCount() throws MessagingException {
        return 1;
    }

    @Override
    public Message getMessage(int msgno) throws MessagingException {
        if (msgno != 1) {
            throw new IndexOutOfBoundsException("Eml: only message 1, no message number " + msgno);
        }
        JMMimeMessage m = new JMMimeMessage(this, this.emlInputStream, msgno);
        return m;
    }

    @Override
    public void appendMessages(Message[] msgs) throws MessagingException {
        throw new MethodNotSupportedException("Eml: no writing supported");
    }

    @Override
    public Message[] expunge() throws MessagingException {
        throw new MethodNotSupportedException("Eml: no writing supported");
    }

    @Override
    public URLName getURLName() {
        URLName storeURL = this.getStore().getURLName();
        return new URLName(storeURL.getProtocol(), storeURL.getHost(), storeURL.getPort(), this.emlstore.getContainer(), storeURL.getUsername(), null);
    }
}

