/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.store.javamail.charsets.jutf7;

import fr.gouv.vitam.tools.mailextractlib.store.javamail.charsets.jutf7.Base64Util;
import fr.gouv.vitam.tools.mailextractlib.store.javamail.charsets.jutf7.UTF7StyleCharset;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

class UTF7StyleCharsetDecoder
extends CharsetDecoder {
    private final Base64Util base64;
    private final byte shift;
    private final byte unshift;
    private final boolean strict;
    private boolean base64mode;
    private int bitsRead;
    private int tempChar;
    private boolean justShifted;
    private boolean justUnshifted;

    UTF7StyleCharsetDecoder(UTF7StyleCharset cs, Base64Util base64, boolean strict) {
        super(cs, 0.6f, 1.0f);
        this.base64 = base64;
        this.strict = strict;
        this.shift = cs.shift();
        this.unshift = cs.unshift();
    }

    @Override
    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
        while (in.hasRemaining()) {
            byte b = in.get();
            if (this.base64mode) {
                if (b == this.unshift) {
                    if (this.base64bitsWaiting()) {
                        return this.malformed(in);
                    }
                    if (this.justShifted) {
                        if (!out.hasRemaining()) {
                            return this.overflow(in);
                        }
                        out.put((char)this.shift);
                    } else {
                        this.justUnshifted = true;
                    }
                    this.setUnshifted();
                } else {
                    if (!out.hasRemaining()) {
                        return this.overflow(in);
                    }
                    CoderResult result = this.handleBase64(in, out, b);
                    if (result != null) {
                        return result;
                    }
                }
                this.justShifted = false;
                continue;
            }
            if (b == this.shift) {
                this.base64mode = true;
                if (this.justUnshifted && this.strict) {
                    return this.malformed(in);
                }
                this.justShifted = true;
                continue;
            }
            if (!out.hasRemaining()) {
                return this.overflow(in);
            }
            out.put((char)b);
            this.justUnshifted = false;
        }
        return CoderResult.UNDERFLOW;
    }

    private CoderResult overflow(ByteBuffer in) {
        in.position(in.position() - 1);
        return CoderResult.OVERFLOW;
    }

    private CoderResult handleBase64(ByteBuffer in, CharBuffer out, byte lastRead) {
        CoderResult result = null;
        int sextet = this.base64.getSextet(lastRead);
        if (sextet >= 0) {
            this.bitsRead += 6;
            if (this.bitsRead < 16) {
                this.tempChar += sextet << 16 - this.bitsRead;
            } else {
                this.bitsRead -= 16;
                this.tempChar += sextet >> this.bitsRead;
                out.put((char)this.tempChar);
                this.tempChar = sextet << 16 - this.bitsRead & 0xFFFF;
            }
        } else {
            if (this.strict) {
                return this.malformed(in);
            }
            out.put((char)lastRead);
            if (this.base64bitsWaiting()) {
                result = this.malformed(in);
            }
            this.setUnshifted();
        }
        return result;
    }

    @Override
    protected CoderResult implFlush(CharBuffer out) {
        if (this.base64mode && this.strict || this.base64bitsWaiting()) {
            return CoderResult.malformedForLength(1);
        }
        return CoderResult.UNDERFLOW;
    }

    @Override
    protected void implReset() {
        this.setUnshifted();
        this.justUnshifted = false;
    }

    private CoderResult malformed(ByteBuffer in) {
        in.position(in.position() - 1);
        return CoderResult.malformedForLength(1);
    }

    private boolean base64bitsWaiting() {
        return this.tempChar != 0 || this.bitsRead >= 6;
    }

    private void setUnshifted() {
        this.base64mode = false;
        this.bitsRead = 0;
        this.tempChar = 0;
    }
}

