/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.store.javamail.charsets;

import fr.gouv.vitam.tools.mailextractlib.store.javamail.charsets.RedirectCharset;
import fr.gouv.vitam.tools.mailextractlib.store.javamail.charsets.jutf7.ModifiedUTF7Charset;
import fr.gouv.vitam.tools.mailextractlib.store.javamail.charsets.jutf7.UTF7Charset;
import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class OtherMimeCharsetProvider
extends CharsetProvider {
    private static final List<Charset> charsets = Arrays.asList(new RedirectCharset("MACINTOSH", new String[0], "x-MacRoman"), new RedirectCharset("UNKNOWN", new String[]{"DEFAULT", "iso-8859-iso-8859-1"}, "ISO-8859-1"), new UTF7Charset("UTF-7", new String[]{"UNICODE-1-1-UTF-7", "CSUNICODE11UTF7", "X-RFC2152", "X-RFC-2152"}, false), new UTF7Charset("X-UTF-7-OPTIONAL", new String[]{"X-RFC2152-OPTIONAL", "X-RFC-2152-OPTIONAL"}, true), new ModifiedUTF7Charset("X-MODIFIED-UTF-7", new String[]{"X-IMAP-MODIFIED-UTF-7", "X-IMAP4-MODIFIED-UTF7", "X-IMAP4-MODIFIED-UTF-7", "X-RFC3501", "X-RFC-3501"}));

    @Override
    public Iterator<Charset> charsets() {
        return charsets.iterator();
    }

    @Override
    public Charset charsetForName(String charsetName) {
        for (Charset cs : charsets) {
            if (cs.name().equalsIgnoreCase(charsetName)) {
                return cs;
            }
            for (String alias : cs.aliases()) {
                if (!alias.equalsIgnoreCase(charsetName)) continue;
                return cs;
            }
        }
        String filteredCharsetName = charsetName.replaceAll("[=_]", "-").replaceAll("[^a-zA-Z0-9_-]", "");
        if (!filteredCharsetName.equals(charsetName)) {
            try {
                return Charset.forName(filteredCharsetName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

