/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.store.javamail;

import fr.gouv.vitam.tools.mailextractlib.core.StoreAttachment;
import fr.gouv.vitam.tools.mailextractlib.core.StoreFolder;
import fr.gouv.vitam.tools.mailextractlib.core.StoreMessage;
import fr.gouv.vitam.tools.mailextractlib.store.javamail.LFFixingQPDecoderStream;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractLibException;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractProgressLogger;
import fr.gouv.vitam.tools.mailextractlib.utils.RFC822Headers;
import jakarta.activation.CommandMap;
import jakarta.activation.DataHandler;
import jakarta.activation.MailcapCommandMap;
import jakarta.mail.BodyPart;
import jakarta.mail.Header;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.ContentDisposition;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MailDateFormat;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeUtility;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.CallSite;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.angus.mail.util.QPDecoderStream;

public class JMStoreMessage
extends StoreMessage {
    protected MimeMessage message;
    private static MailDateFormat mailDateFormat;

    public JMStoreMessage(StoreFolder mBFolder, MimeMessage message) throws MailExtractLibException {
        super(mBFolder);
        this.message = message;
    }

    @Override
    public long getMessageSize() throws InterruptedException {
        long result;
        if (this.mimeContent != null) {
            result = this.mimeContent.length;
        } else {
            this.mimeContent = this.getNativeMimeContent();
            result = this.mimeContent.length;
        }
        return result;
    }

    private static String getElementalStringAddress(InternetAddress address) {
        Object result = "";
        if (address != null) {
            String s = address.getPersonal();
            if (s != null) {
                result = s + " ";
            }
            if ((s = address.getAddress()) != null) {
                result = (String)result + "<" + s + ">";
            }
        }
        return result;
    }

    private static String getStringAddress(InternetAddress address) {
        Object result = "";
        if (address != null) {
            result = JMStoreMessage.getElementalStringAddress(address);
            if (address.isGroup()) {
                try {
                    InternetAddress[] group = address.getGroup(false);
                    result = (String)result + ":";
                    for (int k = 0; k < group.length; ++k) {
                        if (k > 0) {
                            result = (String)result + ",";
                        }
                        result = (String)result + JMStoreMessage.getElementalStringAddress(group[k]);
                    }
                }
                catch (AddressException addressException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    @Override
    protected void prepareAnalyze() throws InterruptedException {
        ArrayList<CallSite> result;
        block5: {
            result = null;
            try {
                Enumeration<Header> headers = this.message.getAllHeaders();
                if (headers == null || !headers.hasMoreElements()) break block5;
                result = new ArrayList<CallSite>();
                while (headers.hasMoreElements()) {
                    String value;
                    Header header = headers.nextElement();
                    String line = header.getName() + ": ";
                    try {
                        value = MimeUtility.decodeText(header.getValue());
                    }
                    catch (UnsupportedEncodingException e) {
                        value = header.getValue();
                    }
                    line = line + value;
                    result.add((CallSite)((Object)line));
                }
            }
            catch (MessagingException e) {
                this.logMessageWarning("mailextractlib.javamail: can't extract complete mail header", e);
            }
        }
        this.mailHeader = result;
    }

    @Override
    protected void analyzeSubject() throws InterruptedException {
        String result = null;
        try {
            result = this.message.getSubject();
            if (result != null && result.contains("=?")) {
                result = RFC822Headers.decodeRfc2047Flexible(this.message.getHeader("Subject", null));
            }
        }
        catch (MessagingException e) {
            MailExtractProgressLogger.doProgressLog(this.getProgressLogger(), 60, "mailextractlib.javamail: can't get message subject", e);
        }
        this.subject = result;
    }

    @Override
    protected void analyzeMessageID() throws InterruptedException {
        String result = null;
        try {
            result = this.message.getMessageID();
        }
        catch (MessagingException e) {
            this.logMessageWarning("mailextractlib.javamail: can't extract message ID", e);
        }
        this.messageID = result;
    }

    @Override
    protected void analyzeFrom() throws InterruptedException {
        String result = null;
        List<String> aList = this.getAddressHeader("From");
        if (aList == null || aList.size() == 0) {
            this.logMessageWarning("mailextractlib.javamail: no From address in header", null);
        } else {
            if ((aList = RFC822Headers.removeInvalidAndDuplicatesFromAddressesList(aList)).size() > 1) {
                result = String.join((CharSequence)", ", aList);
                this.logMessageWarning("mailextractlib.javamail: multiple From addresses [" + result + "]", null);
            } else {
                result = aList.get(0);
            }
            if (result != null && result.contains("=?")) {
                result = RFC822Headers.decodeRfc2047Flexible(result);
            }
        }
        this.from = result;
    }

    private List<String> getAddressHeader(String name) throws InterruptedException {
        String addressHeaderString = null;
        try {
            addressHeaderString = this.message.getHeader(name, ", ");
        }
        catch (MessagingException me) {
            this.logMessageWarning("mailextractlib.javamail: can't access to [" + name + "] address header", me);
        }
        return RFC822Headers.treatAddressHeaderString(name, this, addressHeaderString);
    }

    @Override
    protected void analyzeRecipients() throws InterruptedException {
        this.recipientTo = this.getAddressHeader("To");
        this.recipientCc = this.getAddressHeader("Cc");
        this.recipientBcc = this.getAddressHeader("Bcc");
    }

    @Override
    protected void analyzeReplyTo() throws InterruptedException {
        this.replyTo = this.getAddressHeader("Reply-To");
    }

    @Override
    protected void analyzeReturnPath() throws InterruptedException {
        String result = null;
        List<String> aList = this.getAddressHeader("Return-Path");
        if (aList != null && aList.size() != 0) {
            if ((aList = RFC822Headers.removeInvalidAndDuplicatesFromAddressesList(aList)).size() > 1) {
                result = String.join((CharSequence)", ", aList);
                this.logMessageWarning("mailextractlib.javamail: multiple Return-Path addresses [" + result + "]", null);
            } else {
                result = aList.get(0);
            }
            if (result != null && result.contains("=?")) {
                result = RFC822Headers.decodeRfc2047Flexible(result);
            }
        }
        this.returnPath = result;
    }

    private Date getReceivedDate() throws MessagingException {
        int i;
        String receivedHeader;
        Date result = this.message.getReceivedDate();
        if (result == null && (receivedHeader = this.message.getHeader("Received", ",")) != null && (i = receivedHeader.indexOf(59)) != -1) {
            receivedHeader = receivedHeader.substring(i + 1);
            try {
                result = mailDateFormat.parse(receivedHeader);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    protected void analyzeDates() throws InterruptedException {
        try {
            this.sentDate = this.message.getSentDate();
            this.receivedDate = this.getReceivedDate();
        }
        catch (MessagingException e) {
            this.logMessageWarning("mailextractlib.javamail: can't extract dates", e);
        }
    }

    @Override
    protected void analyzeInReplyToId() throws InterruptedException {
        String result = null;
        try {
            CharSequence[] irtList = this.message.getHeader("In-Reply-To");
            if (irtList != null) {
                if (irtList.length > 1) {
                    this.logMessageWarning("mailextractlib.javamail: multiple In-Reply-To identifiers [" + String.join((CharSequence)", ", irtList) + "] keep the first one in header", null);
                }
                result = RFC822Headers.getHeaderValue(irtList[0]);
            }
        }
        catch (MessagingException me) {
            this.logMessageWarning("mailextractlib.javamail: can't access to In-Reply-To header", null);
        }
        this.inReplyToUID = result;
    }

    private static String getHeaderValue(String line) {
        char c;
        int j;
        int i = line.indexOf(58);
        if (i < 0) {
            return line;
        }
        for (j = i + 1; j < line.length() && ((c = line.charAt(j)) == ' ' || c == '\t' || c == '\r' || c == '\n'); ++j) {
        }
        return line.substring(j);
    }

    @Override
    protected void analyzeReferences() throws InterruptedException {
        ArrayList<String> result = null;
        try {
            String refHeader = this.message.getHeader("References", " ");
            if (refHeader != null) {
                String[] refList;
                result = new ArrayList<String>();
                for (String tmp : refList = JMStoreMessage.getHeaderValue(refHeader).split(" ")) {
                    try {
                        result.add(MimeUtility.decodeText(tmp));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (MessagingException me) {
            this.logMessageWarning("mailextractlib.javamail: can't access to In-Reply-To header", me);
        }
        this.references = result;
    }

    private void appendBodyContent(int type, String s) {
        if (s != null) {
            if (this.bodyContent[type] == null) {
                this.bodyContent[type] = s;
            } else {
                int n = type;
                this.bodyContent[n] = this.bodyContent[n] + "/n" + s;
            }
        }
    }

    private static String getInputStreamContent(InputStream is) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int length;
            while ((length = is.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            return result.toString("UTF-8");
        }
        catch (IOException e) {
            return null;
        }
    }

    private void getPartBodyContents(Part p) throws MessagingException, IOException {
        block5: {
            block2: {
                block8: {
                    block6: {
                        block7: {
                            block3: {
                                block4: {
                                    if (!p.isMimeType("text/*")) break block2;
                                    if (!p.isMimeType("text/plain") || p.getDisposition() != null && !"inline".equalsIgnoreCase(p.getDisposition())) break block3;
                                    if (!(p.getContent() instanceof InputStream)) break block4;
                                    this.appendBodyContent(0, JMStoreMessage.getInputStreamContent((InputStream)p.getContent()));
                                    break block5;
                                }
                                if (!(p.getContent() instanceof String)) break block5;
                                this.appendBodyContent(0, (String)p.getContent());
                                break block5;
                            }
                            if (!p.isMimeType("text/html") || p.getDisposition() != null && !"inline".equalsIgnoreCase(p.getDisposition())) break block6;
                            if (!(p.getContent() instanceof InputStream)) break block7;
                            this.appendBodyContent(1, JMStoreMessage.getInputStreamContent((InputStream)p.getContent()));
                            break block5;
                        }
                        if (!(p.getContent() instanceof String)) break block5;
                        this.appendBodyContent(1, (String)p.getContent());
                        break block5;
                    }
                    if (!p.isMimeType("text/rtf") || p.getDisposition() != null && !"inline".equalsIgnoreCase(p.getDisposition())) break block5;
                    if (!(p.getContent() instanceof InputStream)) break block8;
                    this.appendBodyContent(2, JMStoreMessage.getInputStreamContent((InputStream)p.getContent()));
                    break block5;
                }
                if (!(p.getContent() instanceof String)) break block5;
                this.appendBodyContent(2, (String)p.getContent());
                break block5;
            }
            if (p.isMimeType("multipart/*")) {
                Multipart mp = (Multipart)p.getContent();
                for (int i = 0; i < mp.getCount(); ++i) {
                    this.getPartBodyContents(mp.getBodyPart(i));
                }
            }
        }
    }

    @Override
    protected void analyzeBodies() throws InterruptedException {
        try {
            this.getPartBodyContents(this.message);
        }
        catch (Exception | NoClassDefFoundError e) {
            this.logMessageWarning("mailextractlib.javamail: badly formatted mime message, may not extract all body contents", e);
        }
    }

    private void getAttachments(List<StoreAttachment> lStoreMessageAttachment, BodyPart p) throws MessagingException, IOException, InterruptedException {
        if (!p.isMimeType("text/plain") && !p.isMimeType("text/html") && !p.isMimeType("text/rtf") || p.getDisposition() != null && !"inline".equalsIgnoreCase(p.getDisposition())) {
            if (!p.isMimeType("multipart/*")) {
                try {
                    this.addAttachment(lStoreMessageAttachment, p);
                }
                catch (MessagingException | IOException | ParseException e) {
                    this.logMessageWarning("mailextractlib.javamail: can't extract a badly formatted attachement", e);
                }
            } else if (p.isMimeType("multipart/*")) {
                Multipart mp = (Multipart)p.getContent();
                for (int i = 0; i < mp.getCount(); ++i) {
                    this.getAttachments(lStoreMessageAttachment, mp.getBodyPart(i));
                }
            }
        }
    }

    private byte[] getPartRawContent(BodyPart bp) throws IOException, MessagingException {
        int bytesRead;
        InputStream is = bp.getInputStream();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((bytesRead = is.read(buf)) != -1) {
            baos.write(buf, 0, bytesRead);
        }
        return baos.toByteArray();
    }

    private byte[] getPartLFFixedRawContent(BodyPart bp) throws IOException, MessagingException, InterruptedException {
        int bytesRead;
        InputStream is = bp.getInputStream();
        if (is instanceof QPDecoderStream) {
            DataHandler dh = bp.getDataHandler();
            bp.setDataHandler(null);
            is = new LFFixingQPDecoderStream(bp.getInputStream());
            bp.setDataHandler(dh);
            this.logMessageWarning("mailextractlib.javamail: using LFFixing quoted-printable decoding", null);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buf = new byte[4096];
        while ((bytesRead = is.read(buf)) != -1) {
            baos.write(buf, 0, bytesRead);
        }
        return baos.toByteArray();
    }

    private static String sanitizeFilename(String name) {
        return name.replaceAll("[:\\\\/*?|<>]", "_");
    }

    private void addAttachment(List<StoreAttachment> lStoreMessageAttachment, BodyPart bodyPart) throws IOException, MessagingException, ParseException, InterruptedException {
        Object aMimeType;
        String[] headers;
        int aType;
        String aContentID;
        Date aModificationDate;
        Date aCreationDate;
        String aName;
        block21: {
            aName = null;
            aCreationDate = null;
            aModificationDate = null;
            aContentID = null;
            aType = 0;
            headers = bodyPart.getHeader("Content-Disposition");
            if (headers != null && headers.length > 0) {
                String date;
                ContentDisposition disposition = new ContentDisposition(headers[0]);
                if ("inline".equalsIgnoreCase(disposition.getDisposition())) {
                    aType = 1;
                }
                if ((date = disposition.getParameter("creation-date")) != null && !date.isEmpty()) {
                    aCreationDate = mailDateFormat.parse(date);
                }
                if ((date = disposition.getParameter("modification-date")) != null && !date.isEmpty()) {
                    aModificationDate = mailDateFormat.parse(date);
                }
                aName = disposition.getParameter("filename");
            }
            if ((headers = bodyPart.getHeader("Content-Type")) != null && headers.length > 0) {
                try {
                    ContentType contenttype = new ContentType(headers[0]);
                    if (contenttype.getSubType().equalsIgnoreCase("RFC822")) {
                        aType = 2;
                    }
                    aMimeType = contenttype.getBaseType();
                    if (aName == null) {
                        aName = contenttype.getParameter("name");
                    }
                }
                catch (Exception e) {
                    int j;
                    aMimeType = headers[0];
                    if (((String)aMimeType).indexOf(59) != -1) {
                        aMimeType = ((String)aMimeType).substring(0, ((String)aMimeType).indexOf(59));
                    }
                    if ((j = ((String)aMimeType).lastIndexOf(47)) != -1 && j < ((String)aMimeType).length()) {
                        aMimeType = "application/" + ((String)aMimeType).substring(j + 1);
                        break block21;
                    }
                    aMimeType = "application/octet-stream";
                }
            } else {
                aMimeType = "application/octet-stream";
            }
        }
        if ((headers = bodyPart.getHeader("Content-ID")) != null && headers.length != 0) {
            aContentID = headers[0];
        }
        if (aName == null) {
            aName = "noname";
        } else {
            try {
                aName = MimeUtility.decodeText(aName);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        aName = JMStoreMessage.sanitizeFilename(aName);
        if (aType == 2) {
            lStoreMessageAttachment.add(new StoreAttachment(this, this.getPartRawContent(bodyPart), "eml", MimeUtility.decodeText(aName), aCreationDate, aModificationDate, (String)aMimeType, aContentID, aType));
        } else if (((String)aMimeType).toLowerCase().equals("application/ms-tnef") || ((String)aMimeType).toLowerCase().equals("application/vnd.ms-tnef")) {
            lStoreMessageAttachment.add(new StoreAttachment(this, this.getPartLFFixedRawContent(bodyPart), "file", MimeUtility.decodeText(aName), aCreationDate, aModificationDate, (String)aMimeType, aContentID, aType));
        } else {
            lStoreMessageAttachment.add(new StoreAttachment(this, this.getPartRawContent(bodyPart), "file", MimeUtility.decodeText(aName), aCreationDate, aModificationDate, (String)aMimeType, aContentID, aType));
        }
    }

    @Override
    protected void analyzeAttachments() throws InterruptedException {
        ArrayList<StoreAttachment> result = new ArrayList<StoreAttachment>();
        try {
            Object contentObject = this.message.getContent();
            if (contentObject instanceof Multipart) {
                Multipart multipart = (Multipart)contentObject;
                for (int i = 0; i < multipart.getCount(); ++i) {
                    BodyPart bodyPart = multipart.getBodyPart(i);
                    this.getAttachments(result, bodyPart);
                }
            }
        }
        catch (Exception e) {
            this.logMessageWarning("mailextractlib.javamail: badly formatted mime message, can't extract all attachments", e);
        }
        if (result.size() == 0) {
            result = null;
        }
        this.attachments = result;
    }

    @Override
    protected byte[] getNativeMimeContent() throws InterruptedException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.message.writeTo(baos);
        }
        catch (Exception e) {
            this.logMessageWarning("mailextractlib.javamail: can't extract raw mime content", e);
        }
        return baos.toByteArray();
    }

    static {
        final MailcapCommandMap mc = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mc.addMailcap("application/pgp-signature;; x-java-content-handler=fr.gouv.vitam.tools.mailextractlib.store.javamail.handlers.pgp");
        mc.addMailcap("application/pkcs7-signature;; x-java-content-handler=fr.gouv.vitam.tools.mailextractlib.store.javamail.handlers.pkcs7_signature");
        mc.addMailcap("application/pkcs7-mime;; x-java-content-handler=fr.gouv.vitam.tools.mailextractlib.store.javamail.handlers.pkcs7_mime");
        mc.addMailcap("application/x-pkcs7-signature;; x-java-content-handler=fr.gouv.vitam.tools.mailextractlib.store.javamail.handlers.x_pkcs7_signature");
        mc.addMailcap("application/x-pkcs7-mime;; x-java-content-handler=fr.gouv.vitam.tools.mailextractlib.store.javamail.handlers.x_pkcs7_mime");
        mc.addMailcap("multipart/signed;; x-java-content-handler=fr.gouv.vitam.tools.mailextractlib.store.javamail.handlers.multipart_signed");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                CommandMap.setDefaultCommandMap(mc);
                return null;
            }
        });
        mailDateFormat = new MailDateFormat();
    }
}

