/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.store.javamail;

import fr.gouv.vitam.tools.mailextractlib.core.StoreExtractor;
import fr.gouv.vitam.tools.mailextractlib.core.StoreFolder;
import fr.gouv.vitam.tools.mailextractlib.nodes.ArchiveUnit;
import fr.gouv.vitam.tools.mailextractlib.store.javamail.JMStoreMessage;
import fr.gouv.vitam.tools.mailextractlib.store.javamail.mbox.MboxFolder;
import fr.gouv.vitam.tools.mailextractlib.store.javamail.thunderbird.ThunderbirdFolder;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractLibException;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractProgressLogger;
import jakarta.mail.Flags;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class JMStoreFolder
extends StoreFolder {
    protected Folder folder;

    private JMStoreFolder(StoreExtractor storeExtractor, Folder folder) {
        this(storeExtractor, folder, null);
    }

    private JMStoreFolder(StoreExtractor storeExtractor, Folder folder, StoreFolder father) {
        super(storeExtractor);
        this.folder = folder;
        if (folder instanceof ThunderbirdFolder) {
            ((ThunderbirdFolder)folder).setLogger(storeExtractor.getProgressLogger());
        } else if (folder instanceof MboxFolder) {
            ((MboxFolder)folder).setLogger(storeExtractor.getProgressLogger());
        }
        if (father != null) {
            this.finalizeStoreFolder(father);
        }
    }

    public static JMStoreFolder createRootFolder(StoreExtractor storeExtractor, Folder folder, ArchiveUnit rootArchiveUnit) {
        JMStoreFolder result = new JMStoreFolder(storeExtractor, folder);
        result.folderArchiveUnit = rootArchiveUnit;
        return result;
    }

    @Override
    protected void doExtractFolderElements(boolean writeFlag) throws MailExtractLibException, InterruptedException {
        if (this.storeExtractor.isRoot()) {
            ExecutorService pool = Executors.newFixedThreadPool(this.storeExtractor.getMaxParallelThreads());
            ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(pool);
            int submittedTasks = 0;
            try {
                int i;
                this.folder.open(1);
                int msgTotal = this.folder.getMessageCount();
                for (i = 1; i <= msgTotal; ++i) {
                    Message message = this.folder.getMessage(i);
                    if (((MimeMessage)message).isSet(Flags.Flag.DELETED)) continue;
                    JMStoreMessage jmStoreMessage = new JMStoreMessage(this, (MimeMessage)message);
                    completionService.submit(() -> {
                        jmStoreMessage.processElement(writeFlag);
                        return null;
                    });
                    ++submittedTasks;
                }
                this.folder.close(false);
                for (i = 0; i < submittedTasks; ++i) {
                    Future future = completionService.poll(60L, TimeUnit.SECONDS);
                    if (future == null) {
                        throw new MailExtractLibException("mailextractlib.javamail: Timeout: no message extracted within 60 seconds, folder extraction aborted.", null);
                    }
                    try {
                        future.get();
                        continue;
                    }
                    catch (ExecutionException e) {
                        MailExtractProgressLogger.doProgressLogWithoutInterruption(this.getStoreExtractor().getProgressLogger(), 50, "mailextractlib.javamail: Error during a message processing, it's dropped.", e);
                    }
                }
            }
            catch (MessagingException e) {
                throw new MailExtractLibException("mailextractlib.javamail: cannot retrieve messages from folder " + this.getFullName() + ", folder extraction aborted", e);
            }
            finally {
                pool.shutdownNow();
            }
        }
        try {
            this.folder.open(1);
            int msgTotal = this.folder.getMessageCount();
            for (int i = 1; i <= msgTotal; ++i) {
                Message message = this.folder.getMessage(i);
                if (((MimeMessage)message).isSet(Flags.Flag.DELETED)) continue;
                JMStoreMessage jMStoreMessage = new JMStoreMessage(this, (MimeMessage)message);
                jMStoreMessage.processElement(writeFlag);
            }
            this.folder.close(false);
        }
        catch (MessagingException e) {
            throw new MailExtractLibException("mailextractlib.javamail: can't get messages from folder " + this.getFullName(), e);
        }
    }

    @Override
    protected void doExtractSubFolders(int level, boolean writeFlag) throws MailExtractLibException, InterruptedException {
        try {
            Folder[] subfolders;
            for (Folder subfolder : subfolders = this.folder.list()) {
                JMStoreFolder mBSubFolder = new JMStoreFolder(this.storeExtractor, subfolder, this);
                if (mBSubFolder.extractFolder(level + 1, writeFlag)) {
                    this.incFolderSubFoldersCount();
                }
                this.extendDateRange(mBSubFolder.getDateRange());
            }
        }
        catch (MessagingException e) {
            throw new MailExtractLibException("mailextractlib.javamail: can't get sub folders from folder " + this.getFullName(), e);
        }
    }

    @Override
    public String getFullName() {
        return this.folder.getFullName();
    }

    @Override
    public String getName() {
        return this.folder.getName();
    }

    @Override
    public boolean hasElements() throws MailExtractLibException {
        try {
            return (this.folder.getType() & 1) != 0;
        }
        catch (MessagingException e) {
            throw new MailExtractLibException("mailextractlib.javamail: can't determine if folder contains messages" + this.getFullName(), e);
        }
    }

    @Override
    public boolean hasSubfolders() throws MailExtractLibException {
        try {
            return (this.folder.getType() & 2) != 0;
        }
        catch (MessagingException e) {
            throw new MailExtractLibException("mailextractlib.javamail: can't determine if folder contains subfolders" + this.getFullName(), e);
        }
    }

    @Override
    protected void doListFolderElements(boolean stats) throws MailExtractLibException, InterruptedException {
        if (this.storeExtractor.isRoot()) {
            ExecutorService pool = Executors.newFixedThreadPool(this.storeExtractor.getMaxParallelThreads());
            ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(pool);
            int submittedTasks = 0;
            try {
                int i;
                this.folder.open(1);
                int msgTotal = this.folder.getMessageCount();
                for (i = 1; i <= msgTotal; ++i) {
                    Message message = this.folder.getMessage(i);
                    if (((MimeMessage)message).isSet(Flags.Flag.DELETED)) continue;
                    JMStoreMessage jmStoreMessage = new JMStoreMessage(this, (MimeMessage)message);
                    completionService.submit(() -> {
                        jmStoreMessage.listElement(stats);
                        return null;
                    });
                    ++submittedTasks;
                }
                this.folder.close(false);
                for (i = 0; i < submittedTasks; ++i) {
                    Future future = completionService.poll(60L, TimeUnit.SECONDS);
                    if (future == null) {
                        throw new MailExtractLibException("mailextractlib.javamail: Timeout: no message extracted within 60 seconds, folder extrcation aborted.", null);
                    }
                    try {
                        future.get();
                        continue;
                    }
                    catch (ExecutionException e) {
                        MailExtractProgressLogger.doProgressLogWithoutInterruption(this.getStoreExtractor().getProgressLogger(), 50, "mailextractlib.javamail: Error during a message processing, it's dropped.", e);
                    }
                }
            }
            catch (MessagingException e) {
                throw new MailExtractLibException("mailextractlib.javamail: cannot retrieve messages from folder " + this.getFullName() + ", folder listing aborted", e);
            }
            finally {
                pool.shutdownNow();
            }
        }
        try {
            this.folder.open(1);
            int msgTotal = this.folder.getMessageCount();
            for (int i = 1; i <= msgTotal; ++i) {
                Message message = this.folder.getMessage(i);
                if (((MimeMessage)message).isSet(Flags.Flag.DELETED)) continue;
                JMStoreMessage jMStoreMessage = new JMStoreMessage(this, (MimeMessage)message);
                jMStoreMessage.listElement(stats);
            }
            this.folder.close(false);
        }
        catch (MessagingException e) {
            throw new MailExtractLibException("mailextractlib.javamail: can't get messages from folder " + this.getFullName(), e);
        }
    }

    @Override
    protected void doListSubFolders(boolean stats) throws MailExtractLibException, InterruptedException {
        try {
            Folder[] subfolders;
            for (Folder subfolder : subfolders = this.folder.list()) {
                JMStoreFolder mBSubFolder = new JMStoreFolder(this.storeExtractor, subfolder, this);
                mBSubFolder.listFolder(stats);
                this.incFolderSubFoldersCount();
            }
        }
        catch (MessagingException e) {
            throw new MailExtractLibException("mailextractlib.javamail: can't get sub folders from folder " + this.getFullName(), e);
        }
    }
}

