/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.store.javamail;

import fr.gouv.vitam.tools.mailextractlib.core.StoreAttachment;
import fr.gouv.vitam.tools.mailextractlib.core.StoreElement;
import fr.gouv.vitam.tools.mailextractlib.core.StoreExtractor;
import fr.gouv.vitam.tools.mailextractlib.core.StoreExtractorOptions;
import fr.gouv.vitam.tools.mailextractlib.nodes.ArchiveUnit;
import fr.gouv.vitam.tools.mailextractlib.store.javamail.JMEmbeddedStore;
import fr.gouv.vitam.tools.mailextractlib.store.javamail.JMStoreFolder;
import fr.gouv.vitam.tools.mailextractlib.store.javamail.eml.EmlStore;
import fr.gouv.vitam.tools.mailextractlib.store.javamail.mbox.MboxStore;
import fr.gouv.vitam.tools.mailextractlib.store.javamail.thunderbird.ThunderbirdStore;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractLibException;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractProgressLogger;
import jakarta.mail.MessagingException;
import jakarta.mail.Provider;
import jakarta.mail.Session;
import jakarta.mail.Store;
import jakarta.mail.URLName;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Properties;

public class JMStoreExtractor
extends StoreExtractor {
    private Store store;
    private StoreAttachment attachment;

    public static void subscribeStoreExtractor() {
        JMStoreExtractor.addExtractionRelation("message/rfc822", "fmt/278", "eml", false, JMStoreExtractor.class);
        JMStoreExtractor.addExtractionRelation("message/rfc822", "fmt/950", "eml", false, JMStoreExtractor.class);
        JMStoreExtractor.addExtractionRelation("application/mbox", "fmt/720", "mbox", true, JMStoreExtractor.class);
        JMStoreExtractor.addExtractionRelation(null, null, "thunderbird", true, JMStoreExtractor.class);
        JMStoreExtractor.addExtractionRelation(null, null, "imap", true, JMStoreExtractor.class);
        JMStoreExtractor.addExtractionRelation(null, null, "imaps", true, JMStoreExtractor.class);
        JMStoreExtractor.addExtractionRelation(null, null, "gimap", true, JMStoreExtractor.class);
        JMStoreExtractor.addExtractionRelation(null, null, "pop3", true, JMStoreExtractor.class);
    }

    public JMStoreExtractor(String urlString, String folder, String destPathString, StoreExtractorOptions options, StoreExtractor rootStoreExtractor, MailExtractProgressLogger logger) throws MailExtractLibException {
        super(urlString, folder, destPathString, options, rootStoreExtractor, null, logger);
        Object url = urlString;
        if (folder != null && !folder.isEmpty()) {
            url = (String)url + "/" + folder;
        }
        try {
            Properties props = System.getProperties();
            props.setProperty("mail.imaps.ssl.trust", "*");
            props.setProperty("mail.imap.ssl.trust", "*");
            this.setSessionProperties(props);
            Session session = Session.getDefaultInstance(props, null);
            session.addProvider(new Provider(Provider.Type.STORE, "thunderbird", ThunderbirdStore.class.getName(), "fr.gouv.vitam", this.getClass().getPackage().getImplementationVersion()));
            session.addProvider(new Provider(Provider.Type.STORE, "eml", EmlStore.class.getName(), "fr.gouv.vitam", this.getClass().getPackage().getImplementationVersion()));
            session.addProvider(new Provider(Provider.Type.STORE, "mbox", MboxStore.class.getName(), "fr.gouv.vitam", this.getClass().getPackage().getImplementationVersion()));
            URLName urlName = new URLName((String)url);
            this.store = session.getStore(urlName);
            this.store.connect();
        }
        catch (MessagingException e) {
            throw new MailExtractLibException("mailextractlib.javamail: can't get store for " + JMStoreExtractor.getDecodedURL((String)url), e);
        }
        ArchiveUnit rootNode = new ArchiveUnit(this, this.destRootPath, this.destName);
        try {
            JMStoreFolder jMRootMailBoxFolder = folder == null || folder.isEmpty() ? JMStoreFolder.createRootFolder(this, this.store.getDefaultFolder(), rootNode) : JMStoreFolder.createRootFolder(this, this.store.getFolder(folder), rootNode);
            if (!jMRootMailBoxFolder.folder.exists()) {
                throw new MailExtractLibException("mailextractlib.javamail: can't find extraction root folder " + folder, null);
            }
            this.setRootFolder(jMRootMailBoxFolder);
        }
        catch (MessagingException e) {
            throw new MailExtractLibException("mailextractlib.javamail: can't find extraction root folder " + folder, e);
        }
    }

    public JMStoreExtractor(StoreAttachment attachment, ArchiveUnit rootNode, StoreExtractorOptions options, StoreExtractor rootStoreExtractor, StoreElement fatherElement, MailExtractProgressLogger logger) throws MailExtractLibException {
        super(attachment.getScheme() + "://localhost/", "", rootNode.getFullName(), options, rootStoreExtractor, fatherElement, logger);
        String url = attachment.getScheme() + ":";
        this.attachment = attachment;
        try {
            Properties props = System.getProperties();
            props.setProperty("mail.imaps.ssl.trust", "*");
            props.setProperty("mail.imap.ssl.trust", "*");
            this.setSessionProperties(props);
            Session session = Session.getDefaultInstance(props, null);
            session.addProvider(new Provider(Provider.Type.STORE, "eml", EmlStore.class.getName(), "fr.gouv.vitam", this.getClass().getPackage().getImplementationVersion()));
            session.addProvider(new Provider(Provider.Type.STORE, "mbox", MboxStore.class.getName(), "fr.gouv.vitam", this.getClass().getPackage().getImplementationVersion()));
            URLName urlName = new URLName(url);
            this.store = session.getStore(urlName);
            if (!(this.store instanceof JMEmbeddedStore)) {
                throw new MailExtractLibException("mailextractlib.javamail: can't extract embedded store for scheme [" + this.scheme + "]", null);
            }
            JMEmbeddedStore ejs = (JMEmbeddedStore)((Object)this.store);
            ejs.setObjectContent(attachment.getStoreContent());
            this.store.connect();
        }
        catch (MessagingException e) {
            throw new MailExtractLibException("mailextractlib.javamail: can't get store for " + url, e);
        }
        try {
            JMStoreFolder jMRootMailBoxFolder = JMStoreFolder.createRootFolder(this, this.store.getDefaultFolder(), rootNode);
            this.setRootFolder(jMRootMailBoxFolder);
        }
        catch (MessagingException e) {
            throw new MailExtractLibException("mailextractlib.javamail: can't find extraction root folder ", e);
        }
    }

    private static String getDecodedURL(String url) {
        String decodedUrl = "";
        try {
            decodedUrl = URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return decodedUrl;
    }

    private void setSessionProperties(Properties props) {
        props.setProperty("mail.mime.decodetext.strict", "false");
        props.setProperty("mail.mime.encodeeol.strict", "false");
        props.setProperty("mail.mime.decodefilename", "true");
        props.setProperty("mail.mime.decodeparameters", "true");
        props.setProperty("mail.mime.multipart.ignoremissingendboundary", "true");
        props.setProperty("mail.mime.multipart.ignoremissingboundaryparameter", "true");
        props.setProperty("mail.mime.parameters.strict", "false");
        props.setProperty("mail.mime.windowsfilenames", "true");
    }

    @Override
    public StoreAttachment getAttachment() {
        return this.attachment;
    }

    @Override
    public boolean canExtractObjectsLists() {
        return !this.scheme.equals("eml");
    }
}

