/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.nodes;

import fr.gouv.vitam.tools.mailextractlib.nodes.MetadataXML;
import fr.gouv.vitam.tools.mailextractlib.utils.HtmlAndXmlEscape;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MetadataXMLString
extends MetadataXML {
    String value;
    private static final String TAG_START = "\\<\\w+((\\s+\\w+(\\s*\\=\\s*(?:\".*?\"|'.*?'|[^'\"\\>\\s]+))?)+\\s*|\\s*)\\>";
    private static final String TAG_END = "\\</\\w+\\>";
    private static final String TAG_SELF_CLOSING = "\\<\\w+((\\s+\\w+(\\s*\\=\\s*(?:\".*?\"|'.*?'|[^'\"\\>\\s]+))?)+\\s*|\\s*)/\\>";
    private static final String HTML_ENTITY = "&[a-zA-Z][a-zA-Z0-9]+;";
    public static final Pattern HTML_PATTERN = Pattern.compile("(\\<\\w+((\\s+\\w+(\\s*\\=\\s*(?:\".*?\"|'.*?'|[^'\"\\>\\s]+))?)+\\s*|\\s*)\\>.*\\</\\w+\\>)|(\\<\\w+((\\s+\\w+(\\s*\\=\\s*(?:\".*?\"|'.*?'|[^'\"\\>\\s]+))?)+\\s*|\\s*)/\\>)|(&[a-zA-Z][a-zA-Z0-9]+;)", 32);
    private static final Pattern FORBIDDEN_PATTERN = Pattern.compile("[\\p{C}&&[^\\r\\n\\t]]");

    MetadataXMLString(String value) {
        this.value = value;
    }

    @Override
    public boolean isEmpty() {
        return this.value == null || this.value.isEmpty();
    }

    public static String normaliseXMLString(String value) {
        String normalized = FORBIDDEN_PATTERN.matcher(value).replaceAll("");
        Matcher m = HTML_PATTERN.matcher(normalized = HtmlAndXmlEscape.unescapeHtmlAndXMLEntities(normalized));
        if (m.find()) {
            StringBuffer sb = new StringBuffer();
            do {
                String match = m.group();
                String replacement = match.substring(0, 1) + " " + match.substring(1);
                m.appendReplacement(sb, Matcher.quoteReplacement(replacement));
            } while (m.find());
            m.appendTail(sb);
            normalized = sb.toString();
        }
        return HtmlAndXmlEscape.escapeXml(normalized);
    }

    @Override
    public String writeXML(int depth) {
        return MetadataXMLString.normaliseXMLString(this.value);
    }

    public String getValue() {
        return this.value;
    }
}

