/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.nodes;

import fr.gouv.vitam.tools.mailextractlib.nodes.MetadataXMLNode;
import fr.gouv.vitam.tools.mailextractlib.nodes.MetadataXMLString;
import fr.gouv.vitam.tools.mailextractlib.utils.HtmlAndXmlEscape;
import java.util.regex.Pattern;

public class MetadataXMLSplittedNode
extends MetadataXMLNode {
    public static final int MAX_TEXT_LENGTH = 32000;
    private static final Pattern FORBIDDEN_PATTERN = Pattern.compile("[\\p{C}&&[^\\r\\n\\t]]");
    private static final Pattern HTML_ENTITY_PATTERN = Pattern.compile("&([a-zA-Z][a-zA-Z0-9]+;)");

    @Override
    public boolean isEmpty() {
        return this.value == null || this.value.isEmpty();
    }

    private static String normaliseXMLLongString(String value) {
        String normalized = FORBIDDEN_PATTERN.matcher(value).replaceAll("");
        normalized = HtmlAndXmlEscape.unescapeHtmlAndXMLEntities(normalized);
        normalized = normalized.replace("<", "< ");
        normalized = HTML_ENTITY_PATTERN.matcher(normalized).replaceAll("& $1");
        return HtmlAndXmlEscape.escapeXml(normalized);
    }

    @Override
    protected String writeXML(int depth) {
        StringBuilder result = new StringBuilder();
        String tabs = MetadataXMLSplittedNode.depthTabs(depth);
        String normalisedValue = MetadataXMLSplittedNode.normaliseXMLLongString(((MetadataXMLString)this.value).getValue());
        int chunkBeg = 0;
        while (chunkBeg < normalisedValue.length()) {
            int chunkEnd = MetadataXMLSplittedNode.findCutPosition(normalisedValue, chunkBeg, 32000);
            if (chunkEnd <= chunkBeg) {
                chunkEnd = normalisedValue.length();
            }
            String subValue = normalisedValue.substring(chunkBeg, chunkEnd);
            result.append(tabs).append('<').append(this.tag);
            if (this.attributename != null) {
                result.append(' ').append(this.attributename).append("=\"").append(this.attributevalue).append("\"");
            }
            result.append('>').append(subValue).append("</").append(this.tag).append(">\n");
            chunkBeg = chunkEnd;
        }
        return result.toString();
    }

    public MetadataXMLSplittedNode(String tag, String value) {
        super(tag, value);
    }

    public MetadataXMLSplittedNode(String tag, String attributename, String attributevalue, String value) {
        super(tag, attributename, attributevalue, value);
    }

    private static int findCutPosition(String s, int beg, int maxBytesLength) {
        char c;
        int utf8len;
        int i;
        int length = s.length();
        int bytesCount = 0;
        int lastSpace = -1;
        int lastReturn = -1;
        if ((length - beg) * 3 < maxBytesLength) {
            return s.length();
        }
        for (i = beg; i < length && (bytesCount += (utf8len = (c = s.charAt(i)) <= '\u007f' ? 1 : (c <= '\u07ff' ? 2 : (Character.isHighSurrogate(c) ? 4 : 3)))) <= maxBytesLength; ++i) {
            if (c == '\r' || c == '\n') {
                lastReturn = i + 1;
                continue;
            }
            if (!Character.isSpaceChar(c)) continue;
            lastSpace = i + 1;
        }
        if (bytesCount < maxBytesLength) {
            return i;
        }
        if (lastReturn != -1) {
            return lastReturn;
        }
        if (lastSpace != -1) {
            return lastSpace;
        }
        return i;
    }
}

