/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.nodes;

import fr.gouv.vitam.tools.mailextractlib.nodes.MetadataXML;
import fr.gouv.vitam.tools.mailextractlib.nodes.MetadataXMLString;

public class MetadataXMLNode
extends MetadataXML {
    String tag;
    String attributename;
    String attributevalue;
    MetadataXML value;

    @Override
    public boolean isEmpty() {
        return this.value == null;
    }

    @Override
    protected String writeXML(int depth) {
        StringBuilder sb = new StringBuilder();
        String tabs = MetadataXMLNode.depthTabs(depth);
        sb.append(tabs).append('<').append(this.tag);
        if (this.attributename != null) {
            sb.append(' ').append(this.attributename).append("=\"").append(this.attributevalue).append('\"');
        }
        sb.append('>');
        if (this.value instanceof MetadataXMLString) {
            sb.append(this.value.writeXML(depth + 1));
        } else {
            sb.append('\n').append(this.value.writeXML(depth + 1)).append('\n').append(tabs);
        }
        sb.append("</").append(this.tag).append('>');
        return sb.toString();
    }

    public MetadataXMLNode(String tag) {
        this.tag = tag;
        this.attributename = null;
        this.attributevalue = null;
        this.value = null;
    }

    public MetadataXMLNode(String tag, MetadataXML value) {
        this.tag = tag;
        this.attributename = null;
        this.attributevalue = null;
        this.value = value;
    }

    public MetadataXMLNode(String tag, String attributename, String attributevalue, MetadataXML value) {
        this.tag = tag;
        this.attributename = attributename;
        this.attributevalue = attributevalue;
        this.value = value;
    }

    public MetadataXMLNode(String tag, String value) {
        this.tag = tag;
        this.attributename = null;
        this.attributevalue = null;
        this.value = new MetadataXMLString(value);
    }

    public MetadataXMLNode(String tag, String attributename, String attributevalue, String value) {
        this.tag = tag;
        this.attributename = attributename;
        this.attributevalue = attributevalue;
        this.value = new MetadataXMLString(value);
    }

    public String writeXML() {
        return this.writeXML(0);
    }
}

