/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.nodes;

import fr.gouv.vitam.tools.mailextractlib.core.StoreExtractor;
import fr.gouv.vitam.tools.mailextractlib.nodes.MetadataPerson;
import fr.gouv.vitam.tools.mailextractlib.nodes.MetadataXMLList;
import fr.gouv.vitam.tools.mailextractlib.nodes.MetadataXMLNode;
import fr.gouv.vitam.tools.mailextractlib.nodes.MetadataXMLSplittedNode;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractLibException;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractProgressLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class ArchiveUnit {
    private StoreExtractor storeExtractor;
    private String rootPath;
    private String name;
    private boolean forceMessageUnit;
    private MetadataXMLList contentmetadatalist = new MetadataXMLList();
    private List<ArchiveObject> objects = new ArrayList<ArchiveObject>();

    public ArchiveUnit(StoreExtractor storeExtractor, String rootPath, String name) {
        this.storeExtractor = storeExtractor;
        this.rootPath = rootPath;
        this.name = name;
        this.forceMessageUnit = false;
    }

    public ArchiveUnit(StoreExtractor storeExtractor, ArchiveUnit father, String unitType, String name) {
        this.storeExtractor = storeExtractor;
        if (unitType == null) {
            this.name = name;
        } else {
            this.name = this.normalizeUniqUnitname(unitType, name);
            if (unitType.equals("Message")) {
                this.forceMessageUnit = true;
            }
        }
        this.rootPath = father.getFullName();
    }

    public MailExtractProgressLogger getProgressLogger() {
        return this.storeExtractor.getProgressLogger();
    }

    public String getFullName() {
        return this.rootPath + File.separator + this.getName();
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setObjectUnit(boolean b) {
        this.forceMessageUnit = true;
    }

    public String getName() {
        if (!this.forceMessageUnit && this.objects.isEmpty()) {
            return this.name;
        }
        if (this.storeExtractor.getOptions().model == 1) {
            return "__" + this.name + "__";
        }
        return this.name;
    }

    public void addMetadata(String key, String value, boolean mandatory) throws InterruptedException {
        if (value != null && !value.isEmpty()) {
            this.contentmetadatalist.addMetadataXMLNode(new MetadataXMLNode(key, value));
        } else if (mandatory) {
            MailExtractProgressLogger.doProgressLog(this.getProgressLogger(), 60, "mailextractlib: mandatory metadata '" + key + "' empty in unit '" + this.name + "' in folder '" + this.rootPath + "'", null);
        }
    }

    public void addLongMetadata(String key, String value, boolean mandatory) throws InterruptedException {
        if (value != null && !value.isEmpty()) {
            this.contentmetadatalist.addMetadataXMLNode(new MetadataXMLSplittedNode(key, value));
        } else if (mandatory) {
            MailExtractProgressLogger.doProgressLog(this.getProgressLogger(), 60, "mailextractlib: mandatory metadata '" + key + "' empty in unit '" + this.name + "' in folder '" + this.rootPath + "'", null);
        }
    }

    public void addMetadata(String key, String attributename, String attributevalue, String value, boolean mandatory) throws InterruptedException {
        if (value != null && !value.isEmpty()) {
            this.contentmetadatalist.addMetadataXMLNode(new MetadataXMLNode(key, attributename, attributevalue, value));
        } else if (mandatory) {
            MailExtractProgressLogger.doProgressLog(this.getProgressLogger(), 60, "mailextractlib: mandatory metadata '" + key + "' is not defined in unit '" + this.name + "' in folder '" + this.rootPath + "'", null);
        }
    }

    public void addDefaultValuedMetadata(String key, String value, String defaultValue) {
        if (value != null && !value.isEmpty()) {
            this.contentmetadatalist.addMetadataXMLNode(new MetadataXMLNode(key, value));
        } else {
            this.contentmetadatalist.addMetadataXMLNode(new MetadataXMLNode(key, defaultValue));
        }
    }

    public void addSameMetadataList(String key, List<String> valuesList, boolean mandatory) throws InterruptedException {
        if (valuesList != null && !valuesList.isEmpty()) {
            for (String s : valuesList) {
                this.contentmetadatalist.addMetadataXMLNode(new MetadataXMLNode(key, s));
            }
        } else if (mandatory) {
            MailExtractProgressLogger.doProgressLog(this.getProgressLogger(), 60, "mailextractlib: mandatory metadata '" + key + "' empty in unit '" + this.name + "' in folder '" + this.rootPath + "'", null);
        }
    }

    public void addPersonMetadata(String key, String value, boolean mandatory) throws InterruptedException {
        if (value != null && !value.isEmpty()) {
            MetadataPerson p = new MetadataPerson(value);
            MetadataXMLList mlMetaData = new MetadataXMLList();
            MetadataXMLNode mvMetaData = new MetadataXMLNode("FullName", p.fullName);
            mlMetaData.addMetadataXMLNode(mvMetaData);
            mvMetaData = new MetadataXMLNode("Identifier", p.identifier);
            mlMetaData.addMetadataXMLNode(mvMetaData);
            this.contentmetadatalist.addMetadataXMLNode(new MetadataXMLNode(key, mlMetaData));
        } else if (mandatory) {
            MailExtractProgressLogger.doProgressLog(this.getProgressLogger(), 60, "mailextractlib: mandatory metadata '" + key + "' empty in unit '" + this.name + "' in folder '" + this.rootPath + "'", null);
        }
    }

    public void addEventMetadata(String identifier, String type, String dateTime, String detail) {
        MetadataXMLList mlMetaData = new MetadataXMLList();
        MetadataXMLNode mvMetaData = new MetadataXMLNode("EventIdentifier", identifier);
        mlMetaData.addMetadataXMLNode(mvMetaData);
        mvMetaData = new MetadataXMLNode("EventType", type);
        mlMetaData.addMetadataXMLNode(mvMetaData);
        mvMetaData = new MetadataXMLNode("EventDateTime", dateTime);
        mlMetaData.addMetadataXMLNode(mvMetaData);
        mvMetaData = new MetadataXMLNode("EventDetail", detail);
        mlMetaData.addMetadataXMLNode(mvMetaData);
        this.contentmetadatalist.addMetadataXMLNode(new MetadataXMLNode("Event", mlMetaData));
    }

    public void addPersonMetadataList(String key, List<String> valuesList, boolean mandatory) throws InterruptedException {
        if (valuesList != null && valuesList.size() != 0) {
            for (String s : valuesList) {
                MetadataPerson p = new MetadataPerson(s);
                MetadataXMLList mlMetaData = new MetadataXMLList();
                MetadataXMLNode mvMetaData = new MetadataXMLNode("FullName", p.fullName);
                mlMetaData.addMetadataXMLNode(mvMetaData);
                mvMetaData = new MetadataXMLNode("Identifier", p.identifier);
                mlMetaData.addMetadataXMLNode(mvMetaData);
                this.contentmetadatalist.addMetadataXMLNode(new MetadataXMLNode(key, mlMetaData));
            }
        } else if (mandatory) {
            MailExtractProgressLogger.doProgressLog(this.getProgressLogger(), 60, "mailextractlib: mandatory metadata '" + key + "' empty in unit '" + this.name + "' in folder '" + this.rootPath + "'", null);
        }
    }

    public void addObject(String stringContent, String filename, String usage, int version) {
        this.objects.add(new ArchiveObject(stringContent.getBytes(StandardCharsets.UTF_8), this.normalizeFilename(filename), usage, version));
    }

    public void addObject(byte[] byteContent, String filename, String usage, int version) {
        this.objects.add(new ArchiveObject(byteContent, this.normalizeFilename(filename), usage, version));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDirectory(String dirname) throws MailExtractLibException {
        StoreExtractor storeExtractor = this.storeExtractor.getRootStoreExtractor();
        synchronized (storeExtractor) {
            File dir = new File(dirname);
            if (!dir.isDirectory() && !dir.mkdirs()) {
                throw new MailExtractLibException("mailextractlib: can't create destination directory[" + dirname + "] for writing unit \"" + this.name + "\"", null);
            }
        }
    }

    private void writeFile(String dirPath, String filename, byte[] byteContent) throws MailExtractLibException {
        try (FileOutputStream fos = new FileOutputStream(dirPath + File.separator + filename);){
            if (byteContent != null) {
                fos.write(byteContent);
            }
        }
        catch (IOException ex) {
            if (dirPath.length() + filename.length() > 250) {
                throw new MailExtractLibException("mailextractlib: illegal destination file (may be too long pathname), writing unit \"" + this.name + "\" dir=" + dirPath + " filename=" + filename, ex);
            }
            throw new MailExtractLibException("mailextractlib: illegal destination file, writing unit \"" + this.name + "\" dir=" + dirPath + " filename=" + filename, ex);
        }
    }

    public void write() throws MailExtractLibException {
        String dirPath = this.getFullName();
        this.createDirectory(dirPath);
        MetadataXMLNode contentmetadata = new MetadataXMLNode("Content", this.contentmetadatalist);
        if (this.storeExtractor.getOptions().model == 1) {
            this.writeFile(dirPath, "ArchiveUnitContent.xml", contentmetadata.writeXML().getBytes(StandardCharsets.UTF_8));
        } else {
            this.writeFile(dirPath, "__ArchiveUnitMetadata.xml", contentmetadata.writeXML().getBytes(StandardCharsets.UTF_8));
        }
        if (!this.objects.isEmpty()) {
            for (ArchiveObject o : this.objects) {
                String filename = o.filename == null || o.filename.isEmpty() ? "undefined" : o.filename;
                if (this.storeExtractor.getOptions().model == 1) {
                    this.writeFile(dirPath, "__" + o.usage + "_" + Integer.toString(o.version) + "_" + filename, o.rawContent);
                    continue;
                }
                this.writeFile(dirPath, "__" + o.usage + "_" + Integer.toString(o.version) + "__" + filename, o.rawContent);
            }
        }
    }

    private String normalizeFilename(String filename) {
        String result;
        String extension = "";
        int lastPoint = filename.lastIndexOf(46);
        if (lastPoint != -1) {
            extension = filename.substring(lastPoint);
            result = lastPoint >= 1 ? filename.substring(0, lastPoint) : "";
        } else {
            result = filename;
        }
        int len = this.storeExtractor.getOptions().namesLength + 20;
        result = result.replaceAll("[^\\p{IsAlphabetic}\\p{Digit}\\.]", "-");
        if (result.length() > len) {
            result = result.substring(0, len);
        }
        return result + extension;
    }

    private String normalizeUniqUnitname(String type, String filename) {
        Object result = "";
        int len = this.storeExtractor.getOptions().namesLength;
        if (len < 32) {
            type = type.substring(0, 1);
        }
        if (filename != null) {
            result = filename.replaceAll("[^\\p{IsAlphabetic}\\p{Digit}]", "-");
        }
        if (((String)result).length() > len) {
            result = ((String)result).substring(0, len);
        }
        int uniqID = this.storeExtractor.getNewUniqID();
        result = type + "#" + Integer.toString(uniqID) + "-" + (String)result;
        return result;
    }

    private class ArchiveObject {
        String filename;
        String usage;
        int version;
        byte[] rawContent;

        ArchiveObject(byte[] rawContent, String filename, String usage, int version) {
            this.rawContent = rawContent;
            this.filename = filename;
            this.usage = usage;
            this.version = version;
        }
    }
}

