/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.formattools.rtf;

import fr.gouv.vitam.tools.mailextractlib.formattools.rtf.CharsetUtils;
import fr.gouv.vitam.tools.mailextractlib.formattools.rtf.RTFGroupState;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractLibException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HTMLFromRTFExtractor {
    private PushbackInputStream pbis;
    private CharsetDecoder decoder;
    private Charset globalCharset;
    private Charset globalLastCharset;
    private int globalDefaultFont;
    private int globalCurFontID;
    private boolean globalInHeader;
    private RTFGroupState globalGroupState;
    private int globalAnsiSkip;
    private StringBuilder resultBuilder;
    private String resultString;
    private byte[] pendingBytes = new byte[16];
    private int pendingByteCount;
    private ByteBuffer pendingByteBuffer;
    private char[] outputArray;
    private CharBuffer outputBuffer;
    private char[] pendingChars = new char[10];
    private int pendingCharCount;
    private boolean isText;
    private boolean isHTML;
    private static final Charset ASCII = Charset.forName("US-ASCII");
    private static final Charset WINDOWS_1252 = HTMLFromRTFExtractor.getCharset("WINDOWS-1252");
    private static final Charset MAC_ROMAN = HTMLFromRTFExtractor.getCharset("MacRoman");
    private static final Charset SHIFT_JIS = HTMLFromRTFExtractor.getCharset("Shift_JIS");
    private static final Charset WINDOWS_57011 = HTMLFromRTFExtractor.getCharset("windows-57011");
    private static final Charset WINDOWS_57010 = HTMLFromRTFExtractor.getCharset("windows-57010");
    private static final Charset WINDOWS_57009 = HTMLFromRTFExtractor.getCharset("windows-57009");
    private static final Charset WINDOWS_57008 = HTMLFromRTFExtractor.getCharset("windows-57008");
    private static final Charset WINDOWS_57007 = HTMLFromRTFExtractor.getCharset("windows-57007");
    private static final Charset WINDOWS_57006 = HTMLFromRTFExtractor.getCharset("windows-57006");
    private static final Charset WINDOWS_57005 = HTMLFromRTFExtractor.getCharset("windows-57005");
    private static final Charset WINDOWS_57004 = HTMLFromRTFExtractor.getCharset("windows-57004");
    private static final Charset WINDOWS_57003 = HTMLFromRTFExtractor.getCharset("windows-57003");
    private static final Charset X_ISCII91 = HTMLFromRTFExtractor.getCharset("x-ISCII91");
    private static final Charset X_MAC_CENTRAL_EUROPE = HTMLFromRTFExtractor.getCharset("x-MacCentralEurope");
    private static final Charset MAC_CYRILLIC = HTMLFromRTFExtractor.getCharset("MacCyrillic");
    private static final Charset X_JOHAB = HTMLFromRTFExtractor.getCharset("x-Johab");
    private static final Charset CP12582 = HTMLFromRTFExtractor.getCharset("CP1258");
    private static final Charset CP12572 = HTMLFromRTFExtractor.getCharset("CP1257");
    private static final Charset CP12562 = HTMLFromRTFExtractor.getCharset("CP1256");
    private static final Charset CP12552 = HTMLFromRTFExtractor.getCharset("CP1255");
    private static final Charset CP12542 = HTMLFromRTFExtractor.getCharset("CP1254");
    private static final Charset CP12532 = HTMLFromRTFExtractor.getCharset("CP1253");
    private static final Charset CP1252 = HTMLFromRTFExtractor.getCharset("CP1252");
    private static final Charset CP12512 = HTMLFromRTFExtractor.getCharset("CP1251");
    private static final Charset CP12502 = HTMLFromRTFExtractor.getCharset("CP1250");
    private static final Charset CP950 = HTMLFromRTFExtractor.getCharset("CP950");
    private static final Charset CP949 = HTMLFromRTFExtractor.getCharset("CP949");
    private static final Charset MS9362 = HTMLFromRTFExtractor.getCharset("MS936");
    private static final Charset MS8742 = HTMLFromRTFExtractor.getCharset("MS874");
    private static final Charset CP866 = HTMLFromRTFExtractor.getCharset("CP866");
    private static final Charset CP865 = HTMLFromRTFExtractor.getCharset("CP865");
    private static final Charset CP864 = HTMLFromRTFExtractor.getCharset("CP864");
    private static final Charset CP863 = HTMLFromRTFExtractor.getCharset("CP863");
    private static final Charset CP862 = HTMLFromRTFExtractor.getCharset("CP862");
    private static final Charset CP860 = HTMLFromRTFExtractor.getCharset("CP860");
    private static final Charset CP852 = HTMLFromRTFExtractor.getCharset("CP852");
    private static final Charset CP8502 = HTMLFromRTFExtractor.getCharset("CP850");
    private static final Charset CP819 = HTMLFromRTFExtractor.getCharset("CP819");
    private static final Charset WINDOWS_720 = HTMLFromRTFExtractor.getCharset("windows-720");
    private static final Charset WINDOWS_711 = HTMLFromRTFExtractor.getCharset("windows-711");
    private static final Charset WINDOWS_710 = HTMLFromRTFExtractor.getCharset("windows-710");
    private static final Charset WINDOWS_709 = HTMLFromRTFExtractor.getCharset("windows-709");
    private static final Charset ISO_8859_6 = HTMLFromRTFExtractor.getCharset("ISO-8859-6");
    private static final Charset CP4372 = HTMLFromRTFExtractor.getCharset("CP437");
    private static final Charset CP850 = HTMLFromRTFExtractor.getCharset("cp850");
    private static final Charset CP437 = HTMLFromRTFExtractor.getCharset("cp437");
    private static final Charset MS874 = HTMLFromRTFExtractor.getCharset("ms874");
    private static final Charset CP1257 = HTMLFromRTFExtractor.getCharset("cp1257");
    private static final Charset CP1256 = HTMLFromRTFExtractor.getCharset("cp1256");
    private static final Charset CP1255 = HTMLFromRTFExtractor.getCharset("cp1255");
    private static final Charset CP1258 = HTMLFromRTFExtractor.getCharset("cp1258");
    private static final Charset CP1254 = HTMLFromRTFExtractor.getCharset("cp1254");
    private static final Charset CP1253 = HTMLFromRTFExtractor.getCharset("cp1253");
    private static final Charset MS950 = HTMLFromRTFExtractor.getCharset("ms950");
    private static final Charset MS936 = HTMLFromRTFExtractor.getCharset("ms936");
    private static final Charset MS1361 = HTMLFromRTFExtractor.getCharset("ms1361");
    private static final Charset MS932 = HTMLFromRTFExtractor.getCharset("MS932");
    private static final Charset CP1251 = HTMLFromRTFExtractor.getCharset("cp1251");
    private static final Charset CP1250 = HTMLFromRTFExtractor.getCharset("cp1250");
    private static final Charset MAC_THAI = HTMLFromRTFExtractor.getCharset("MacThai");
    private static final Charset MAC_TURKISH = HTMLFromRTFExtractor.getCharset("MacTurkish");
    private static final Charset MAC_GREEK = HTMLFromRTFExtractor.getCharset("MacGreek");
    private static final Charset MAC_ARABIC = HTMLFromRTFExtractor.getCharset("MacArabic");
    private static final Charset MAC_HEBREW = HTMLFromRTFExtractor.getCharset("MacHebrew");
    private static final Charset JOHAB = HTMLFromRTFExtractor.getCharset("johab");
    private static final Charset BIG5 = HTMLFromRTFExtractor.getCharset("Big5");
    private static final Charset GB2312 = HTMLFromRTFExtractor.getCharset("GB2312");
    private static final Charset MS949 = HTMLFromRTFExtractor.getCharset("ms949");
    private static final Map<Integer, Charset> FCHARSET_MAP = new HashMap<Integer, Charset>();
    private static final Map<Integer, Charset> ANSICPG_MAP = new HashMap<Integer, Charset>();
    private final Map<Integer, Charset> fontToCharset = new HashMap<Integer, Charset>();

    public HTMLFromRTFExtractor(InputStream is) {
        this.pbis = new PushbackInputStream(is, 100);
        this.initHTMLFromRTFExtractor();
    }

    public HTMLFromRTFExtractor(String rtfText) {
        ByteArrayInputStream bais = new ByteArrayInputStream(rtfText.getBytes(StandardCharsets.UTF_8));
        this.pbis = new PushbackInputStream(bais, 100);
        this.initHTMLFromRTFExtractor();
        this.detectEncapsulatedHTMLorTEXTinRTF();
    }

    private void initHTMLFromRTFExtractor() {
        this.decoder = null;
        this.globalCharset = WINDOWS_1252;
        this.globalLastCharset = null;
        this.globalDefaultFont = -1;
        this.globalCurFontID = 0;
        this.globalInHeader = true;
        this.globalGroupState = null;
        this.globalAnsiSkip = 0;
        this.resultBuilder = null;
        this.pendingBytes = new byte[16];
        this.pendingByteCount = 0;
        this.pendingByteBuffer = ByteBuffer.wrap(this.pendingBytes);
        this.outputArray = new char[128];
        this.outputBuffer = CharBuffer.wrap(this.outputArray);
        this.pendingChars = new char[10];
        this.pendingCharCount = 0;
    }

    private static Charset getCharset(String name) {
        try {
            return CharsetUtils.forName(name);
        }
        catch (Exception e) {
            return ASCII;
        }
    }

    private void doExtract() throws IOException {
        while (true) {
            int b;
            if ((b = this.pbis.read()) == -1) {
                this.pushText();
                break;
            }
            if (b == 92) {
                this.parseControlToken();
                continue;
            }
            if (b == 123) {
                this.pushText();
                this.processGroupStart();
                continue;
            }
            if (b == 125) {
                this.pushText();
                this.processGroupEnd();
                if (this.globalGroupState != null) continue;
                break;
            }
            if (b == 13 || b == 10 || this.globalGroupState.ignore) continue;
            if (this.globalAnsiSkip != 0) {
                --this.globalAnsiSkip;
                continue;
            }
            this.addOutputByte(b);
        }
    }

    private void processGroupStart() throws IOException {
        this.globalAnsiSkip = 0;
        this.globalGroupState = new RTFGroupState(this.globalGroupState);
        int b2 = this.pbis.read();
        if (b2 == 92) {
            int b3 = this.pbis.read();
            if (b3 == 42) {
                this.globalGroupState.setInIgnorable(true);
            }
            this.pbis.unread(b3);
        }
        this.pbis.unread(b2);
    }

    private void processGroupEnd() {
        if (this.globalInHeader) {
            this.resultBuilder.setLength(0);
        }
        this.globalAnsiSkip = 0;
        this.globalGroupState = this.globalGroupState.getPreviousGroupState();
    }

    private void parseControlToken() throws IOException {
        int b = this.pbis.read();
        if (b == 39) {
            this.parseHexChar();
        } else if (HTMLFromRTFExtractor.isAlpha(b)) {
            this.parseControlWord((char)b);
        } else if (!(b != 123 && b != 125 && b != 92 && b != 13 && b != 10 || this.globalGroupState.ignore)) {
            this.addOutputByte(b);
        } else if (b != -1) {
            this.processControlSymbol((char)b);
        }
    }

    private void parseHexChar() throws IOException {
        int hex1 = this.pbis.read();
        if (!HTMLFromRTFExtractor.isHexChar(hex1)) {
            this.pbis.unread(hex1);
            return;
        }
        int hex2 = this.pbis.read();
        if (!HTMLFromRTFExtractor.isHexChar(hex2)) {
            this.pbis.unread(hex2);
            return;
        }
        if (this.globalAnsiSkip != 0) {
            --this.globalAnsiSkip;
        } else if (!this.globalGroupState.ignore) {
            this.addOutputByte(16 * HTMLFromRTFExtractor.hexValue(hex1) + HTMLFromRTFExtractor.hexValue(hex2));
        }
    }

    private void parseControlWord(int firstChar) throws IOException {
        StringBuilder controlWord = new StringBuilder();
        controlWord.append((char)firstChar);
        int b = this.pbis.read();
        while (HTMLFromRTFExtractor.isAlpha(b)) {
            controlWord.append((char)b);
            b = this.pbis.read();
        }
        boolean hasParam = false;
        boolean negParam = false;
        if (b == 45) {
            negParam = true;
            hasParam = true;
            b = this.pbis.read();
        }
        int param = 0;
        while (HTMLFromRTFExtractor.isDigit(b)) {
            param *= 10;
            param += b - 48;
            hasParam = true;
            b = this.pbis.read();
        }
        if (b != 32) {
            this.pbis.unread(b);
        }
        if (hasParam) {
            if (negParam) {
                param = -param;
            }
            this.processControlWord(controlWord.toString(), param);
        } else {
            this.processNoParamControlWord(controlWord.toString());
        }
    }

    private void processNoParamControlWord(String controlWord) {
        if (this.globalInHeader) {
            switch (controlWord) {
                case "ansi": {
                    this.globalCharset = WINDOWS_1252;
                    break;
                }
                case "pca": {
                    this.globalCharset = CP850;
                    break;
                }
                case "pc": {
                    this.globalCharset = CP437;
                    break;
                }
                case "mac": {
                    this.globalCharset = MAC_ROMAN;
                    break;
                }
                case "par": 
                case "pard": 
                case "sect": 
                case "sectd": 
                case "plain": {
                    this.globalInHeader = false;
                }
            }
        }
        if (!this.globalGroupState.ignore) {
            switch (controlWord) {
                case "par": 
                case "line": {
                    this.addOutputChar('\r');
                    this.addOutputChar('\n');
                    break;
                }
                case "tab": {
                    this.addOutputChar('\t');
                    break;
                }
                case "htmltag": {
                    this.pushText();
                    this.globalGroupState.setInHtmltag(true);
                    break;
                }
                case "htmlrtf": {
                    this.pushText();
                    this.globalGroupState.setInHtmlrtf(true);
                }
            }
        }
    }

    private void processControlWord(String controlWord, int param) {
        if (this.globalInHeader) {
            switch (controlWord) {
                case "ansicpg": {
                    Charset cs = ANSICPG_MAP.get(param);
                    if (cs == null) break;
                    this.globalCharset = cs;
                    break;
                }
                case "f": {
                    this.globalCurFontID = param;
                    break;
                }
                case "deff": {
                    this.globalDefaultFont = param;
                    break;
                }
                case "fcharset": {
                    Charset cs = FCHARSET_MAP.get(param);
                    if (cs == null) break;
                    this.fontToCharset.put(this.globalCurFontID, cs);
                }
            }
        } else {
            switch (controlWord) {
                case "htmltag": {
                    this.pushText();
                    this.globalGroupState.setInHtmltag(true);
                    break;
                }
                case "htmlrtf": {
                    this.pushText();
                    if (param == 0) {
                        this.globalGroupState.setInHtmlrtf(false);
                        break;
                    }
                    this.globalGroupState.setInHtmlrtf(true);
                    break;
                }
                case "f": {
                    Charset fontCharset = this.fontToCharset.get(param);
                    this.pushText();
                    if (fontCharset != null) {
                        this.globalGroupState.fontCharset = fontCharset;
                        break;
                    }
                    this.globalGroupState.fontCharset = null;
                    break;
                }
                case "u": {
                    if (!this.globalGroupState.ignore) {
                        char utf16CodeUnit = (char)(param & 0xFFFF);
                        this.addOutputChar(utf16CodeUnit);
                    }
                    this.globalAnsiSkip = this.globalGroupState.ucSkip;
                    break;
                }
                case "uc": {
                    this.globalGroupState.ucSkip = param;
                }
            }
        }
    }

    private void processControlSymbol(char ch) {
        switch (ch) {
            case '~': {
                this.addOutputChar('\u00a0');
                break;
            }
            case '*': {
                break;
            }
            case '-': {
                this.addOutputChar('\u00ad');
                break;
            }
            case '_': {
                this.addOutputChar('\u2011');
                break;
            }
        }
    }

    protected static boolean isHexChar(int ch) {
        return ch >= 48 && ch <= 57 || ch >= 97 && ch <= 102 || ch >= 65 && ch <= 70;
    }

    private static boolean isAlpha(int ch) {
        return ch >= 97 && ch <= 122 || ch >= 65 && ch <= 90;
    }

    private static boolean isDigit(int ch) {
        return ch >= 48 && ch <= 57;
    }

    protected static int hexValue(int ch) {
        if (ch >= 48 && ch <= 57) {
            return ch - 48;
        }
        if (ch >= 97 && ch <= 122) {
            return 10 + (ch - 97);
        }
        assert (ch >= 65 && ch <= 90);
        return 10 + (ch - 65);
    }

    private void addOutputByte(int b) {
        assert (b >= 0 && b < 256) : "byte value out of range: " + b;
        if (this.pendingCharCount != 0) {
            this.pushPendingChars();
        }
        if (this.pendingByteCount == this.pendingBytes.length) {
            byte[] newArray = new byte[(int)((double)this.pendingBytes.length * 1.25)];
            System.arraycopy(this.pendingBytes, 0, newArray, 0, this.pendingBytes.length);
            this.pendingBytes = newArray;
            this.pendingByteBuffer = ByteBuffer.wrap(this.pendingBytes);
        }
        this.pendingBytes[this.pendingByteCount++] = (byte)b;
    }

    private void addOutputChar(char ch) {
        if (this.pendingByteCount != 0) {
            this.pushPendingBytes();
        }
        if (this.pendingCharCount == this.pendingChars.length) {
            char[] newArray = new char[(int)((double)this.pendingChars.length * 1.25)];
            System.arraycopy(this.pendingChars, 0, newArray, 0, this.pendingChars.length);
            this.pendingChars = newArray;
        }
        this.pendingChars[this.pendingCharCount++] = ch;
    }

    private void pushPendingBytes() {
        if (this.pendingByteCount > 0 && !this.globalGroupState.ignore) {
            int pos;
            CoderResult result;
            CharsetDecoder decoder = this.getDecoder();
            this.pendingByteBuffer.limit(this.pendingByteCount);
            assert (this.pendingByteBuffer.position() == 0);
            assert (this.outputBuffer.position() == 0);
            do {
                result = decoder.decode(this.pendingByteBuffer, this.outputBuffer, true);
                pos = this.outputBuffer.position();
                if (pos <= 0) continue;
                this.resultBuilder.append(this.outputArray, 0, pos);
                this.outputBuffer.position(0);
            } while (result != CoderResult.UNDERFLOW);
            do {
                result = decoder.flush(this.outputBuffer);
                pos = this.outputBuffer.position();
                if (pos <= 0) continue;
                this.resultBuilder.append(this.outputArray, 0, pos);
                this.outputBuffer.position(0);
            } while (result != CoderResult.UNDERFLOW);
            decoder.reset();
            this.pendingByteBuffer.position(0);
        }
        this.pendingByteCount = 0;
    }

    private CharsetDecoder getDecoder() {
        Charset charset = this.getCharset();
        if (this.globalLastCharset == null || !charset.equals(this.globalLastCharset)) {
            this.decoder = charset.newDecoder();
            this.decoder.onMalformedInput(CodingErrorAction.REPLACE);
            this.decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.globalLastCharset = charset;
        }
        return this.decoder;
    }

    private Charset getCharset() {
        Charset cs;
        if (this.globalGroupState.fontCharset != null) {
            return this.globalGroupState.fontCharset;
        }
        if (this.globalDefaultFont != -1 && !this.globalInHeader && (cs = this.fontToCharset.get(this.globalDefaultFont)) != null) {
            return cs;
        }
        return this.globalCharset;
    }

    private void pushPendingChars() {
        if (this.pendingCharCount != 0) {
            this.resultBuilder.append(this.pendingChars, 0, this.pendingCharCount);
            this.pendingCharCount = 0;
        }
    }

    private void pushText() {
        if (this.pendingByteCount != 0) {
            assert (this.pendingCharCount == 0);
            this.pushPendingBytes();
        } else {
            this.pushPendingChars();
        }
    }

    private boolean detectEncapsulatedHTMLorTEXTinRTF() {
        String test;
        byte[] buf = new byte[100];
        try {
            int len;
            int inc;
            for (len = 0; len < 100; len += inc) {
                inc = this.pbis.read(buf, len, 100 - len);
                if (inc != -1) continue;
                return false;
            }
            test = new String(buf);
            this.pbis.unread(buf, 0, len);
        }
        catch (IOException e) {
            return false;
        }
        if (test.indexOf("\\fromhtml") >= 0) {
            this.isHTML = true;
            return true;
        }
        if (test.indexOf("\\fromtext") >= 0) {
            this.isText = true;
            return true;
        }
        return false;
    }

    public boolean isEncapsulatedHTMLinRTF() {
        return this.isHTML;
    }

    public boolean isEncapsulatedTEXTinRTF() {
        return this.isText;
    }

    public String getDeEncapsulateHTMLFromRTF() throws MailExtractLibException {
        if (this.resultString == null) {
            this.resultBuilder = new StringBuilder();
            try {
                this.doExtract();
            }
            catch (IOException e) {
                throw new MailExtractLibException("Can't extract html from rtf", e);
            }
            this.resultString = this.resultBuilder.toString();
            if (this.isHTML) {
                Matcher m = Pattern.compile("<(h|H)(e|E)(a|A)(d|D).*>").matcher(this.resultString);
                this.resultString = m.find() ? this.resultBuilder.insert(m.end(), "\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">").toString() : this.resultBuilder.insert(0, "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n").toString();
            }
            this.resultBuilder = null;
        }
        return this.resultString;
    }

    static {
        FCHARSET_MAP.put(0, WINDOWS_1252);
        FCHARSET_MAP.put(77, MAC_ROMAN);
        FCHARSET_MAP.put(78, SHIFT_JIS);
        FCHARSET_MAP.put(79, MS949);
        FCHARSET_MAP.put(80, GB2312);
        FCHARSET_MAP.put(81, BIG5);
        FCHARSET_MAP.put(82, JOHAB);
        FCHARSET_MAP.put(83, MAC_HEBREW);
        FCHARSET_MAP.put(84, MAC_ARABIC);
        FCHARSET_MAP.put(85, MAC_GREEK);
        FCHARSET_MAP.put(86, MAC_TURKISH);
        FCHARSET_MAP.put(87, MAC_THAI);
        FCHARSET_MAP.put(88, CP1250);
        FCHARSET_MAP.put(89, CP1251);
        FCHARSET_MAP.put(128, MS932);
        FCHARSET_MAP.put(129, MS949);
        FCHARSET_MAP.put(130, MS1361);
        FCHARSET_MAP.put(134, MS936);
        FCHARSET_MAP.put(136, MS950);
        FCHARSET_MAP.put(161, CP1253);
        FCHARSET_MAP.put(162, CP1254);
        FCHARSET_MAP.put(163, CP1258);
        FCHARSET_MAP.put(177, CP1255);
        FCHARSET_MAP.put(178, CP1256);
        FCHARSET_MAP.put(186, CP1257);
        FCHARSET_MAP.put(204, CP1251);
        FCHARSET_MAP.put(222, MS874);
        FCHARSET_MAP.put(238, CP1250);
        FCHARSET_MAP.put(254, CP437);
        FCHARSET_MAP.put(255, CP850);
        ANSICPG_MAP.put(437, CP4372);
        ANSICPG_MAP.put(708, ISO_8859_6);
        ANSICPG_MAP.put(709, WINDOWS_709);
        ANSICPG_MAP.put(710, WINDOWS_710);
        ANSICPG_MAP.put(819, CP819);
        ANSICPG_MAP.put(850, CP8502);
        ANSICPG_MAP.put(852, CP852);
        ANSICPG_MAP.put(860, CP860);
        ANSICPG_MAP.put(862, CP862);
        ANSICPG_MAP.put(863, CP863);
        ANSICPG_MAP.put(864, CP864);
        ANSICPG_MAP.put(865, CP865);
        ANSICPG_MAP.put(866, CP866);
        ANSICPG_MAP.put(874, MS8742);
        ANSICPG_MAP.put(932, MS932);
        ANSICPG_MAP.put(936, MS9362);
        ANSICPG_MAP.put(949, CP949);
        ANSICPG_MAP.put(950, CP950);
        ANSICPG_MAP.put(1250, CP12502);
        ANSICPG_MAP.put(1251, CP12512);
        ANSICPG_MAP.put(1252, CP1252);
        ANSICPG_MAP.put(1253, CP12532);
        ANSICPG_MAP.put(1254, CP12542);
        ANSICPG_MAP.put(1255, CP12552);
        ANSICPG_MAP.put(1256, CP12562);
        ANSICPG_MAP.put(1257, CP12572);
        ANSICPG_MAP.put(1258, CP12582);
        ANSICPG_MAP.put(1361, X_JOHAB);
        ANSICPG_MAP.put(10000, MAC_ROMAN);
        ANSICPG_MAP.put(10001, SHIFT_JIS);
        ANSICPG_MAP.put(10004, MAC_ARABIC);
        ANSICPG_MAP.put(10005, MAC_HEBREW);
        ANSICPG_MAP.put(10006, MAC_GREEK);
        ANSICPG_MAP.put(10007, MAC_CYRILLIC);
        ANSICPG_MAP.put(10029, X_MAC_CENTRAL_EUROPE);
        ANSICPG_MAP.put(10081, MAC_TURKISH);
        ANSICPG_MAP.put(57002, X_ISCII91);
        ANSICPG_MAP.put(57003, WINDOWS_57003);
        ANSICPG_MAP.put(57004, WINDOWS_57004);
        ANSICPG_MAP.put(57005, WINDOWS_57005);
        ANSICPG_MAP.put(57006, WINDOWS_57006);
        ANSICPG_MAP.put(57007, WINDOWS_57007);
        ANSICPG_MAP.put(57008, WINDOWS_57008);
        ANSICPG_MAP.put(57009, WINDOWS_57009);
        ANSICPG_MAP.put(57010, WINDOWS_57010);
        ANSICPG_MAP.put(57011, WINDOWS_57011);
    }
}

