/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.formattools;

import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractLibException;
import java.io.ByteArrayInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tika.Tika;

public class TikaExtractor {
    private static TikaExtractor INSTANCE = null;
    private Tika tika;

    public TikaExtractor() {
        Logger logger = Logger.getGlobal();
        Level memLevel = logger.getLevel();
        if (memLevel != Level.FINEST) {
            logger.setLevel(Level.OFF);
        }
        this.tika = new Tika();
        logger.setLevel(memLevel);
    }

    public static TikaExtractor getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TikaExtractor();
        }
        return INSTANCE;
    }

    public String extractTextFromBinary(byte[] rawContent) throws MailExtractLibException {
        String s = null;
        Logger logger = Logger.getGlobal();
        Level memLevel = logger.getLevel();
        if (memLevel != Level.FINEST) {
            logger.setLevel(Level.OFF);
        }
        try {
            if (rawContent.length > 0) {
                s = this.tika.parseToString(new ByteArrayInputStream(rawContent));
            }
        }
        catch (Throwable e) {
            throw new MailExtractLibException("mailextractlib.formattools: can't extract text content", e);
        }
        finally {
            logger.setLevel(memLevel);
        }
        return s;
    }

    public String getMimeType(byte[] rawContent) throws MailExtractLibException {
        String result = null;
        if (rawContent.length > 0) {
            Logger logger = Logger.getGlobal();
            Level memLevel = logger.getLevel();
            if (memLevel != Level.FINEST) {
                logger.setLevel(Level.OFF);
            }
            try {
                result = this.tika.detect(rawContent);
            }
            catch (Exception e) {
                result = "application/octet-stream";
            }
            logger.setLevel(memLevel);
        }
        return result;
    }
}

