/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.core;

import fr.gouv.vitam.tools.mailextractlib.core.StoreAttachment;
import fr.gouv.vitam.tools.mailextractlib.core.StoreElement;
import fr.gouv.vitam.tools.mailextractlib.core.StoreFolder;
import fr.gouv.vitam.tools.mailextractlib.formattools.HTMLTextExtractor;
import fr.gouv.vitam.tools.mailextractlib.formattools.TikaExtractor;
import fr.gouv.vitam.tools.mailextractlib.formattools.rtf.HTMLFromRTFExtractor;
import fr.gouv.vitam.tools.mailextractlib.nodes.ArchiveUnit;
import fr.gouv.vitam.tools.mailextractlib.nodes.MetadataPerson;
import fr.gouv.vitam.tools.mailextractlib.utils.DateRange;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractLibException;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractProgressLogger;
import fr.gouv.vitam.tools.mailextractlib.utils.RawDataSource;
import jakarta.activation.DataHandler;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimeUtility;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.poi.hmef.Attachment;
import org.apache.poi.hmef.HMEFMessage;

public abstract class StoreMessage
extends StoreElement {
    protected byte[] mimeContent;
    protected MimeMessage mimeFake;
    protected String[] bodyContent = new String[3];
    public static final int TEXT_BODY = 0;
    public static final int HTML_BODY = 1;
    public static final int RTF_BODY = 2;
    public static final int OUT_OF_BODY = 3;
    protected List<String> mailHeader;
    protected List<StoreAttachment> attachments;
    protected String subject;
    protected String from;
    protected List<String> recipientTo;
    protected List<String> recipientCc;
    protected List<String> recipientBcc;
    protected List<String> replyTo;
    protected String returnPath;
    protected Date sentDate;
    protected Date receivedDate;
    protected String messageID;
    protected String inReplyToUID;
    protected List<String> references;
    protected List<String> sender;
    public ArchiveUnit messageNode;

    protected StoreMessage(StoreFolder storeFolder) {
        super(storeFolder);
    }

    public Date getSentDate() {
        return this.sentDate;
    }

    public abstract long getMessageSize() throws InterruptedException;

    public String getSubject() {
        return this.subject;
    }

    public byte[] getMimeContent() {
        return this.mimeContent;
    }

    @Override
    public String getLogDescription() {
        String result = "message " + this.listLineId;
        result = this.subject != null ? result + " [" + this.subject + "]" : result + " [no subject]";
        return result;
    }

    protected abstract void prepareAnalyze() throws InterruptedException;

    protected abstract void analyzeSubject() throws InterruptedException;

    protected abstract void analyzeMessageID() throws InterruptedException;

    protected abstract void analyzeFrom() throws InterruptedException;

    protected abstract void analyzeRecipients() throws InterruptedException;

    protected abstract void analyzeReplyTo() throws InterruptedException;

    protected abstract void analyzeReturnPath() throws InterruptedException;

    protected abstract void analyzeDates() throws InterruptedException;

    protected abstract void analyzeInReplyToId() throws InterruptedException;

    protected abstract void analyzeReferences() throws InterruptedException;

    protected abstract void analyzeBodies() throws InterruptedException;

    protected abstract void analyzeAttachments() throws InterruptedException;

    protected void detectTNEFAttachment() throws InterruptedException {
        if (this.attachments != null && !this.attachments.isEmpty()) {
            ArrayList<StoreAttachment> newAttachments = new ArrayList<StoreAttachment>();
            for (StoreAttachment a : this.attachments) {
                boolean partialExtraction = false;
                if (a.attachmentType != 2 && a.attachmentContent instanceof byte[] && (a.mimeType.toLowerCase().equals("application/ms-tnef") || a.mimeType.toLowerCase().equals("application/vnd.ms-tnef"))) {
                    try {
                        ByteArrayInputStream bais = new ByteArrayInputStream((byte[])a.attachmentContent);
                        HMEFMessage tnefPart = new HMEFMessage(bais);
                        String rtfBody = tnefPart.getBody();
                        List<Attachment> tnefAttachments = tnefPart.getAttachments();
                        if (this.bodyContent[2] == null || this.bodyContent[2].isEmpty()) {
                            this.bodyContent[2] = rtfBody;
                        } else {
                            this.logMessageWarning("mailextractlib: redondant rtf body extracted from winmail.dat droped", null);
                        }
                        for (Attachment tnefAttachment : tnefAttachments) {
                            try {
                                StoreAttachment smAttachment = new StoreAttachment(this, tnefAttachment.getContents(), "file", tnefAttachment.getLongFilename(), null, tnefAttachment.getModifiedDate(), TikaExtractor.getInstance().getMimeType(tnefAttachment.getContents()), null, 0);
                                newAttachments.add(smAttachment);
                            }
                            catch (Exception e) {
                                this.logMessageWarning("mailextractlib: can't extract all informations from winmail.dat content, it will be extracted partially and it will be extracted as a file", e);
                                partialExtraction = true;
                            }
                        }
                        if (!partialExtraction) continue;
                        newAttachments.add(a);
                    }
                    catch (Exception e) {
                        this.logMessageWarning("mailextractlib: can't analyze winmail.dat content, it will be extracted as a file", e);
                        newAttachments.add(a);
                    }
                    continue;
                }
                newAttachments.add(a);
            }
            this.attachments = newAttachments;
        }
    }

    protected abstract byte[] getNativeMimeContent() throws InterruptedException;

    public void analyzeMessage() throws MailExtractLibException, InterruptedException {
        this.analyzeSubject();
        if (this.subject == null || this.subject.isEmpty()) {
            this.subject = "[SubjectVide]";
        }
        this.prepareAnalyze();
        this.analyzeMessageID();
        if (this.messageID == null || this.messageID.isEmpty()) {
            this.messageID = "[MessageIDVide]";
        }
        this.analyzeFrom();
        this.analyzeRecipients();
        this.analyzeReplyTo();
        this.analyzeReturnPath();
        this.analyzeDates();
        this.analyzeInReplyToId();
        this.analyzeReferences();
        this.analyzeBodies();
        this.analyzeAttachments();
        this.detectTNEFAttachment();
        this.optimizeBodies();
        StoreAttachment.detectStoreAttachments(this.attachments);
        this.mimeContent = this.getNativeMimeContent();
    }

    private void optimizeBodies() {
        if (this.bodyContent[0] != null) {
            this.bodyContent[0] = this.bodyContent[0].trim();
        }
        if (this.bodyContent[1] != null) {
            this.bodyContent[1] = this.bodyContent[1].trim();
        }
        if (this.bodyContent[2] != null) {
            this.bodyContent[2] = this.bodyContent[2].trim();
        }
        try {
            if (this.bodyContent[2] != null && !this.bodyContent[2].isEmpty()) {
                String result;
                HTMLFromRTFExtractor htmlExtractor = new HTMLFromRTFExtractor(this.bodyContent[2]);
                if (htmlExtractor.isEncapsulatedTEXTinRTF()) {
                    String result2 = htmlExtractor.getDeEncapsulateHTMLFromRTF();
                    if (result2 != null && !result2.isEmpty()) {
                        result2 = result2.trim();
                        if (this.bodyContent[0] == null || this.bodyContent[0].isEmpty()) {
                            this.bodyContent[0] = result2;
                            this.bodyContent[2] = null;
                        } else if (this.bodyContent[0].equals(result2)) {
                            this.bodyContent[2] = null;
                        }
                    }
                } else if (htmlExtractor.isEncapsulatedHTMLinRTF() && (this.bodyContent[1] == null || this.bodyContent[1].isEmpty()) && (result = htmlExtractor.getDeEncapsulateHTMLFromRTF()) != null && !result.isEmpty()) {
                    this.bodyContent[1] = result = result.trim();
                    this.bodyContent[2] = null;
                }
            }
        }
        catch (MailExtractLibException e) {
            MailExtractProgressLogger.doProgressLogIfDebug(this.getProgressLogger(), "Bodies optimization error", e);
        }
    }

    @Override
    public void processElement(boolean writeFlag) throws InterruptedException, MailExtractLibException {
        if (this.storeFolder.getStoreExtractor().getOptions().extractMessages) {
            this.listLineId = this.storeFolder.getStoreExtractor().incElementCounter(this.getClass());
            this.analyzeMessage();
            this.extractMessage(writeFlag);
            this.storeFolder.extendDateRange(this.sentDate);
            this.countMessage();
        }
    }

    @Override
    public void listElement(boolean statsFlag) throws InterruptedException, MailExtractLibException {
        if (this.storeFolder.getStoreExtractor().getOptions().extractMessages) {
            this.listLineId = this.storeFolder.getStoreExtractor().incElementCounter(this.getClass());
            this.analyzeMessage();
            if (statsFlag) {
                this.extractMessage(false);
            }
            this.countMessage();
        }
    }

    public final void extractMessage(boolean writeFlag) throws MailExtractLibException, InterruptedException {
        int logLevel;
        String textContent = null;
        if (this.subject == null || this.subject.trim().isEmpty()) {
            this.subject = "[Vide]";
        }
        this.messageNode = new ArchiveUnit(this.storeFolder.storeExtractor, this.storeFolder.folderArchiveUnit, "Message", this.subject);
        this.messageNode.addMetadata("DescriptionLevel", "Item", true);
        this.messageNode.addMetadata("Title", this.subject, true);
        this.messageNode.addMetadata("OriginatingSystemId", this.messageID, false);
        this.messageNode.addPersonMetadata("Writer", this.from, false);
        this.messageNode.addPersonMetadataList("Addressee", this.recipientTo, false);
        this.messageNode.addPersonMetadataList("Recipient", this.recipientCc, false);
        this.messageNode.addPersonMetadataList("Recipient", this.recipientBcc, false);
        this.messageNode.addMetadata("SentDate", DateRange.getISODateString(this.sentDate), false);
        this.messageNode.addMetadata("ReceivedDate", DateRange.getISODateString(this.receivedDate), false);
        if (this.inReplyToUID != null && !this.inReplyToUID.isEmpty()) {
            this.messageNode.addMetadata("OriginatingSystemIdReplyTo", this.inReplyToUID, false);
        }
        if (this.bodyContent[0] != null && !this.bodyContent[0].isEmpty()) {
            textContent = this.bodyContent[0];
        }
        if (textContent == null && this.bodyContent[1] != null) {
            textContent = HTMLTextExtractor.getInstance().act(this.bodyContent[1]);
        }
        if (textContent != null && !textContent.trim().isEmpty()) {
            if (this.getStoreExtractor().options.extractMessageTextFile) {
                this.messageNode.addObject(HTMLTextExtractor.getInstance().htmlStringtoString(textContent), this.messageID + ".txt", "TextContent", 1);
            }
            if (this.getStoreExtractor().options.extractMessageTextMetadata) {
                this.messageNode.addLongMetadata("TextContent", textContent, true);
            }
        }
        StoreAttachment.extractAttachments(this.attachments, this.messageNode, writeFlag);
        if (this.mimeContent == null) {
            this.mimeFake = this.getMimeFake();
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.mimeFake.writeTo(baos);
                this.mimeContent = baos.toByteArray();
            }
            catch (MessagingException | IOException e) {
                this.logMessageWarning("mailextractlib: can't extract raw content", e);
            }
        }
        if (this.mimeContent == null) {
            this.mimeContent = "".getBytes();
        }
        this.messageNode.addObject(this.mimeContent, this.messageID + ".eml", "BinaryMaster", 1);
        if (writeFlag && this.storeFolder.getStoreExtractor().getOptions().extractElementsContent) {
            this.messageNode.write();
        }
        if (this.getStoreExtractor().isRoot()) {
            MailExtractProgressLogger.doProgressLogOneMoreCountedObject(this.getProgressLogger(), 40, "mailextractlib: %count extracted messages");
            logLevel = 50;
        } else {
            logLevel = 60;
        }
        MailExtractProgressLogger.doProgressLog(this.getProgressLogger(), logLevel, "mailextractlib: extracted " + this.getLogDescription() + " with SentDate=" + (this.sentDate == null ? "Unknown sent date" : this.sentDate.toString()), null);
        if (writeFlag && this.getStoreExtractor().options.extractElementsList && this.getStoreExtractor().canExtractObjectsLists()) {
            this.writeToMailsList();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException("mailextractlib: interrupted");
        }
    }

    public static String getElementName() {
        return "messages";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printGlobalListCSVHeader(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            ps.println("ID;SentDate;ReceivedDate;FromName;FromAddress;ToList;Subject;MessageID;AttachmentList;ReplyTo;Folder;Size;Attached");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToMailsList() throws InterruptedException {
        PrintStream ps;
        PrintStream printStream = ps = this.storeFolder.getStoreExtractor().getGlobalListPS(this.getClass());
        synchronized (printStream) {
            try {
                MetadataPerson p;
                ps.format("\"%d\";", this.listLineId);
                ps.format("\"%s\";", this.sentDate == null ? "" : DateRange.getISODateString(this.sentDate));
                ps.format("\"%s\";", this.receivedDate == null ? "" : DateRange.getISODateString(this.receivedDate));
                if (this.from != null && !this.from.isEmpty()) {
                    p = new MetadataPerson(this.from);
                    ps.format("\"%s\";\"%s\";", this.filterHyphenForCsv(p.fullName), this.filterHyphenForCsv(p.identifier));
                } else {
                    ps.print("\"\";\"\";");
                }
                ps.format("\"%s\";", this.filterHyphenForCsv(this.personStringListToIndentifierString(this.recipientTo)));
                ps.format("\"%s\";", this.filterHyphenForCsv(this.subject));
                ps.format("\"%s\";", this.filterHyphenForCsv(this.messageID));
                ps.format("\"%s\";", this.filterHyphenForCsv(this.attachmentsNamesList()));
                if (this.replyTo == null || this.replyTo.isEmpty()) {
                    ps.format("\"\";", new Object[0]);
                } else {
                    p = new MetadataPerson(this.replyTo.get(0));
                    ps.format("\"%s\";", this.filterHyphenForCsv(p.identifier));
                }
                ps.format("\"%s\";", this.filterHyphenForCsv(this.storeFolder.getFullName()));
                ps.format("\"%d\";", this.getMessageSize());
                if (!this.storeFolder.getStoreExtractor().isRoot()) {
                    ps.format("\"Attached\"", new Object[0]);
                }
                ps.println();
                ps.flush();
            }
            catch (Exception e) {
                this.logMessageWarning("mailextractlib: can't write in mails csv list", e);
            }
        }
    }

    private String personStringListToIndentifierString(List<String> sList) {
        Object result = "";
        boolean first = true;
        if (sList != null) {
            for (String s : sList) {
                if (first) {
                    first = false;
                } else {
                    result = (String)result + ", ";
                }
                MetadataPerson p = new MetadataPerson(s);
                result = (String)result + p.identifier;
            }
        }
        return result;
    }

    private String attachmentsNamesList() {
        Object result = "";
        boolean first = true;
        if (this.attachments != null) {
            for (StoreAttachment a : this.attachments) {
                if (first) {
                    first = false;
                } else {
                    result = (String)result + ", ";
                }
                result = (String)result + a.getName();
            }
        }
        return result;
    }

    public void countMessage() throws MailExtractLibException, InterruptedException {
        this.storeFolder.incFolderElementsCount();
        this.storeFolder.addFolderElementsRawSize(this.getMessageSize());
    }

    public MimeMessage getMimeFake() throws InterruptedException {
        NoUpdateMimeMessage mime = new NoUpdateMimeMessage(Session.getDefaultInstance(new Properties()));
        try {
            this.buildMimeHeader(mime);
            this.buildMimePart(mime);
            mime.saveChanges();
        }
        catch (MailExtractLibException | MessagingException e) {
            this.logMessageWarning("mailextractlib: unable to generate mime fake", e);
            mime = null;
        }
        return mime;
    }

    private static void setAddressList(MimeMessage mime, String tag, List<String> addressList) throws MessagingException, UnsupportedEncodingException {
        if (addressList != null && !addressList.isEmpty()) {
            Object value = "";
            int countline = 0;
            for (String tmp : addressList) {
                if (countline + (tmp = MimeUtility.encodeText(tmp, "UTF-8", "Q")).length() > 80) {
                    value = (String)value + "\n\t";
                    countline = 1;
                } else {
                    countline += tmp.length();
                }
                value = (String)value + MimeUtility.encodeText(tmp, "UTF-8", "Q") + ",";
            }
            value = ((String)value).substring(0, ((String)value).length() - 1);
            mime.setHeader(tag, (String)value);
        }
    }

    private void buildMimeHeader(MimeMessage mime) throws MailExtractLibException {
        try {
            if (this.mailHeader != null && this.mailHeader.size() > 0) {
                for (String tmp : this.mailHeader) {
                    if (tmp.indexOf(58) < 0) continue;
                    String tag = tmp.substring(0, tmp.indexOf(58));
                    String value = tmp.substring(tmp.indexOf(58) + 1);
                    mime.setHeader(tag, value);
                }
            }
            if (this.returnPath != null) {
                mime.setHeader("Return-Path", MimeUtility.encodeText(this.returnPath, "UTF-8", "Q"));
            }
            if (this.from != null) {
                mime.setHeader("From", MimeUtility.encodeText(this.from, "UTF-8", "Q"));
            }
            if (this.recipientTo != null) {
                StoreMessage.setAddressList(mime, "To", this.recipientTo);
            }
            if (this.recipientCc != null) {
                StoreMessage.setAddressList(mime, "cc", this.recipientCc);
            }
            if (this.recipientBcc != null) {
                StoreMessage.setAddressList(mime, "bcc", this.recipientBcc);
            }
            if (this.replyTo != null) {
                StoreMessage.setAddressList(mime, "Reply-To", this.replyTo);
            }
            mime.setSentDate(this.sentDate);
            if (this.subject != null) {
                mime.setSubject(MimeUtility.encodeText(this.subject, "UTF-8", "Q"));
            }
            if (this.messageID != null) {
                mime.setHeader("Message-ID", MimeUtility.encodeText(this.messageID, "UTF-8", "Q"));
            }
            if (this.inReplyToUID != null && !this.inReplyToUID.isEmpty()) {
                mime.setHeader("In-Reply-To", MimeUtility.encodeText(this.inReplyToUID, "UTF-8", "Q"));
            }
        }
        catch (MessagingException | UnsupportedEncodingException e) {
            throw new MailExtractLibException("Unable to generate mime header of message " + this.subject, e);
        }
    }

    private void addAttachmentPart(MimeMultipart root, boolean isInline) throws MailExtractLibException {
        try {
            for (StoreAttachment a : this.attachments) {
                String cidName;
                boolean thisIsInline;
                boolean bl = thisIsInline = a.attachmentType == 1;
                if ((!thisIsInline || !isInline) && (thisIsInline || isInline)) continue;
                MimeBodyPart attachPart = new MimeBodyPart();
                if (a.contentID != null && !a.contentID.trim().isEmpty()) {
                    attachPart.setContentID("<" + a.contentID.trim() + ">");
                    cidName = a.contentID.indexOf(64) < 0 ? a.contentID : a.contentID.substring(0, a.contentID.indexOf(64));
                } else {
                    cidName = "unknown";
                }
                String attachmentFilename = this.encodedFilename(a.name, a.mimeType, cidName);
                if (a.mimeType == null || a.mimeType.isEmpty()) {
                    attachPart.setContent(a.getRawAttachmentContent(), "application/octet-stream; name=\"" + attachmentFilename + "\"");
                } else if (a.mimeType.startsWith("text")) {
                    String s = new String(a.getRawAttachmentContent(), "UTF-8");
                    attachPart.setContent(s, a.mimeType + "; name=\"" + attachmentFilename + "\"");
                } else if (a.mimeType.startsWith("message")) {
                    RawDataSource rds = new RawDataSource(a.getRawAttachmentContent(), a.mimeType, attachmentFilename);
                    DataHandler dh = new DataHandler(rds);
                    attachPart.setDataHandler(dh);
                } else if (a.mimeType.startsWith("multipart")) {
                    attachPart.setContent(a.getRawAttachmentContent(), "application/octet-stream; name=\"" + attachmentFilename + "\"");
                } else {
                    attachPart.setContent(a.getRawAttachmentContent(), a.mimeType + "; name=\"" + attachmentFilename + "\"");
                }
                if (a.attachmentType == 1) {
                    attachPart.setDisposition("inline; filename=\"" + attachmentFilename + "\"");
                } else {
                    attachPart.setDisposition("attachment; filename=\"" + attachmentFilename + "\"");
                }
                root.addBodyPart(attachPart);
            }
        }
        catch (MessagingException | UnsupportedEncodingException e) {
            throw new MailExtractLibException("Unable to generate " + (isInline ? "inlines" : "attachments") + " of message " + this.subject, e);
        }
    }

    private MimeMultipart newChild(MimeMultipart parent, String type) throws MessagingException {
        MimeMultipart child = new MimeMultipart(type);
        MimeBodyPart mbp = new MimeBodyPart();
        parent.addBodyPart(mbp);
        mbp.setContent(child);
        return child;
    }

    private boolean isEmptyBodies() {
        if (this.bodyContent[0] != null && !this.bodyContent[0].isEmpty()) {
            return false;
        }
        if (this.bodyContent[1] != null && !this.bodyContent[1].isEmpty()) {
            return false;
        }
        return this.bodyContent[2] == null || this.bodyContent[2].isEmpty();
    }

    private void buildMimePart(MimeMessage mime) throws MailExtractLibException {
        boolean hasInline = false;
        int relatedPart = 3;
        MimeMultipart rootMp = new MimeMultipart("mixed");
        try {
            MimeBodyPart part;
            MimeMultipart upperpart;
            MimeBodyPart part2;
            for (StoreAttachment a : this.attachments) {
                if (a.attachmentType != 1) continue;
                hasInline = true;
                break;
            }
            if (this.bodyContent[1] != null && !this.bodyContent[1].isEmpty()) {
                relatedPart = 1;
            } else if (this.bodyContent[2] != null && !this.bodyContent[2].isEmpty()) {
                relatedPart = 2;
            }
            MimeMultipart msgMp = this.newChild(rootMp, "alternative");
            if (this.bodyContent[0] != null && !this.bodyContent[0].isEmpty()) {
                part2 = new MimeBodyPart();
                part2.setContent(this.bodyContent[0], "text/plain; charset=utf-8");
                msgMp.addBodyPart(part2);
            }
            if (this.isEmptyBodies()) {
                part2 = new MimeBodyPart();
                part2.setContent(" ", "text/plain; charset=utf-8");
                msgMp.addBodyPart(part2);
            }
            if (this.bodyContent[1] != null && !this.bodyContent[1].isEmpty()) {
                upperpart = hasInline && relatedPart == 1 ? this.newChild(msgMp, "related") : msgMp;
                part = new MimeBodyPart();
                part.setContent(this.bodyContent[1], "text/html; charset=utf-8");
                upperpart.addBodyPart(part);
                if (hasInline && relatedPart == 1) {
                    this.addAttachmentPart(upperpart, true);
                }
            }
            if (this.bodyContent[2] != null && !this.bodyContent[2].isEmpty()) {
                upperpart = hasInline && relatedPart == 2 ? this.newChild(msgMp, "related") : msgMp;
                part = new MimeBodyPart();
                part.setContent(this.bodyContent[2], "text/rtf; charset=US-ASCII");
                upperpart.addBodyPart(part);
                if (hasInline && relatedPart == 2) {
                    this.addAttachmentPart(upperpart, true);
                }
            }
        }
        catch (MessagingException e) {
            throw new MailExtractLibException("Unable to generate mime body part of message " + this.subject, e);
        }
        if (relatedPart == 3) {
            this.addAttachmentPart(rootMp, true);
        }
        this.addAttachmentPart(rootMp, false);
        try {
            mime.setContent(rootMp);
        }
        catch (MessagingException e) {
            throw new MailExtractLibException("Unable to generate mime fake of message " + this.subject, e);
        }
    }

    private static boolean isPureAscii(String v) {
        return StandardCharsets.US_ASCII.newEncoder().canEncode(v);
    }

    private String encodedFilename(String filename, String mimetype, String ifnone) {
        Object tmp = filename != null && !filename.trim().isEmpty() ? filename : ifnone;
        if ("message/rfc822".equals(mimetype) && !((String)tmp).endsWith(".eml")) {
            tmp = (String)tmp + ".eml";
        }
        if (StoreMessage.isPureAscii((String)tmp) && ((String)tmp).contains("\"")) {
            tmp = ((String)tmp).replaceAll("\"", "'");
        }
        try {
            return MimeUtility.encodeWord((String)tmp, "UTF-8", "Q");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "Unknown";
        }
    }

    private class NoUpdateMimeMessage
    extends MimeMessage {
        public NoUpdateMimeMessage(Session session) {
            super(session);
        }

        @Override
        protected void updateMessageID() throws MessagingException {
            String[] ids = this.getHeader("Message-ID");
            if (ids == null || ids.length == 0 || ids[0] == null || ids[0].isEmpty()) {
                super.updateMessageID();
            }
        }

        @Override
        protected synchronized void updateHeaders() throws MessagingException {
            String[] date = this.getHeader("Date");
            super.updateHeaders();
            if (date == null) {
                this.removeHeader("Date");
            }
        }
    }
}

