/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.core;

import fr.gouv.vitam.tools.mailextractlib.core.StoreExtractor;
import fr.gouv.vitam.tools.mailextractlib.nodes.ArchiveUnit;
import fr.gouv.vitam.tools.mailextractlib.utils.DateRange;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractLibException;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractProgressLogger;
import java.nio.file.FileSystems;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class StoreFolder {
    protected StoreExtractor storeExtractor;
    protected ArchiveUnit folderArchiveUnit;
    private final DateRange dateRange;
    private final AtomicInteger folderElementsCount;
    private final AtomicInteger folderSubFoldersCount;
    private final AtomicLong folderElementsRawSize;

    protected StoreFolder(StoreExtractor storeExtractor) {
        this.storeExtractor = storeExtractor;
        this.folderArchiveUnit = null;
        this.dateRange = new DateRange();
        this.folderElementsCount = new AtomicInteger(0);
        this.folderSubFoldersCount = new AtomicInteger(0);
        this.folderElementsRawSize = new AtomicLong(0L);
    }

    public static String getElementName() {
        return "folders";
    }

    protected void finalizeStoreFolder(StoreFolder father) {
        this.folderArchiveUnit = new ArchiveUnit(this.storeExtractor, father.folderArchiveUnit, "Folder", this.getName());
    }

    public MailExtractProgressLogger getProgressLogger() {
        return this.storeExtractor.getProgressLogger();
    }

    private void logFolder(String msg) throws InterruptedException {
        if (this.storeExtractor.isRoot()) {
            MailExtractProgressLogger.doProgressLog(this.storeExtractor.getProgressLogger(), 30, msg, null);
        } else {
            MailExtractProgressLogger.doProgressLog(this.storeExtractor.getProgressLogger(), 60, msg, null);
        }
    }

    public StoreExtractor getStoreExtractor() {
        return this.storeExtractor;
    }

    public synchronized void extendDateRange(DateRange extraDateRange) {
        this.dateRange.extendRange(extraDateRange);
    }

    public synchronized void extendDateRange(Date extraDate) {
        this.dateRange.extendRange(extraDate);
    }

    public synchronized DateRange getDateRange() {
        return this.dateRange;
    }

    public ArchiveUnit getArchiveUnit() {
        return this.folderArchiveUnit;
    }

    public abstract String getFullName();

    public abstract String getName();

    public void incFolderElementsCount() {
        this.folderElementsCount.incrementAndGet();
    }

    public int getFolderElementsCount() {
        return this.folderElementsCount.get();
    }

    public void incFolderSubFoldersCount() {
        this.folderSubFoldersCount.incrementAndGet();
    }

    public int getFolderSubFoldersCount() {
        return this.folderSubFoldersCount.get();
    }

    public void addFolderElementsRawSize(long rawSize) {
        this.folderElementsRawSize.addAndGet(rawSize);
    }

    public long getFolderElementsRawSize() {
        return this.folderElementsRawSize.get();
    }

    public abstract boolean hasElements() throws MailExtractLibException;

    public abstract boolean hasSubfolders() throws MailExtractLibException;

    public void extractFolderAsRoot(boolean writeFlag) throws MailExtractLibException, InterruptedException {
        this.logFolder("mailextractlib: extract folder " + FileSystems.getDefault().getSeparator());
        this.extractFolderElements(writeFlag);
        this.extractSubFolders(0, writeFlag);
        if (this.folderElementsCount.get() + this.folderSubFoldersCount.get() != 0) {
            if (StoreExtractor.schemeContainerMap.get(this.storeExtractor.scheme).booleanValue()) {
                this.storeExtractor.incElementCounter(this.getClass());
            }
            this.storeExtractor.addTotalRawSize(this.getFolderElementsRawSize());
        } else {
            this.logFolder("mailextractlib: empty extraction");
        }
    }

    public boolean extractFolder(int level, boolean writeFlag) throws MailExtractLibException, InterruptedException {
        boolean result = false;
        this.logFolder("mailextractlib: extract folder " + FileSystems.getDefault().getSeparator() + this.getFullName());
        this.extractFolderElements(writeFlag);
        this.extractSubFolders(level, writeFlag);
        if (this.folderElementsCount.get() + this.folderSubFoldersCount.get() != 0 || !this.storeExtractor.options.dropEmptyFolders && (level != 1 || !this.storeExtractor.options.keepOnlyDeepEmptyFolders)) {
            this.folderArchiveUnit.addMetadata("DescriptionLevel", "RecordGrp", true);
            this.folderArchiveUnit.addMetadata("Title", this.getName(), true);
            if (this.dateRange.isDefined()) {
                this.folderArchiveUnit.addMetadata("StartDate", DateRange.getISODateString(this.dateRange.getStart()), true);
                this.folderArchiveUnit.addMetadata("EndDate", DateRange.getISODateString(this.dateRange.getEnd()), true);
            }
            if (writeFlag) {
                this.folderArchiveUnit.write();
            }
            result = true;
            this.storeExtractor.incElementCounter(this.getClass());
            this.storeExtractor.addTotalRawSize(this.getFolderElementsRawSize());
        } else {
            this.logFolder("mailextractlib: empty folder " + FileSystems.getDefault().getSeparator() + this.getFullName() + " is droped");
        }
        return result;
    }

    private void extractFolderElements(boolean writeFlag) throws MailExtractLibException, InterruptedException {
        this.folderElementsCount.set(0);
        this.folderElementsRawSize.set(0L);
        if (this.hasElements()) {
            this.doExtractFolderElements(writeFlag);
        }
    }

    protected abstract void doExtractFolderElements(boolean var1) throws MailExtractLibException, InterruptedException;

    private void extractSubFolders(int level, boolean writeFlag) throws MailExtractLibException, InterruptedException {
        this.folderSubFoldersCount.set(0);
        if (this.hasSubfolders()) {
            this.doExtractSubFolders(level, writeFlag);
        }
    }

    protected abstract void doExtractSubFolders(int var1, boolean var2) throws MailExtractLibException, InterruptedException;

    public void listFolder(boolean stats) throws MailExtractLibException, InterruptedException {
        String fullName = this.getFullName();
        if (fullName == null || fullName.isEmpty()) {
            fullName = "";
        }
        if (stats) {
            this.listFolderElements(stats);
            String tmp = String.format("%5d \u00e9l\u00e9ments   %7.2f MBytes    " + FileSystems.getDefault().getSeparator() + "%s", this.folderElementsCount.get(), (double)this.folderElementsRawSize.get() / 1048576.0, fullName);
            MailExtractProgressLogger.doProgressLog(this.storeExtractor.getProgressLogger(), 10, tmp, null);
        } else {
            MailExtractProgressLogger.doProgressLog(this.storeExtractor.getProgressLogger(), 10, FileSystems.getDefault().getSeparator() + fullName, null);
        }
        this.listSubFolders(stats);
        this.storeExtractor.incElementCounter(this.getClass());
        if (stats) {
            this.storeExtractor.addTotalRawSize(this.getFolderElementsRawSize());
        }
    }

    private void listFolderElements(boolean stats) throws MailExtractLibException, InterruptedException {
        this.folderElementsCount.set(0);
        this.folderElementsRawSize.set(0L);
        if (this.hasElements()) {
            this.doListFolderElements(stats);
        }
    }

    protected abstract void doListFolderElements(boolean var1) throws MailExtractLibException, InterruptedException;

    private void listSubFolders(boolean stats) throws MailExtractLibException, InterruptedException {
        this.folderSubFoldersCount.set(0);
        if (this.hasSubfolders()) {
            this.doListSubFolders(stats);
        }
    }

    protected abstract void doListSubFolders(boolean var1) throws MailExtractLibException, InterruptedException;
}

