/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.core;

import fr.gouv.vitam.tools.mailextractlib.core.StoreAppointment;
import fr.gouv.vitam.tools.mailextractlib.core.StoreAttachment;
import fr.gouv.vitam.tools.mailextractlib.core.StoreContact;
import fr.gouv.vitam.tools.mailextractlib.core.StoreElement;
import fr.gouv.vitam.tools.mailextractlib.core.StoreExtractorOptions;
import fr.gouv.vitam.tools.mailextractlib.core.StoreFolder;
import fr.gouv.vitam.tools.mailextractlib.core.StoreMessage;
import fr.gouv.vitam.tools.mailextractlib.nodes.ArchiveUnit;
import fr.gouv.vitam.tools.mailextractlib.store.javamail.JMStoreExtractor;
import fr.gouv.vitam.tools.mailextractlib.store.microsoft.msg.MsgStoreExtractor;
import fr.gouv.vitam.tools.mailextractlib.store.microsoft.pst.PstStoreExtractor;
import fr.gouv.vitam.tools.mailextractlib.store.microsoft.pst.embeddedmsg.PstEmbeddedStoreExtractor;
import fr.gouv.vitam.tools.mailextractlib.utils.DateRange;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractLibException;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractProgressLogger;
import jakarta.mail.URLName;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.poi.util.IOUtils;

public abstract class StoreExtractor {
    public static final DateTimeFormatter ISO_8601 = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).optionalStart().appendOffsetId().optionalStart().toFormatter();
    static HashMap<String, String> mimeTypeSchemeMap = new HashMap();
    static HashMap<String, String> droidFormatSchemeMap = new HashMap();
    static HashMap<String, Class> schemeStoreExtractorClassMap = new HashMap();
    static HashMap<String, Boolean> schemeContainerMap = new HashMap();
    protected final String scheme;
    protected final String host;
    protected final int port;
    protected final String user;
    protected final String password;
    protected final String path;
    protected final String rootStoreFolderName;
    protected final String destRootPath;
    protected final String destName;
    protected final StoreExtractorOptions options;
    protected String description;
    private final AtomicLong totalRawSize;
    private Instant start;
    private Instant end;
    private StoreFolder rootStoreFolder;
    private final StoreExtractor fatherStoreExtractor;
    private final StoreExtractor rootStoreExtractor;
    private final StoreElement fatherElement;
    private MailExtractProgressLogger logger;
    protected Map<String, PrintStream> globalListsPSMap;
    static Class[] accumulatedElements = new Class[]{StoreFolder.class, StoreMessage.class, StoreAppointment.class, StoreContact.class};
    private Map<String, Integer> elementsCounterMap;
    private Map<String, Integer> subElementsCounterMap;
    private AtomicInteger uniqID;
    private static final double THREAD_MULTIPLIER = Double.parseDouble(System.getProperty("thread.factor", "1.5"));
    private int maxParallelThreads = (int)Math.round((double)Runtime.getRuntime().availableProcessors() * THREAD_MULTIPLIER);

    public static void initDefaultExtractors(boolean allowsExternalToolsForTextExtraction) {
        if (!allowsExternalToolsForTextExtraction) {
            StoreExtractor.preventExternalToolsForTextExtractionInTika();
        }
        JMStoreExtractor.subscribeStoreExtractor();
        MsgStoreExtractor.subscribeStoreExtractor();
        PstStoreExtractor.subscribeStoreExtractor();
        PstEmbeddedStoreExtractor.subscribeStoreExtractor();
        IOUtils.setByteArrayMaxOverride(Integer.MAX_VALUE);
        System.setProperty("mail.mime.ignoreunknownencoding", "true");
        System.setProperty("mail.mime.decodetext.strict", "false");
        System.setProperty("mail.mime.base64.ignoreerrors", "true");
    }

    private static void preventExternalToolsForTextExtractionInTika() {
        URL url = StoreExtractor.class.getClassLoader().getResource("tika-without-externals.config");
        try {
            System.setProperty("tika.config", Objects.requireNonNull(url).toURI().toString());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static void addExtractionRelation(String mimeType, String droidFormat, String scheme, boolean isContainer, Class extractor) {
        if (mimeType != null) {
            mimeTypeSchemeMap.put(mimeType, scheme);
        }
        if (droidFormat != null) {
            droidFormatSchemeMap.put(droidFormat, scheme);
        }
        schemeStoreExtractorClassMap.put(scheme, extractor);
        schemeContainerMap.put(scheme, isContainer);
    }

    public static String getProtocolFromDroidFormat(String droidFormat) {
        return droidFormatSchemeMap.get(droidFormat);
    }

    public static String composeStoreURL(String scheme, String authority, String user, String password, String path) {
        String result = null;
        try {
            result = scheme + "://";
            if (user != null && !user.isEmpty()) {
                result = result + URLEncoder.encode(user, "UTF-8");
                if (password != null && !password.isEmpty()) {
                    result = result + ":" + URLEncoder.encode(password, "UTF-8");
                }
                result = result + "@";
            }
            result = authority != null && !authority.isEmpty() ? result + authority : result + "localhost";
            if (path != null && !path.isEmpty()) {
                result = result + "/" + URLEncoder.encode(path, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return result;
    }

    public synchronized PrintStream getGlobalListPS(Class listClass) {
        String globalListName = null;
        PrintStream result = null;
        try {
            globalListName = (String)listClass.getMethod("getElementName", new Class[0]).invoke(null, new Object[0]);
            result = this.globalListsPSMap.get(globalListName);
            if (result == null) {
                String dirname = this.destRootPath + File.separator + this.destName + File.separator;
                Files.createDirectories(Paths.get(dirname, new String[0]), new FileAttribute[0]);
                result = new PrintStream(dirname + listClass.getMethod("getElementName", new Class[0]).invoke(null, new Object[0]) + ".csv");
                this.globalListsPSMap.put(globalListName, result);
                listClass.getMethod("printGlobalListCSVHeader", PrintStream.class).invoke(null, result);
            }
        }
        catch (IOException | IllegalAccessException | NoSuchMethodException e) {
            MailExtractProgressLogger.doProgressLogWithoutInterruption(this.logger, 10, "mailextractlib: can't create global list for [" + globalListName + "] csv file", e);
        }
        catch (InvocationTargetException te) {
            MailExtractProgressLogger.doProgressLogWithoutInterruption(this.logger, 10, "mailextractlib: can't create global list for [" + globalListName + "] csv file", te.getTargetException());
        }
        return result;
    }

    public synchronized int getElementCounter(Class listClass, boolean subFlag) {
        String elementName = null;
        Integer result = 0;
        try {
            elementName = (String)listClass.getMethod("getElementName", new Class[0]).invoke(null, new Object[0]);
            result = (subFlag ? this.subElementsCounterMap : this.elementsCounterMap).get(elementName);
            if (result == null) {
                (subFlag ? this.subElementsCounterMap : this.elementsCounterMap).put(elementName, 0);
                result = 0;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            MailExtractProgressLogger.doProgressLogWithoutInterruption(this.logger, 10, "mailextractlib: can't create counter for " + (subFlag ? "sub " : "") + "[" + elementName + "] csv file", e);
        }
        catch (InvocationTargetException te) {
            MailExtractProgressLogger.doProgressLogWithoutInterruption(this.logger, 10, "mailextractlib: can't create counter for " + (subFlag ? "sub " : "") + "[" + elementName + "] csv file", te.getTargetException());
        }
        return result;
    }

    public synchronized int addElementCounter(int value, Class listClass, boolean subFlag) {
        String elementName = null;
        Integer result = 0;
        try {
            elementName = (String)listClass.getMethod("getElementName", new Class[0]).invoke(null, new Object[0]);
            result = (subFlag ? this.subElementsCounterMap : this.elementsCounterMap).get(elementName);
            result = result == null ? Integer.valueOf(value) : Integer.valueOf(result + value);
            (subFlag ? this.subElementsCounterMap : this.elementsCounterMap).put(elementName, result);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            MailExtractProgressLogger.doProgressLogWithoutInterruption(this.logger, 10, "mailextractlib: can't create counter for " + (subFlag ? "sub " : "") + "[" + elementName + "] csv file", e);
        }
        catch (InvocationTargetException te) {
            MailExtractProgressLogger.doProgressLogWithoutInterruption(this.logger, 10, "mailextractlib: can't create counter for " + (subFlag ? "sub " : "") + "[" + elementName + "] csv file", te.getTargetException());
        }
        return result;
    }

    public int incElementCounter(Class listClass) {
        return this.addElementCounter(1, listClass, false);
    }

    public synchronized void accumulateSubElements(StoreExtractor subExtractor) {
        for (Class c : accumulatedElements) {
            int value = subExtractor.getElementCounter(c, false) + subExtractor.getElementCounter(c, true);
            if (value <= 0) continue;
            this.addElementCounter(value, c, true);
        }
    }

    protected void closeGlobalListsPSMap() {
        for (String psName : this.globalListsPSMap.keySet()) {
            this.globalListsPSMap.get(psName).close();
        }
    }

    protected StoreExtractor(String urlString, String rootStoreFolderName, String destPathString, StoreExtractorOptions options, StoreExtractor fatherStoreExtractor, StoreElement fatherElement, MailExtractProgressLogger logger) throws MailExtractLibException {
        URLName url = new URLName(urlString);
        this.scheme = url.getProtocol();
        this.host = url.getHost();
        this.port = url.getPort();
        String tempUser = null;
        String tempPassword = null;
        String tempPath = null;
        try {
            if (url.getUsername() != null) {
                tempUser = URLDecoder.decode(url.getUsername(), "UTF-8");
            }
            if (url.getPassword() != null) {
                tempPassword = URLDecoder.decode(url.getPassword(), "UTF-8");
            }
            if (url.getFile() != null) {
                tempPath = URLDecoder.decode(url.getFile(), "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.user = tempUser;
        this.password = tempPassword;
        this.path = tempPath;
        this.rootStoreFolderName = rootStoreFolderName;
        this.destRootPath = Paths.get(destPathString, new String[0]).toAbsolutePath().normalize().getParent().toString();
        this.destName = Paths.get(destPathString, new String[0]).toAbsolutePath().normalize().getFileName().toString();
        this.options = options == null ? new StoreExtractorOptions() : options;
        this.totalRawSize = new AtomicLong(0L);
        this.fatherStoreExtractor = fatherStoreExtractor;
        this.fatherElement = fatherElement;
        this.rootStoreExtractor = fatherStoreExtractor == null ? this : fatherStoreExtractor.rootStoreExtractor;
        this.logger = logger;
        this.description = ":p:" + this.scheme + ":u:" + this.user;
        this.globalListsPSMap = new ConcurrentHashMap<String, PrintStream>();
        this.elementsCounterMap = new ConcurrentHashMap<String, Integer>();
        this.subElementsCounterMap = new ConcurrentHashMap<String, Integer>();
        this.uniqID = new AtomicInteger(0);
        MailExtractProgressLogger.doProgressLogIfDebug(logger, "StoreExtractor [" + this + "] created with url=" + urlString + " rootFolder=" + rootStoreFolderName + " destPath=" + destPathString + " rootExtractor=" + fatherStoreExtractor, null);
    }

    public void writeTargetLog() throws InterruptedException {
        if (this.fatherStoreExtractor == null) {
            MailExtractProgressLogger.doProgressLog(this.logger, 10, "mailextract :target store with scheme=" + this.scheme + (String)(this.host == null || this.host.isEmpty() ? "" : "  server=" + this.host) + (String)(this.port == -1 ? "" : ":" + Integer.toString(this.port)) + (String)(this.user == null || this.user.isEmpty() ? "" : " user=" + this.user) + (String)(this.password == null || this.password.isEmpty() ? "" : " password=" + this.password) + (String)(this.path == null || this.path.isEmpty() ? "" : " path=" + this.path) + (String)(this.rootStoreFolderName == null || this.rootStoreFolderName.isEmpty() ? "" : " store folder=" + this.rootStoreFolderName), null);
            MailExtractProgressLogger.doProgressLog(this.logger, 10, "to " + this.destRootPath + " in " + this.destName + " directory", null);
            if (this.logger != null && this.logger.getDebugFlag()) {
                MailExtractProgressLogger.doProgressLog(this.logger, 10, "DEBUG MODE", null);
            }
            boolean first = true;
            Object optionsLog = "";
            if (this.options.keepOnlyDeepEmptyFolders) {
                optionsLog = (String)optionsLog + "keeping all empty folders except root level ones";
                first = false;
            }
            if (this.options.dropEmptyFolders) {
                if (!first) {
                    optionsLog = (String)optionsLog + ", ";
                }
                optionsLog = (String)optionsLog + "droping all empty folders";
                first = false;
            }
            if (this.options.warningMsgProblem) {
                if (!first) {
                    optionsLog = (String)optionsLog + ", ";
                }
                optionsLog = (String)optionsLog + "generate warning when there's a problem on a message (otherwise log at FINEST level)";
                first = false;
            }
            if (!first) {
                optionsLog = (String)optionsLog + ", ";
            }
            optionsLog = (String)optionsLog + "with names length=" + Integer.toString(this.options.namesLength);
            optionsLog = (String)optionsLog + ", ";
            optionsLog = (String)optionsLog + "with log level " + this.getProgressLogger().getLevelName();
            MailExtractProgressLogger.doProgressLog(this.logger, 10, (String)optionsLog, null);
        }
    }

    public MailExtractProgressLogger getProgressLogger() {
        return this.logger;
    }

    public boolean hasDestName() {
        return this.destName != null && !this.destName.isEmpty();
    }

    public synchronized int getNewUniqID() {
        int id = this.fatherStoreExtractor == null ? this.uniqID.addAndGet(1) : this.rootStoreExtractor.getNewUniqID();
        return id;
    }

    public void addTotalRawSize(long elementSize) {
        this.totalRawSize.addAndGet(elementSize);
    }

    public long getTotalRawSize() {
        return this.totalRawSize.get();
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isRoot() {
        return this.fatherStoreExtractor == null;
    }

    public StoreFolder getRootFolder() {
        return this.rootStoreFolder;
    }

    public void setRootFolder(StoreFolder rootFolder) {
        this.rootStoreFolder = rootFolder;
    }

    public StoreExtractorOptions getOptions() {
        return this.options;
    }

    public StoreElement getFatherElement() {
        return this.fatherElement;
    }

    public static StoreExtractor createStoreExtractor(String urlString, String rootStoreFolderName, String destPathString, StoreExtractorOptions options, MailExtractProgressLogger logger) throws MailExtractLibException {
        StoreExtractor storeExtractor = StoreExtractor.createInternalStoreExtractor(urlString, rootStoreFolderName, destPathString, options, null, logger);
        return storeExtractor;
    }

    private static StoreExtractor createInternalStoreExtractor(String urlString, String rootStoreFolderName, String destPathString, StoreExtractorOptions options, StoreExtractor rootStoreExtractor, MailExtractProgressLogger logger) throws MailExtractLibException {
        StoreExtractor store;
        Class storeExtractorClass;
        URLName url = new URLName(urlString);
        if (rootStoreFolderName != null && !rootStoreFolderName.isEmpty() && rootStoreFolderName.substring(0, 1).equals(File.separator)) {
            rootStoreFolderName = rootStoreFolderName.substring(1);
        }
        if ((storeExtractorClass = schemeStoreExtractorClassMap.get(url.getProtocol())) == null) {
            throw new MailExtractLibException("mailextractlib: unknown store type=" + url.getProtocol(), null);
        }
        try {
            store = (StoreExtractor)storeExtractorClass.getConstructor(String.class, String.class, String.class, StoreExtractorOptions.class, StoreExtractor.class, MailExtractProgressLogger.class).newInstance(urlString, rootStoreFolderName, destPathString, options, rootStoreExtractor, logger);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException e) {
            throw new MailExtractLibException("mailextractlib: dysfonctional store type=" + url.getProtocol(), e);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getCause();
            throw new MailExtractLibException("mailextractlib: dysfonctional store type=" + url.getProtocol(), te);
        }
        return store;
    }

    private static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public String getSummary() {
        Object summary = Duration.between(this.start, this.end).toString();
        Object elementSummary = "";
        for (Class elementClass : accumulatedElements) {
            String elementName = null;
            try {
                elementName = (String)elementClass.getMethod("getElementName", new Class[0]).invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                MailExtractProgressLogger.doProgressLogIfDebug(this.logger, "GetSummary error", e);
            }
            Integer count = this.elementsCounterMap.get(elementName);
            if (count == null || count <= 0) continue;
            if (!((String)elementSummary).isEmpty()) {
                elementSummary = (String)elementSummary + ",";
            }
            elementSummary = (String)elementSummary + " " + count + " " + elementName;
        }
        summary = ((String)elementSummary).isEmpty() ? (String)summary + " empty extraction" : (String)summary + " writing" + (String)elementSummary;
        Object subElementSummary = "";
        for (Class elementClass : accumulatedElements) {
            String elementName = null;
            try {
                elementName = (String)elementClass.getMethod("getElementName", new Class[0]).invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                MailExtractProgressLogger.doProgressLogIfDebug(this.logger, "GetSummary error", e);
            }
            Integer count = this.subElementsCounterMap.get(elementName);
            if (count == null || count <= 0) continue;
            if (!((String)subElementSummary).isEmpty()) {
                subElementSummary = (String)subElementSummary + ",";
            }
            subElementSummary = (String)subElementSummary + " " + count + " " + elementName;
        }
        summary = ((String)subElementSummary).isEmpty() ? (String)summary + " without embedded elements" : (String)summary + " with" + (String)subElementSummary + " embedded";
        summary = (String)summary + " for a total size of " + StoreExtractor.readableFileSize(this.getTotalRawSize());
        return summary;
    }

    public void extractAllFolders() throws MailExtractLibException, InterruptedException {
        this.start = Instant.now();
        this.writeTargetLog();
        MailExtractProgressLogger.doProgressLog(this.logger, 10, "mailextractlib: extraction begin", null);
        this.rootStoreFolder.extractFolderAsRoot(true);
        ArchiveUnit rootNode = this.rootStoreFolder.getArchiveUnit();
        rootNode.addMetadata("DescriptionLevel", "RecordGrp", true);
        Object title = this.user != null && !this.user.isEmpty() ? "Ensemble des messages \u00e9lectroniques et informations associ\u00e9es (contacts, rendez-vous...) envoy\u00e9s et re\u00e7us par le compte " + this.user : (this.path != null && !this.path.isEmpty() ? "Ensemble des messages \u00e9lectroniques et informations associ\u00e9es (contacts, rendez-vous...) du container " + this.path : "Ensemble de messages \u00e9lectroniques et informations associ\u00e9es (contacts, rendez-vous...)");
        if (this.host != null && !this.host.isEmpty() && !this.host.equals("localhost")) {
            title = (String)title + " sur le serveur " + this.host + (String)(this.port == -1 ? "" : ":" + Integer.toString(this.port));
        }
        title = (String)title + " \u00e0 la date du " + this.start;
        rootNode.addMetadata("Title", (String)title, true);
        if (this.rootStoreFolder.getDateRange().isDefined()) {
            rootNode.addMetadata("StartDate", DateRange.getISODateString(this.rootStoreFolder.getDateRange().getStart()), true);
            rootNode.addMetadata("EndDate", DateRange.getISODateString(this.rootStoreFolder.getDateRange().getEnd()), true);
        }
        rootNode.write();
        this.end = Instant.now();
        String summary = "Terminated in " + this.getSummary();
        MailExtractProgressLogger.doProgressLog(this.logger, 10, "mailextractlib: " + summary, null);
        System.out.println(summary);
    }

    public void listAllFolders(boolean stats) throws MailExtractLibException, InterruptedException {
        this.start = Instant.now();
        int memProgressLogLevel = this.logger.getProgressLogLevel();
        this.logger.setProgressLogLevel(10);
        this.writeTargetLog();
        MailExtractProgressLogger.doProgressLog(this.logger, 10, "mailextractlib: listing begin", null);
        this.rootStoreFolder.listFolder(stats);
        this.end = Instant.now();
        String summary = "Terminated in " + this.getSummary();
        MailExtractProgressLogger.doProgressLog(this.logger, 10, "mailextractlib: " + summary, null);
        System.out.println(summary);
        this.logger.setProgressLogLevel(memProgressLogLevel);
    }

    public void endStoreExtractor() throws MailExtractLibException {
        this.closeGlobalListsPSMap();
    }

    public static boolean hasMagicNumber(byte[] content, byte[] magicNumber) {
        return StoreExtractor.hasMagicNumber(content, magicNumber, 0);
    }

    public static boolean hasMagicNumber(byte[] content, byte[] magicNumber, int offset) {
        if (content.length < magicNumber.length + offset) {
            return false;
        }
        for (int i = 0; i < magicNumber.length; ++i) {
            if (content[i + offset] == magicNumber[i]) continue;
            return false;
        }
        return true;
    }

    public abstract StoreAttachment getAttachment();

    public abstract boolean canExtractObjectsLists();

    public static String getVerifiedScheme(byte[] content) {
        return null;
    }

    public int getMaxParallelThreads() {
        return this.maxParallelThreads;
    }

    public void setMaxParallelThreads(int maxParallelThreads) {
        this.maxParallelThreads = maxParallelThreads;
    }

    public StoreExtractor getRootStoreExtractor() {
        return this.rootStoreExtractor;
    }
}

