/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.core;

import fr.gouv.vitam.tools.mailextractlib.core.StoreExtractor;
import fr.gouv.vitam.tools.mailextractlib.core.StoreFolder;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractLibException;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractProgressLogger;

public abstract class StoreElement {
    protected int listLineId;
    protected StoreFolder storeFolder;

    public StoreElement(StoreFolder storeFolder) {
        this.storeFolder = storeFolder;
        this.listLineId = -1;
    }

    public MailExtractProgressLogger getProgressLogger() {
        return this.storeFolder.getProgressLogger();
    }

    public StoreExtractor getStoreExtractor() {
        return this.storeFolder.getStoreExtractor();
    }

    public void logMessageWarning(String msg, Throwable t) throws InterruptedException {
        msg = (String)msg + " for " + this.getLogDescription();
        StoreElement fatherElement = this.getStoreExtractor().getFatherElement();
        while (fatherElement != null) {
            msg = (String)msg + " in " + fatherElement.getLogDescription();
            fatherElement = fatherElement.getStoreExtractor().getFatherElement();
        }
        Exception ex = null;
        if (t instanceof Exception) {
            ex = (Exception)t;
        }
        if (this.storeFolder.getStoreExtractor().options.warningMsgProblem) {
            MailExtractProgressLogger.doProgressLog(this.getProgressLogger(), 20, (String)msg, ex);
        } else {
            MailExtractProgressLogger.doProgressLog(this.getProgressLogger(), 60, (String)msg, ex);
        }
    }

    public abstract String getLogDescription();

    public abstract void processElement(boolean var1) throws InterruptedException, MailExtractLibException;

    public abstract void listElement(boolean var1) throws InterruptedException, MailExtractLibException;

    public String filterHyphenForCsv(String s) {
        return s.replace("\"", " ");
    }
}

