/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.core;

import fr.gouv.vitam.tools.mailextractlib.core.StoreElement;
import fr.gouv.vitam.tools.mailextractlib.core.StoreFolder;
import fr.gouv.vitam.tools.mailextractlib.nodes.ArchiveUnit;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractLibException;
import java.io.File;
import java.io.PrintStream;

public abstract class StoreContact
extends StoreElement {
    protected String fullName;
    protected String givenName;
    protected String lastName;
    protected String nickName;
    protected String postalAddress;
    protected String homeAddress;
    protected String homeLocation;
    protected String businessAddress;
    protected String businessLocation;
    protected String companyName;
    protected String departmentName;
    protected String title;
    protected String primaryTelephoneNumber;
    protected String businessTelephoneNumbers;
    protected String homeTelephoneNumbers;
    protected String mobileTelephoneNumbers;
    protected String otherTelephoneNumbers;
    protected String smtpAddress;
    protected String otherMailAddresses;
    protected String assistantName;
    protected String assistantTelephoneNumber;
    protected String personalHomePage;
    protected String businessHomePage;
    protected String customerId;
    protected String miscNotes;
    protected String pictureFileName;
    protected byte[] pictureData;

    protected StoreContact(StoreFolder storeFolder) {
        super(storeFolder);
    }

    @Override
    public String getLogDescription() {
        String result = "contact " + this.listLineId;
        result = this.fullName != null ? result + " [" + this.fullName + "]" : (this.givenName != null || this.lastName != null ? result + " [" + (this.givenName != null ? this.givenName : "NoGivenName") + " " + (this.lastName != null ? this.lastName : "NoLastName") + "]" : result + " [no name]");
        return result;
    }

    public abstract void analyzeAllContactInformations() throws MailExtractLibException, InterruptedException;

    public abstract void analyzeContactPicture() throws MailExtractLibException, InterruptedException;

    public void analyzeContact() throws MailExtractLibException, InterruptedException {
        this.analyzeAllContactInformations();
        try {
            this.analyzeContactPicture();
        }
        catch (MailExtractLibException mailExtractLibException) {
            // empty catch block
        }
    }

    public static String getElementName() {
        return "contacts";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printGlobalListCSVHeader(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            ps.println("ID;Full Name;Given Name;Last Name;Misc Notes;Company;Department;Title;Default Address;SMTP Mail Address;Default Telephone Number;Mobile Telephone Number;Business HomePage;Business Location;Business Telephone Number;Business Address;RefID;Other Mail Addresses;Other Telephone Numbers;Assistant Name;Assistant Telephone Number;Personal HomePage;Home Location;Home Telephone Number;Home Address;Nickname");
        }
    }

    public void extractContact(boolean writeFlag) throws InterruptedException, MailExtractLibException {
        if (writeFlag) {
            if (this.storeFolder.getStoreExtractor().getOptions().extractElementsList) {
                this.writeToContactsList();
            }
            if (this.pictureData != null && this.storeFolder.getStoreExtractor().getOptions().extractElementsContent) {
                this.extractPicture();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToContactsList() {
        PrintStream ps;
        PrintStream printStream = ps = this.storeFolder.getStoreExtractor().getGlobalListPS(this.getClass());
        synchronized (printStream) {
            ps.format("\"%d\";", this.listLineId);
            ps.format("\"%s\";", this.filterHyphenForCsv(this.fullName));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.givenName));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.lastName));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.miscNotes));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.companyName));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.departmentName));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.title));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.postalAddress));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.smtpAddress));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.primaryTelephoneNumber));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.mobileTelephoneNumbers));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.businessHomePage));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.businessLocation));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.businessTelephoneNumbers));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.businessAddress));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.customerId));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.otherMailAddresses));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.otherTelephoneNumbers));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.assistantName));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.assistantTelephoneNumber));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.personalHomePage));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.homeLocation));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.homeTelephoneNumbers));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.homeAddress));
            ps.format("\"%s\"", this.filterHyphenForCsv(this.nickName));
            ps.println("");
            ps.flush();
        }
    }

    private void extractPicture() throws InterruptedException, MailExtractLibException {
        ArchiveUnit attachmentNode = new ArchiveUnit(this.storeFolder.storeExtractor, this.storeFolder.storeExtractor.destRootPath + File.separator + this.storeFolder.storeExtractor.destName + File.separator + "contacts", "ContactPicture#" + this.listLineId);
        attachmentNode.addMetadata("DescriptionLevel", "Item", true);
        attachmentNode.addMetadata("Title", "Contact Picture #" + this.listLineId, true);
        attachmentNode.addMetadata("Description", "Contact picture extracted for " + this.fullName, true);
        attachmentNode.addPersonMetadata("Recipient", this.fullName + (String)(this.smtpAddress.isEmpty() ? "" : "<" + this.smtpAddress + ">"), false);
        attachmentNode.addObject(this.pictureData, this.pictureFileName, "BinaryMaster", 1);
        attachmentNode.write();
    }

    @Override
    public void processElement(boolean writeFlag) throws InterruptedException, MailExtractLibException {
        if (this.storeFolder.getStoreExtractor().getOptions().extractContacts) {
            this.listLineId = this.storeFolder.getStoreExtractor().incElementCounter(this.getClass());
            this.analyzeContact();
            this.extractContact(writeFlag);
        }
    }

    @Override
    public void listElement(boolean statsFlag) throws InterruptedException, MailExtractLibException {
        if (this.storeFolder.getStoreExtractor().getOptions().extractContacts) {
            this.listLineId = this.storeFolder.getStoreExtractor().incElementCounter(this.getClass());
        }
    }
}

