/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.core;

import fr.gouv.vitam.tools.mailextractlib.core.StoreElement;
import fr.gouv.vitam.tools.mailextractlib.core.StoreExtractor;
import fr.gouv.vitam.tools.mailextractlib.core.StoreExtractorOptions;
import fr.gouv.vitam.tools.mailextractlib.formattools.TikaExtractor;
import fr.gouv.vitam.tools.mailextractlib.nodes.ArchiveUnit;
import fr.gouv.vitam.tools.mailextractlib.utils.DateRange;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractLibException;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractProgressLogger;
import jakarta.activation.MimeType;
import jakarta.activation.MimeTypeParseException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;

public class StoreAttachment {
    protected StoreElement fatherElement;
    protected Object attachmentContent;
    protected String attachmentStoreScheme;
    protected String name;
    protected Date creationDate;
    protected Date modificationDate;
    protected String mimeType;
    protected String contentID;
    protected int attachmentType;
    public static final int FILE_ATTACHMENT = 0;
    public static final int INLINE_ATTACHMENT = 1;
    public static final int STORE_ATTACHMENT = 2;

    public StoreAttachment(StoreElement fatherElement, Object storeContent, String attachmentStoreScheme, String name, Date creationDate, Date modificationDate, String mimeType, String contentID, int attachmentType) {
        this.fatherElement = fatherElement;
        this.attachmentContent = storeContent;
        this.attachmentStoreScheme = attachmentStoreScheme;
        this.name = name;
        this.creationDate = creationDate;
        this.modificationDate = modificationDate;
        this.contentID = contentID;
        this.attachmentType = attachmentType;
        this.setMimeType(mimeType);
    }

    public byte[] getRawAttachmentContent() throws MailExtractLibException {
        if (this.attachmentContent instanceof byte[]) {
            return (byte[])this.attachmentContent;
        }
        throw new MailExtractLibException("mailextractlib: this attachment has no binary form", null);
    }

    public String getScheme() {
        return this.attachmentStoreScheme;
    }

    public Object getStoreContent() {
        return this.attachmentContent;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setStoreContent(Object attachmentContent) {
        this.attachmentContent = attachmentContent;
    }

    public void setMimeType(String mimeType) {
        try {
            new MimeType(mimeType);
            this.mimeType = mimeType;
        }
        catch (MimeTypeParseException e) {
            int i = mimeType.lastIndexOf(47);
            this.mimeType = i != -1 && i < mimeType.length() ? "application/" + mimeType.substring(i + 1) : "application/octet-stream";
        }
    }

    public void setStoreScheme(String scheme) {
        this.attachmentStoreScheme = scheme;
        this.attachmentType = 2;
    }

    protected static void detectStoreAttachments(List<StoreAttachment> attachments) {
        if (attachments != null && !attachments.isEmpty()) {
            for (StoreAttachment a : attachments) {
                if (a.attachmentType == 2 || !(a.attachmentContent instanceof byte[]) || a.mimeType.toLowerCase().equals("application/ms-tnef") || a.mimeType.toLowerCase().equals("application/vnd.ms-tnef")) continue;
                try {
                    String mimeType = TikaExtractor.getInstance().getMimeType(a.getRawAttachmentContent());
                    if (mimeType == null) continue;
                    for (String mt : StoreExtractor.mimeTypeSchemeMap.keySet()) {
                        if (!mimeType.equals(mt)) continue;
                        a.setStoreScheme(StoreExtractor.mimeTypeSchemeMap.get(mt));
                    }
                }
                catch (MailExtractLibException mailExtractLibException) {}
            }
        }
    }

    public static void extractAttachments(List<StoreAttachment> attachments, ArchiveUnit messageNode, boolean writeFlag) throws MailExtractLibException, InterruptedException {
        if (attachments != null) {
            for (StoreAttachment a : attachments) {
                if (a.attachmentType == 2) {
                    MailExtractProgressLogger.doProgressLog(a.fatherElement.getProgressLogger(), 60, "mailextractlib: attached message extraction", null);
                    if (a.extractAsStoreAttachment(messageNode, writeFlag)) continue;
                    MailExtractProgressLogger.doProgressLog(a.fatherElement.getProgressLogger(), 60, "mailextractlib: can't extract as an attached message, extract as standard attachment", null);
                }
                a.extractAsFileOrInlineAttachment(messageNode, writeFlag);
            }
        }
    }

    private void extractAsFileOrInlineAttachment(ArchiveUnit node, boolean writeFlag) throws MailExtractLibException, InterruptedException {
        StoreExtractor fatherExtractor = this.fatherElement.getStoreExtractor();
        if (this.name == null || this.name.isEmpty()) {
            this.name = "[Vide]";
        }
        ArchiveUnit attachmentNode = new ArchiveUnit(fatherExtractor, node, "Attachment", this.name);
        attachmentNode.addMetadata("DescriptionLevel", "Item", true);
        attachmentNode.addMetadata("Title", this.name, true);
        attachmentNode.addMetadata("Description", "Document \"" + this.name + " joint", true);
        Date date = null;
        if (this.creationDate != null) {
            date = this.modificationDate != null ? (this.creationDate.compareTo(this.modificationDate) > 0 ? this.creationDate : this.modificationDate) : this.creationDate;
        } else if (this.modificationDate != null) {
            date = this.modificationDate;
        }
        if (date != null) {
            attachmentNode.addMetadata("CreatedDate", DateRange.getISODateString(this.creationDate), true);
        }
        if (this.name.endsWith(".lnk")) {
            this.name = this.name + ".txt";
        }
        attachmentNode.addObject(this.getRawAttachmentContent(), this.name, "BinaryMaster", 1);
        String textExtract = null;
        if (fatherExtractor.options.extractFileTextFile || fatherExtractor.options.extractFileTextMetadata) {
            try {
                textExtract = TikaExtractor.getInstance().extractTextFromBinary(this.getRawAttachmentContent());
            }
            catch (MailExtractLibException ee) {
                MailExtractProgressLogger.doProgressLog(fatherExtractor.getProgressLogger(), 60, "mailextractlib: can't extract text content from attachment " + this.name, ee);
            }
        }
        if (fatherExtractor.options.extractFileTextFile && textExtract != null && !textExtract.trim().isEmpty()) {
            attachmentNode.addObject(textExtract.getBytes(StandardCharsets.UTF_8), this.name + ".txt", "TextContent", 1);
        }
        if (fatherExtractor.options.extractFileTextMetadata && textExtract != null && !textExtract.isEmpty()) {
            attachmentNode.addLongMetadata("TextContent", textExtract, true);
        }
        if (writeFlag) {
            attachmentNode.write();
        }
    }

    private boolean extractAsStoreAttachment(ArchiveUnit node, boolean writeFlag) throws MailExtractLibException, InterruptedException {
        StoreExtractor fatherExtractor = this.fatherElement.getStoreExtractor();
        Boolean isContainerScheme = false;
        StoreExtractor extractor = null;
        MailExtractProgressLogger.doProgressLog(fatherExtractor.getProgressLogger(), 60, "mailextractlib: begin " + this.attachmentStoreScheme + " store content extraction from an attachment in " + this.fatherElement.getLogDescription(), null);
        Class storeExtractorClass = StoreExtractor.schemeStoreExtractorClassMap.get(this.attachmentStoreScheme);
        if (storeExtractorClass == null) {
            this.fatherElement.logMessageWarning("mailextractlib: unknown embedded store type=" + this.attachmentStoreScheme + " , extracting unit in path " + node.getFullName(), null);
        } else {
            isContainerScheme = StoreExtractor.schemeContainerMap.get(this.attachmentStoreScheme);
            if (isContainerScheme.booleanValue()) {
                node = new ArchiveUnit(fatherExtractor, node, "Container", this.name == null ? "Infile" : this.name);
                node.addMetadata("DescriptionLevel", "Item", true);
                node.addMetadata("Title", "Conteneur " + this.attachmentStoreScheme + (String)(this.name == null ? "" : " " + this.name), true);
                node.addMetadata("Description", "Extraction d'un conteneur " + this.attachmentStoreScheme + (String)(this.name == null ? "" : " " + this.name), true);
            }
            try {
                extractor = (StoreExtractor)storeExtractorClass.getConstructor(StoreAttachment.class, ArchiveUnit.class, StoreExtractorOptions.class, StoreExtractor.class, StoreElement.class, MailExtractProgressLogger.class).newInstance(this, node, fatherExtractor.options, fatherExtractor, this.fatherElement, this.fatherElement.getProgressLogger());
            }
            catch (InvocationTargetException e) {
                Throwable te = e.getCause();
                this.fatherElement.logMessageWarning("mailextractlib: dysfonctional embedded store type=" + this.attachmentStoreScheme + " , extracting unit in path " + node.getFullName(), te);
            }
            catch (Exception e) {
                this.fatherElement.logMessageWarning("mailextractlib: dysfonctional embedded store type=" + this.attachmentStoreScheme + " , extracting unit in path " + node.getFullName(), e);
            }
        }
        if (extractor != null) {
            try {
                extractor.writeTargetLog();
                extractor.getRootFolder().extractFolderAsRoot(writeFlag);
                fatherExtractor.accumulateSubElements(extractor);
                extractor.endStoreExtractor();
                if (extractor.getRootFolder().getDateRange().isDefined() && isContainerScheme.booleanValue()) {
                    node.addMetadata("StartDate", DateRange.getISODateString(extractor.getRootFolder().getDateRange().getStart()), true);
                    node.addMetadata("EndDate", DateRange.getISODateString(extractor.getRootFolder().getDateRange().getEnd()), true);
                }
                if (writeFlag) {
                    node.write();
                }
                MailExtractProgressLogger.doProgressLog(fatherExtractor.getProgressLogger(), 60, "mailextractlib: end " + this.attachmentStoreScheme + " store content extraction from an attachment in " + this.fatherElement.getLogDescription(), null);
            }
            catch (MailExtractLibException ee) {
                MailExtractProgressLogger.doProgressLog(fatherExtractor.getProgressLogger(), 60, "mailextractlib: can't extract " + this.attachmentStoreScheme + " store content from an attachment in " + this.fatherElement.getLogDescription(), ee);
            }
        }
        return extractor != null;
    }
}

