/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextractlib.core;

import fr.gouv.vitam.tools.mailextractlib.core.StoreAttachment;
import fr.gouv.vitam.tools.mailextractlib.core.StoreElement;
import fr.gouv.vitam.tools.mailextractlib.core.StoreExtractor;
import fr.gouv.vitam.tools.mailextractlib.core.StoreFolder;
import fr.gouv.vitam.tools.mailextractlib.nodes.ArchiveUnit;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractLibException;
import java.io.File;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Formatter;
import java.util.List;

public abstract class StoreAppointment
extends StoreElement {
    public static final int MESSAGE_STATUS_UNKNOWN = 0;
    public static final int MESSAGE_STATUS_LOCAL = 1;
    public static final int MESSAGE_STATUS_REQUEST = 2;
    public static final int MESSAGE_STATUS_RESPONSE_YES = 3;
    public static final int MESSAGE_STATUS_RESPONSE_MAY = 4;
    public static final int MESSAGE_STATUS_RESPONSE_NO = 5;
    public static final String[] MESSAGE_STATUS_TEXT = new String[]{"Unknown", "Local", "Request", "Resp.Yes", "Resp.May", "Resp.No"};
    protected String uniqId;
    protected String subject;
    protected String location;
    protected String from;
    protected String toAttendees;
    protected String ccAttendees;
    protected ZonedDateTime startTime;
    protected ZonedDateTime endTime;
    protected String miscNotes;
    protected String otherMiscNotes;
    protected ZonedDateTime modificationTime;
    protected List<StoreAttachment> attachments;
    protected int sequenceNumber;
    protected int messageStatus;
    protected String recurencePattern;
    protected ZonedDateTime startRecurrenceTime;
    protected ZonedDateTime endRecurrenceTime;
    protected List<StoreAppointment> exceptions;
    protected boolean isRecurrenceDeletion;
    protected ZonedDateTime exceptionDate;

    protected StoreAppointment(StoreFolder storeFolder) {
        super(storeFolder);
    }

    @Override
    public String getLogDescription() {
        String result = "appointment " + this.listLineId;
        result = this.subject != null ? result + " [" + this.subject + "/" : result + " [no subject/";
        result = result + this.getDateInDefinedTimeZone(this.startTime) + " - " + this.getDateInDefinedTimeZone(this.endTime) + "]";
        return result;
    }

    public abstract void analyzeAppointment() throws MailExtractLibException, InterruptedException;

    public static String getElementName() {
        return "appointments";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printGlobalListCSVHeader(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            ps.println("ID;Subject;Location;From;ToAttendees;CcAttendees;StartTime;EndTime;MiscNotes;uniqID;SequenceNumber;ModificationTime;Folder;MessageStatus;isRecurrent;RecurrencePattern;StartRecurrenceTime;EndRecurrenceTime;ExceptionFromId;ExceptionDate;isDeletion;hasAttachment");
        }
    }

    public void extractAppointment(boolean writeFlag, StoreAppointment father) throws InterruptedException, MailExtractLibException {
        if (writeFlag) {
            if (this.storeFolder.getStoreExtractor().getOptions().extractElementsList) {
                this.writeToAppointmentsList(father);
            }
            if (this.storeFolder.getStoreExtractor().getOptions().extractElementsContent && this.attachments != null && !this.attachments.isEmpty()) {
                ArchiveUnit attachmentNode = new ArchiveUnit(this.storeFolder.storeExtractor, this.storeFolder.storeExtractor.destRootPath + File.separator + this.storeFolder.storeExtractor.destName + File.separator + "appointments", "AppointmentAttachments#" + this.listLineId);
                attachmentNode.addMetadata("DescriptionLevel", "RecordGrp", true);
                attachmentNode.addMetadata("Title", "Appointment Attachments #" + this.listLineId, true);
                attachmentNode.addMetadata("Description", "Appointment attachments extracted for " + this.subject + "[" + this.startTime + "-" + this.endTime + "]", true);
                attachmentNode.addMetadata("StartDate", this.getDateInUTCTimeZone(this.startTime), true);
                attachmentNode.addMetadata("EndDate", this.getDateInUTCTimeZone(this.endTime), true);
                attachmentNode.write();
                StoreAttachment.extractAttachments(this.attachments, attachmentNode, writeFlag);
            }
            if (this.exceptions != null) {
                for (StoreAppointment a : this.exceptions) {
                    a.extractAppointment(writeFlag, this);
                }
            }
        }
    }

    private String getDateInUTCTimeZone(ZonedDateTime date) {
        String result = date != null ? date.withZoneSameInstant(ZoneId.of("UTC")).format(StoreExtractor.ISO_8601) : "";
        return result;
    }

    private String getDateInDefinedTimeZone(ZonedDateTime date) {
        String result = date != null ? date.format(StoreExtractor.ISO_8601) : "";
        return result;
    }

    private String normalizeUniqId(String uniqId) {
        String result = uniqId;
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("MD5");
            byte[] hash = md.digest(uniqId.getBytes(StandardCharsets.US_ASCII));
            Formatter formatter = new Formatter();
            for (byte b : hash) {
                formatter.format("%02x", b);
            }
            result = formatter.toString();
            formatter.close();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToAppointmentsList(StoreAppointment father) {
        PrintStream ps;
        PrintStream printStream = ps = this.storeFolder.getStoreExtractor().getGlobalListPS(this.getClass());
        synchronized (printStream) {
            ps.format("\"%d\";", this.listLineId);
            ps.format("\"%s\";", this.filterHyphenForCsv(this.subject));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.location));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.from));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.toAttendees));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.ccAttendees));
            ps.format("\"%s\";", this.getDateInDefinedTimeZone(this.startTime));
            ps.format("\"%s\";", this.getDateInDefinedTimeZone(this.endTime));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.miscNotes));
            ps.format("\"%s\";", this.normalizeUniqId(this.uniqId));
            ps.format("\"%d\";", this.sequenceNumber);
            ps.format("\"%s\";", this.getDateInDefinedTimeZone(this.modificationTime));
            ps.format("\"%s\";", this.filterHyphenForCsv(this.storeFolder.getFullName()));
            ps.format("\"%s\";", MESSAGE_STATUS_TEXT[this.messageStatus]);
            ps.format("\"%s\";", this.recurencePattern != null && !this.recurencePattern.isEmpty() ? "X" : "");
            ps.format("\"%s\";", this.filterHyphenForCsv(this.recurencePattern));
            ps.format("\"%s\";", this.getDateInDefinedTimeZone(this.startRecurrenceTime));
            ps.format("\"%s\";", this.getDateInDefinedTimeZone(this.endRecurrenceTime));
            ps.format("\"%s\";", father != null ? Integer.valueOf(father.listLineId) : "");
            ps.format("\"%s\";", this.getDateInDefinedTimeZone(this.exceptionDate));
            ps.format("\"%s\";", this.isRecurrenceDeletion ? "X" : "");
            ps.format("\"%s\"", this.attachments != null && !this.attachments.isEmpty() ? Integer.toString(this.attachments.size()) : "");
            ps.println("");
            ps.flush();
        }
    }

    @Override
    public void processElement(boolean writeFlag) throws InterruptedException, MailExtractLibException {
        if (this.storeFolder.getStoreExtractor().getOptions().extractAppointments) {
            this.listLineId = this.storeFolder.getStoreExtractor().incElementCounter(this.getClass());
            this.analyzeAppointment();
            StoreAttachment.detectStoreAttachments(this.attachments);
            this.extractAppointment(writeFlag, null);
        }
    }

    @Override
    public void listElement(boolean statsFlag) throws InterruptedException, MailExtractLibException {
        if (this.storeFolder.getStoreExtractor().getOptions().extractAppointments) {
            this.listLineId = this.storeFolder.getStoreExtractor().incElementCounter(this.getClass());
            this.analyzeAppointment();
            if (statsFlag) {
                this.extractAppointment(false, null);
            }
        }
    }
}

