/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextract;

import fr.gouv.vitam.tools.mailextract.MailExtractLogger;
import fr.gouv.vitam.tools.mailextract.MailExtractMainWindow;
import fr.gouv.vitam.tools.mailextractlib.core.StoreExtractor;
import fr.gouv.vitam.tools.mailextractlib.core.StoreExtractorOptions;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractLibException;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractProgressLogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Paths;

public class MailExtractThread
extends Thread {
    private MailExtractMainWindow mainWindow;
    private int actionNumber;
    private StoreExtractor storeExtractor;
    private boolean debugFlag;
    private MailExtractLogger mel;
    private MailExtractProgressLogger logger;

    public MailExtractThread(MailExtractMainWindow mainWindow, int actionNumber, String protocol, String host, int port, String user, String password, String container, String folder, String destRootPath, String destName, StoreExtractorOptions storeExtractorOptions, String logLevel, boolean debugFlag) {
        this.mainWindow = mainWindow;
        try {
            this.mel = new MailExtractLogger(destRootPath + File.separator + destName + ".log", MailExtractLogger.getLevel(logLevel));
            this.logger = new MailExtractProgressLogger(this.mel.getProgressLogger(), MailExtractLogger.getLevel(logLevel), (count, log) -> {
                String newLog = mainWindow.consoleTextArea.getText() + "\n" + log;
                mainWindow.consoleTextArea.setText(newLog);
                mainWindow.consoleTextArea.setCaretPosition(newLog.length());
            }, 1000, 2, 40, 1000);
            this.logger.setDebugFlag(debugFlag);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        try {
            String urlString = StoreExtractor.composeStoreURL(protocol, host, user, password, container);
            this.storeExtractor = StoreExtractor.createStoreExtractor(urlString, folder, Paths.get(destRootPath, destName).toString(), storeExtractorOptions, this.logger);
            this.actionNumber = actionNumber;
        }
        catch (MailExtractLibException ee) {
            MailExtractProgressLogger.doProgressLogWithoutInterruption(this.logger, 10, "mailextract: erreur d'extraction", ee);
        }
        catch (Exception e) {
            this.actionNumber = 0;
            MailExtractProgressLogger.doProgressLogWithoutInterruption(this.logger, 10, "mailextract: erreur g\u00e9n\u00e9rale", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            switch (this.actionNumber) {
                case 1: {
                    this.storeExtractor.listAllFolders(false);
                    return;
                }
                case 2: {
                    this.storeExtractor.listAllFolders(true);
                    return;
                }
                case 3: {
                    if (!this.storeExtractor.hasDestName()) throw new MailExtractLibException("mailextract: no destination name for extraction", null);
                    this.storeExtractor.extractAllFolders();
                    return;
                }
            }
            return;
        }
        catch (MailExtractLibException ee) {
            MailExtractProgressLogger.doProgressLogWithoutInterruption(this.logger, 10, "mailextract: extraction error", ee);
            return;
        }
        catch (InterruptedException ie) {
            MailExtractProgressLogger.doProgressLogWithoutInterruption(this.logger, 10, "mailextract: extraction process interrupted", ie);
            return;
        }
        catch (Exception e) {
            MailExtractProgressLogger.doProgressLogWithoutInterruption(this.logger, 10, "mailextract: error", e);
            System.out.println(MailExtractThread.getPrintStackTrace(e));
            return;
        }
        finally {
            try {
                if (this.storeExtractor != null) {
                    this.storeExtractor.endStoreExtractor();
                }
            }
            catch (MailExtractLibException e) {
                MailExtractProgressLogger.doProgressLogWithoutInterruption(this.logger, 10, "mailextract: closing error", e);
            }
            if (this.logger != null) {
                this.logger.close();
            }
            if (this.mel != null) {
                this.mel.close();
            }
        }
    }

    private static final String getPrintStackTrace(Exception e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter p = new PrintWriter(baos);
        e.printStackTrace(p);
        p.close();
        return baos.toString();
    }
}

