/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextract;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.FileAppender;
import fr.gouv.vitam.tools.mailextract.MailExtractApp;
import fr.gouv.vitam.tools.mailextract.MailExtractException;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class MailExtractLogger {
    public static final int GLOBAL = 10;
    public static final Marker GLOBAL_MARKER = MarkerFactory.getMarker("GLOBAL");
    public static final int WARNING = 20;
    public static final Marker WARNING_MARKER = MarkerFactory.getMarker("WARNING");
    public static final int FOLDER = 30;
    public static final Marker FOLDER_MARKER = MarkerFactory.getMarker("FOLDER");
    public static final int MESSAGE_GROUP = 40;
    public static final Marker MESSAGE_GROUP_MARKER = MarkerFactory.getMarker("MESSAGE_GROUP");
    public static final int MESSAGE = 50;
    public static final Marker MESSAGE_MARKER = MarkerFactory.getMarker("MESSAGE");
    public static final int MESSAGE_DETAILS = 60;
    public static final Marker MESSAGE_DETAILS_MARKER = MarkerFactory.getMarker("MESSAGE_DETAILS");
    private static MailExtractLogger globalLogger = null;
    private Logger logger;
    private int progressLogLevel;

    public static MailExtractLogger getGlobalLogger() {
        if (globalLogger == null) {
            globalLogger = new MailExtractLogger(LoggerFactory.getLogger(MailExtractApp.class.getSimpleName()), 10);
        }
        return globalLogger;
    }

    private MailExtractLogger(Logger logger, int progressLogLevel) {
        this.logger = logger;
        this.progressLogLevel = progressLogLevel;
    }

    public MailExtractLogger(String logPath, int progressLogLevel) {
        LoggerContext logCtx = (LoggerContext)LoggerFactory.getILoggerFactory();
        PatternLayoutEncoder consoleEncoder = new PatternLayoutEncoder();
        consoleEncoder.setContext(logCtx);
        consoleEncoder.setPattern("%d{HH:mm:ss.SSS} [" + MailExtractApp.class.getSimpleName() + "] %-5level %marker - %msg%n");
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            consoleEncoder.setCharset(Charset.forName("cp850"));
        } else {
            consoleEncoder.setCharset(Charset.forName("UTF-8"));
        }
        consoleEncoder.start();
        ConsoleAppender<ILoggingEvent> logConsoleAppender = new ConsoleAppender<ILoggingEvent>();
        logConsoleAppender.setContext(logCtx);
        logConsoleAppender.setName("console");
        logConsoleAppender.setEncoder(consoleEncoder);
        logConsoleAppender.start();
        PatternLayoutEncoder fileEncoder = new PatternLayoutEncoder();
        fileEncoder.setContext(logCtx);
        fileEncoder.setPattern("%d{HH:mm:ss.SSS} [" + MailExtractApp.class.getSimpleName() + "] %-5level %marker - %msg%n");
        fileEncoder.setCharset(Charset.forName("UTF-8"));
        fileEncoder.start();
        FileAppender<ILoggingEvent> logFileAppender = new FileAppender<ILoggingEvent>();
        logFileAppender.setContext(logCtx);
        logFileAppender.setName("logFile");
        logFileAppender.setEncoder(fileEncoder);
        logFileAppender.setAppend(true);
        logFileAppender.setFile(logPath);
        logFileAppender.start();
        ch.qos.logback.classic.Logger log = logCtx.getLogger(logPath);
        log.setLevel(Level.INFO);
        log.addAppender((Appender<ILoggingEvent>)logConsoleAppender);
        log.addAppender((Appender<ILoggingEvent>)logFileAppender);
        log.setAdditive(false);
        this.logger = log;
        this.progressLogLevel = progressLogLevel;
    }

    public static int getLevel(String levelName) throws MailExtractException {
        if (levelName.equals("OFF")) {
            return -1;
        }
        if (levelName.equals(GLOBAL_MARKER.getName())) {
            return 10;
        }
        if (levelName.equals(WARNING_MARKER.getName())) {
            return 20;
        }
        if (levelName.equals(FOLDER_MARKER.getName())) {
            return 30;
        }
        if (levelName.equals(MESSAGE_GROUP_MARKER.getName())) {
            return 40;
        }
        if (levelName.equals(MESSAGE_MARKER.getName())) {
            return 50;
        }
        if (levelName.equals(MESSAGE_DETAILS_MARKER.getName())) {
            return 60;
        }
        throw new MailExtractException("Unknown log level");
    }

    public static Marker getMarker(int level) {
        switch (level) {
            case 10: {
                return GLOBAL_MARKER;
            }
            case 20: {
                return WARNING_MARKER;
            }
            case 30: {
                return FOLDER_MARKER;
            }
            case 40: {
                return MESSAGE_GROUP_MARKER;
            }
            case 50: {
                return MESSAGE_MARKER;
            }
            case 60: {
                return MESSAGE_DETAILS_MARKER;
            }
        }
        return GLOBAL_MARKER;
    }

    public void log(int level, String message) {
        if (level <= this.progressLogLevel && this.logger != null) {
            if (level >= 10) {
                this.logger.info(MailExtractLogger.getMarker(level), message);
            } else {
                this.logger.error(message);
            }
        }
    }

    public Logger getProgressLogger() {
        return this.logger;
    }

    public int getProgressLogLevel() {
        return this.progressLogLevel;
    }

    public void close() {
        if (this.logger instanceof ch.qos.logback.classic.Logger) {
            ((ch.qos.logback.classic.Logger)this.logger).detachAndStopAllAppenders();
        }
    }
}

