/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextract;

import fr.gouv.vitam.tools.mailextract.MailExtractMainWindow;
import fr.gouv.vitam.tools.mailextract.MailExtractThread;
import fr.gouv.vitam.tools.mailextractlib.core.StoreExtractorOptions;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;

public class MailExtractGraphicApp
implements ActionListener,
Runnable {
    private MailExtractMainWindow mainWindow;
    private String type;
    private String user;
    private String password;
    private String hostname;
    int port;
    private String container;
    private String folder;
    private String rootpath;
    private String outputname;
    StoreExtractorOptions storeExtractorOptions;
    private boolean debug = false;
    private String verbatim;
    private boolean english;
    static final int LIST_ACTION = 1;
    static final int STAT_ACTION = 2;
    static final int EXTRACT_ACTION = 3;
    static final int EMPTY_LOG = 4;
    String[] loglevelStrings = new String[]{"OFF", "GLOBAL", "WARNING", "FOLDER", "MESSAGE_GROUP", "MESSAGE", "MESSAGE_DETAILS"};

    MailExtractGraphicApp(String type, String user, String password, String hostname, int port, String container, String folder, String rootpath, String outputname, StoreExtractorOptions storeExtractorOptions, boolean debug, String verbatim, boolean english) {
        this.type = type;
        this.user = user;
        this.password = password;
        this.hostname = hostname;
        this.port = port;
        this.container = container;
        this.folder = folder;
        this.rootpath = rootpath;
        this.outputname = outputname;
        this.storeExtractorOptions = storeExtractorOptions;
        this.debug = debug;
        this.verbatim = verbatim;
        this.english = english;
        EventQueue.invokeLater(this);
    }

    @Override
    public void run() {
        try {
            this.mainWindow = new MailExtractMainWindow(this);
            this.insertOptions();
            this.mainWindow.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void insertOptions() {
        switch (this.type) {
            case "pst": {
                this.mainWindow.localRadioButton.doClick();
                this.mainWindow.pstRadioButton.doClick();
                this.mainWindow.containerField.setText(this.container);
                break;
            }
            case "mbox": {
                this.mainWindow.localRadioButton.doClick();
                this.mainWindow.mboxRadioButton.doClick();
                this.mainWindow.containerField.setText(this.container);
                break;
            }
            case "eml": {
                this.mainWindow.localRadioButton.doClick();
                this.mainWindow.emlRadioButton.doClick();
                this.mainWindow.containerField.setText(this.container);
                break;
            }
            case "thunderbird": {
                this.mainWindow.localRadioButton.doClick();
                this.mainWindow.thunderbirdRadioButton.doClick();
                this.mainWindow.containerField.setText(this.container);
                break;
            }
            case "msg": {
                this.mainWindow.localRadioButton.doClick();
                this.mainWindow.msgRadioButton.doClick();
                this.mainWindow.containerField.setText(this.container);
                break;
            }
            case "imap": {
                this.mainWindow.protocoleRadioButton.doClick();
                this.mainWindow.imapRadioButton.doClick();
                this.mainWindow.userField.setText(this.user);
                this.mainWindow.passwordField.setText(this.password);
                this.mainWindow.serverField.setText((String)(this.port != -1 ? this.hostname + ":" + this.port : this.hostname));
                break;
            }
            case "imaps": {
                this.mainWindow.protocoleRadioButton.doClick();
                this.mainWindow.imapsRadioButton.doClick();
                this.mainWindow.userField.setText(this.user);
                this.mainWindow.passwordField.setText(this.password);
                this.mainWindow.serverField.setText((String)(this.port != -1 ? this.hostname + ":" + this.port : this.hostname));
            }
        }
        this.mainWindow.folderField.setText(this.folder);
        this.mainWindow.savedirField.setText(this.rootpath);
        this.mainWindow.nameField.setText(this.outputname);
        this.mainWindow.keepOnlyDeepCheckBox.setSelected(this.storeExtractorOptions.keepOnlyDeepEmptyFolders);
        this.mainWindow.dropEmptyFoldersCheckBox.setSelected(this.storeExtractorOptions.dropEmptyFolders);
        this.mainWindow.warningCheckBox.setSelected(this.storeExtractorOptions.warningMsgProblem);
        this.mainWindow.extractMessageCheckBox.setSelected(this.storeExtractorOptions.extractMessages);
        this.mainWindow.extractContactCheckBox.setSelected(this.storeExtractorOptions.extractContacts);
        this.mainWindow.extractAppointmentCheckBox.setSelected(this.storeExtractorOptions.extractAppointments);
        this.mainWindow.extractContentCheckBox.setSelected(this.storeExtractorOptions.extractElementsContent);
        this.mainWindow.extractListCheckBox.setSelected(this.storeExtractorOptions.extractElementsList);
        this.mainWindow.extractmessagetextfileCheckBox.setSelected(this.storeExtractorOptions.extractMessageTextFile);
        this.mainWindow.extractmessagetextmetadataCheckBox.setSelected(this.storeExtractorOptions.extractMessageTextMetadata);
        this.mainWindow.extractfiletextfileCheckBox.setSelected(this.storeExtractorOptions.extractFileTextFile);
        this.mainWindow.extractfiletextmetadataCheckBox.setSelected(this.storeExtractorOptions.extractFileTextMetadata);
        this.mainWindow.charsetComboBox.setSelectedItem(this.storeExtractorOptions.defaultCharsetName);
        this.mainWindow.namesLengthField.setText(Integer.toString(this.storeExtractorOptions.namesLength));
        this.mainWindow.debugCheckBox.setSelected(this.debug);
        this.mainWindow.englishCheckBox.setSelected(this.english);
        for (int i = 0; i < 7; ++i) {
            if (!this.verbatim.equals(this.loglevelStrings[i])) continue;
            this.verbatim = this.mainWindow.loglevelGraphicStrings[i];
            break;
        }
        this.mainWindow.loglevelComboBox.setSelectedItem(this.verbatim);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals("local")) {
            this.mainWindow.thunderbirdRadioButton.setEnabled(true);
            this.mainWindow.pstRadioButton.setEnabled(true);
            this.mainWindow.mboxRadioButton.setEnabled(true);
            this.mainWindow.emlRadioButton.setEnabled(true);
            this.mainWindow.msgRadioButton.setEnabled(true);
            this.mainWindow.containerLabel.setEnabled(true);
            this.mainWindow.containerField.setEnabled(true);
            this.mainWindow.containerButton.setEnabled(true);
            this.mainWindow.imapRadioButton.setEnabled(false);
            this.mainWindow.imapsRadioButton.setEnabled(false);
            this.mainWindow.serverLabel.setEnabled(false);
            this.mainWindow.serverField.setEnabled(false);
            this.mainWindow.userLabel.setEnabled(false);
            this.mainWindow.userField.setEnabled(false);
            this.mainWindow.passwordLabel.setEnabled(false);
            this.mainWindow.passwordField.setEnabled(false);
        } else if (command.equals("protocole")) {
            this.mainWindow.thunderbirdRadioButton.setEnabled(false);
            this.mainWindow.pstRadioButton.setEnabled(false);
            this.mainWindow.mboxRadioButton.setEnabled(false);
            this.mainWindow.emlRadioButton.setEnabled(false);
            this.mainWindow.msgRadioButton.setEnabled(false);
            this.mainWindow.containerLabel.setEnabled(false);
            this.mainWindow.containerField.setEnabled(false);
            this.mainWindow.containerButton.setEnabled(false);
            this.mainWindow.imapRadioButton.setEnabled(true);
            this.mainWindow.imapsRadioButton.setEnabled(true);
            this.mainWindow.serverLabel.setEnabled(true);
            this.mainWindow.serverField.setEnabled(true);
            this.mainWindow.userLabel.setEnabled(true);
            this.mainWindow.userField.setEnabled(true);
            this.mainWindow.passwordLabel.setEnabled(true);
            this.mainWindow.passwordField.setEnabled(true);
        } else if (command.equals("container")) {
            String filename = this.selectPath(this.mainWindow.containerField.getText(), false);
            if (filename != null) {
                this.mainWindow.containerField.setText(filename);
            }
        } else if (command.equals("savedir")) {
            String dirname = this.selectPath(this.mainWindow.savedirField.getText(), true);
            if (dirname != null) {
                this.mainWindow.savedirField.setText(dirname);
            }
        } else if (command.equals("list")) {
            this.doAction(1);
        } else if (command.equals("stat")) {
            this.doAction(2);
        } else if (command.equals("extract")) {
            this.doAction(3);
        } else if (command.equals("empty")) {
            this.doAction(4);
        }
    }

    private String selectPath(String folder, boolean dirBool) {
        int returnVal;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(dirBool ? 1 : 2);
        fileChooser.setFileHidingEnabled(false);
        File file = new File(folder);
        if (file.exists()) {
            fileChooser.setSelectedFile(file);
        }
        if ((returnVal = fileChooser.showOpenDialog(this.mainWindow)) == 0) {
            file = fileChooser.getSelectedFile();
            return file.getAbsolutePath();
        }
        return null;
    }

    private void doAction(int actionNumber) {
        this.parseParams();
        if (actionNumber == 4) {
            this.mainWindow.consoleTextArea.setText("");
        } else {
            new MailExtractThread(this.mainWindow, actionNumber, this.type, this.hostname, this.port, this.user, this.password, this.container, this.folder, this.rootpath, this.outputname, this.storeExtractorOptions, this.verbatim, this.debug).start();
        }
    }

    private void parseParams() {
        if (this.mainWindow.localRadioButton.isSelected()) {
            if (this.mainWindow.thunderbirdRadioButton.isSelected()) {
                this.type = "thunderbird";
            } else if (this.mainWindow.emlRadioButton.isSelected()) {
                this.type = "eml";
            } else if (this.mainWindow.msgRadioButton.isSelected()) {
                this.type = "msg";
            } else if (this.mainWindow.mboxRadioButton.isSelected()) {
                this.type = "mbox";
            } else if (this.mainWindow.pstRadioButton.isSelected()) {
                this.type = "pst";
            }
            this.container = this.mainWindow.containerField.getText();
        } else {
            this.type = this.mainWindow.imapsRadioButton.isSelected() ? "imaps" : "imap";
            String server = this.mainWindow.serverField.getText();
            if (server.indexOf(58) >= 0) {
                this.hostname = server.substring(0, server.indexOf(58));
                this.port = Integer.parseInt(server.substring(server.indexOf(58) + 1));
            } else {
                this.hostname = server;
            }
            this.user = this.mainWindow.userField.getText();
            this.password = this.mainWindow.passwordField.getText();
        }
        this.folder = this.mainWindow.folderField.getText();
        this.rootpath = this.mainWindow.savedirField.getText();
        this.outputname = this.mainWindow.nameField.getText();
        this.storeExtractorOptions.keepOnlyDeepEmptyFolders = this.mainWindow.keepOnlyDeepCheckBox.isSelected();
        this.storeExtractorOptions.dropEmptyFolders = this.mainWindow.dropEmptyFoldersCheckBox.isSelected();
        this.storeExtractorOptions.warningMsgProblem = this.mainWindow.warningCheckBox.isSelected();
        this.storeExtractorOptions.extractMessages = this.mainWindow.extractMessageCheckBox.isSelected();
        this.storeExtractorOptions.extractContacts = this.mainWindow.extractContactCheckBox.isSelected();
        this.storeExtractorOptions.extractAppointments = this.mainWindow.extractAppointmentCheckBox.isSelected();
        this.storeExtractorOptions.extractElementsContent = this.mainWindow.extractContentCheckBox.isSelected();
        this.storeExtractorOptions.extractElementsList = this.mainWindow.extractListCheckBox.isSelected();
        this.storeExtractorOptions.extractMessageTextFile = this.mainWindow.extractmessagetextfileCheckBox.isSelected();
        this.storeExtractorOptions.extractMessageTextMetadata = this.mainWindow.extractmessagetextmetadataCheckBox.isSelected();
        this.storeExtractorOptions.extractFileTextFile = this.mainWindow.extractfiletextfileCheckBox.isSelected();
        this.storeExtractorOptions.extractFileTextMetadata = this.mainWindow.extractfiletextmetadataCheckBox.isSelected();
        this.debug = this.mainWindow.debugCheckBox.isSelected();
        try {
            this.storeExtractorOptions.namesLength = Integer.parseInt(this.mainWindow.namesLengthField.getText());
        }
        catch (NumberFormatException e) {
            this.mainWindow.namesLengthField.setText(Integer.toString(this.storeExtractorOptions.namesLength));
        }
        this.storeExtractorOptions.defaultCharsetName = (String)this.mainWindow.charsetComboBox.getSelectedItem();
        this.verbatim = (String)this.mainWindow.loglevelComboBox.getSelectedItem();
        for (int i = 0; i < 7; ++i) {
            if (!this.verbatim.equals(this.mainWindow.loglevelGraphicStrings[i])) continue;
            this.verbatim = this.loglevelStrings[i];
            break;
        }
    }
}

