/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.mailextract;

import fr.gouv.vitam.tools.mailextract.MailExtractException;
import fr.gouv.vitam.tools.mailextract.MailExtractGraphicApp;
import fr.gouv.vitam.tools.mailextract.MailExtractLogger;
import fr.gouv.vitam.tools.mailextractlib.core.StoreExtractor;
import fr.gouv.vitam.tools.mailextractlib.core.StoreExtractorOptions;
import fr.gouv.vitam.tools.mailextractlib.core.StoreFolder;
import fr.gouv.vitam.tools.mailextractlib.core.StoreMessage;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractLibException;
import fr.gouv.vitam.tools.mailextractlib.utils.MailExtractProgressLogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.file.Paths;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class MailExtractApp {
    private static String noNullString(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private static Options createOptions() {
        Options options = new Options();
        Option help = new Option("h", "help", false, "help");
        options.addOption(help);
        Option type = new Option("t", "type", true, "type of local container to extract (thunderbird|pst|eml|mbox|msg) or protocol for server access (imap|imaps|pop3...) [default pst]");
        options.addOption(type);
        Option user = new Option("u", "username", true, "user account name (also used for destination extraction naming)");
        options.addOption(user);
        Option password = new Option("p", "password", true, "password");
        options.addOption(password);
        Option server = new Option("s", "server", true, "mail server [HostName|IP](:port)");
        options.addOption(server);
        Option container = new Option("c", "container", true, "local container directory or file to extract");
        options.addOption(container);
        Option folder = new Option("f", "folder", true, "specific mail folder to extract [default root]");
        options.addOption(folder);
        Option rootpath = new Option("r", "rootpath", true, "path for output directory [default current directory]");
        options.addOption(rootpath);
        Option outputname = new Option("o", "outputname", true, "name for output [default no name, extraction in rootpath directly, and log file is .log]");
        options.addOption(outputname);
        Option dropemptyfolders = new Option("d", "dropemptyfolders [default false]", false, "drop empty folders");
        options.addOption(dropemptyfolders);
        Option keeponlydeep = new Option("k", "keeponlydeep [default false]", false, "keep only empty folders not at root level");
        options.addOption(keeponlydeep);
        Option nameslength = new Option("n", "nameslength", true, "length limit for directories and files generated names [default 12]");
        options.addOption(nameslength);
        Option setchar = new Option("cs", "charset", true, "used charset in extraction [default UTF-8]");
        options.addOption(setchar);
        Option extractchoices = new Option("e", "extractchoices", true, "which elements are extracted with m for mails, c for contacts and a for appointment [default mca]");
        options.addOption(extractchoices);
        Option extractmode = new Option("ml", "extractmode", true, "which form of extraction with c for content and l for lists [default cl]");
        options.addOption(extractmode);
        Option extracttextmetadata = new Option("tm", "extracttextmetadata", true, "extract text and add to metadata with m for message and a for attachments [default nothing]");
        options.addOption(extracttextmetadata);
        Option extracttextfile = new Option("tf", "extracttextfile", true, "extract text and add a text file with m for message and a for attachments [default nothing]");
        options.addOption(extracttextfile);
        Option model = new Option("model", "model", true, "model of metadata extraction on disk 1 or 2 (default 2)");
        options.addOption(model);
        Option warning = new Option("w", "warning", false, "generate warning when there's a problem on a message whatever log level except OFF (otherwise log only at MESSAGE_DETAILS level) [default false]");
        options.addOption(warning);
        Option debug = new Option("b", "debug", false, "activate debug log [default false]");
        options.addOption(debug);
        Option verbatim = new Option("v", "verbatim", true, "event level to log (OFF|GLOBAL|WARNING|FOLDER|MESSAGE_GROUP|MESSAGE|MESSAGE_DETAILS) [default OFF]");
        options.addOption(verbatim);
        Option english = new Option("u", "english", true, "english version GUI");
        options.addOption(english);
        Option extract = new Option("x", "doextract", false, "extract all informations action");
        options.addOption(extract);
        Option list = new Option("l", "dolist", false, "process all informations and list folders action (no drop options)");
        options.addOption(list);
        Option stats = new Option("z", "dostats", false, "process all informations and list folders and there statistics action  (no drop options)");
        options.addOption(stats);
        return options;
    }

    public static void main(String[] args) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        String extractTextFile;
        String extractTextMetadata;
        String extractMode;
        String extractChoices;
        String charset;
        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        Options options = MailExtractApp.createOptions();
        CommandLine cmd = null;
        DefaultParser parser = new DefaultParser();
        try {
            cmd = parser.parse(options, args);
            if (cmd.hasOption("h")) {
                HelpFormatter formatter = new HelpFormatter();
                String header = "Mail extraction application (pst|thundebird|mbox|eml|msg files and distant mail servers)\n\nOptions :";
                String footer = "\nwhen no x, l or z action is given the GUI is launched";
                formatter.printHelp("MailExtract", header, options, footer);
                System.exit(0);
            }
        }
        catch (ParseException e) {
            System.out.println("Can't analyze options : " + e.getMessage());
            System.exit(1);
        }
        String type = cmd.hasOption("type") ? MailExtractApp.noNullString(cmd.getOptionValue("type")) : "pst";
        String user = MailExtractApp.noNullString(cmd.getOptionValue("user"));
        String password = MailExtractApp.noNullString(cmd.getOptionValue("password"));
        String server = cmd.getOptionValue("server");
        String hostname = "";
        int port = -1;
        if (server != null) {
            try {
                if (server.indexOf(58) >= 0) {
                    hostname = server.substring(0, server.indexOf(58));
                    port = Integer.parseInt(server.substring(server.indexOf(58) + 1));
                } else {
                    hostname = server;
                }
            }
            catch (NumberFormatException e) {
                System.out.println("Wrong server format must be <hostname[:port]>");
                System.exit(1);
            }
        }
        String container = MailExtractApp.noNullString(cmd.getOptionValue("container"));
        String folder = MailExtractApp.noNullString(cmd.getOptionValue("folder"));
        String rootPath = cmd.hasOption("rootpath") ? MailExtractApp.noNullString(cmd.getOptionValue("rootpath")) : System.getProperty("user.dir");
        String outputName = MailExtractApp.noNullString(cmd.getOptionValue("outputname"));
        boolean dropEmptyFolders = cmd.hasOption("dropemptyfolders");
        boolean keepFirstLevelEmptyFolders = cmd.hasOption("keepfirstLlevelemptyfolders");
        int namesLength = 12;
        if (cmd.hasOption("nameslength")) {
            try {
                namesLength = Integer.parseInt(cmd.getOptionValue("nameslength"));
            }
            catch (NumberFormatException e) {
                System.err.println("The names length argument must be numeric");
                System.exit(1);
            }
        }
        if (cmd.hasOption("charset")) {
            charset = MailExtractApp.noNullString(cmd.getOptionValue("charset"));
            try {
                if (!Charset.isSupported(charset)) {
                    throw new IllegalCharsetNameException(charset);
                }
            }
            catch (IllegalCharsetNameException e) {
                System.err.println("The specified charset '" + charset + "' is not supported.");
                System.exit(1);
            }
        } else {
            charset = "UTF-8";
        }
        if (cmd.hasOption("extractchoices")) {
            extractChoices = MailExtractApp.noNullString(cmd.getOptionValue("extractchoices"));
            if (!extractChoices.matches("^[mca]{0,3}$")) {
                System.err.println("The 'extractchoices' argument must only contain the letters 'm', 'c', and 'a', each at most once and in any order.");
                System.exit(1);
            }
        } else {
            extractChoices = "mca";
        }
        if (cmd.hasOption("extractmode")) {
            extractMode = MailExtractApp.noNullString(cmd.getOptionValue("extractmode"));
            if (!extractMode.matches("^[cl]{0,2}$")) {
                System.err.println("The 'extractmode' argument must only contain the letters 'c' and 'l', each at most once and in any order.");
                System.exit(1);
            }
        } else {
            extractMode = "cl";
        }
        if (cmd.hasOption("extracttextmetadata")) {
            extractTextMetadata = MailExtractApp.noNullString(cmd.getOptionValue("extracttextmetadata"));
            if (!extractTextMetadata.matches("^[ma]{0,2}$")) {
                System.err.println("The 'extracttextmetadata' argument must only contain the letters 'm' and 'a', each at most once and in any order.");
                System.exit(1);
            }
        } else {
            extractTextMetadata = "";
        }
        if (cmd.hasOption("extracttextfile")) {
            extractTextFile = MailExtractApp.noNullString(cmd.getOptionValue("extracttextfile"));
            if (!extractTextFile.matches("^[ma]{0,2}$")) {
                System.err.println("The 'extracttextfile' argument must only contain the letters 'm' and 'a', each at most once and in any order.");
                System.exit(1);
            }
        } else {
            extractTextFile = "";
        }
        int model = 2;
        if (cmd.hasOption("model")) {
            try {
                model = Integer.parseInt(cmd.getOptionValue("model"));
            }
            catch (NumberFormatException e) {
                System.err.println("The model argument must be numeric");
                System.exit(1);
            }
            if (model != 1 && model != 2) {
                System.err.println("The model argument must 1 or 2");
                System.exit(1);
            }
        }
        boolean warning = cmd.hasOption("warning");
        boolean debug = cmd.hasOption("debug");
        String verbatim = "OFF";
        if (cmd.hasOption("verbatim")) {
            verbatim = cmd.getOptionValue("verbatim");
            try {
                MailExtractLogger.getLevel(verbatim);
            }
            catch (MailExtractException iae) {
                System.err.println("Unknown log level must be in the list (OFF|GLOBAL|WARNING|FOLDER|MESSAGE_GROUP|MESSAGE|MESSAGE_DETAILS)");
                System.exit(1);
            }
        }
        boolean english = cmd.hasOption("english");
        StoreExtractorOptions storeExtractorOptions = new StoreExtractorOptions(keepFirstLevelEmptyFolders, dropEmptyFolders, warning, namesLength, charset, extractChoices.contains("m"), extractChoices.contains("c"), extractChoices.contains("a"), extractMode.contains("c"), extractMode.contains("l"), extractTextFile.contains("m"), extractTextMetadata.contains("m"), extractTextFile.contains("a"), extractTextMetadata.contains("a"), model);
        StoreExtractor.initDefaultExtractors(false);
        if (!(cmd.hasOption("l") || cmd.hasOption("z") || cmd.hasOption("x"))) {
            new MailExtractGraphicApp(type, user, password, hostname, port, container, folder, rootPath, outputName, storeExtractorOptions, debug, verbatim, english);
        } else {
            switch (type) {
                case "thunderbird": 
                case "pst": 
                case "eml": 
                case "mbox": 
                case "msg": {
                    if (!cmd.hasOption("container")) {
                        System.out.println("local " + type + " extraction need a container path");
                        System.exit(1);
                    }
                    if (!cmd.hasOption("server")) break;
                    System.err.println("no need a server for local " + type + " extraction");
                    System.exit(1);
                    break;
                }
                default: {
                    if (!cmd.hasOption("user")) {
                        System.err.println("need a username for distant access protocol");
                        System.exit(1);
                    }
                    if (!cmd.hasOption("server")) {
                        System.err.println("need a server (hostname or ip) for " + type + " access protocol");
                        System.exit(1);
                    }
                    if (!cmd.hasOption("container")) break;
                    System.err.println("no container for " + type + " access protocol");
                    System.exit(1);
                }
            }
            StoreExtractor storeExtractor = null;
            MailExtractLogger mel = null;
            MailExtractProgressLogger mepl = null;
            try {
                mel = new MailExtractLogger(rootPath + File.separator + outputName + ".log", MailExtractLogger.getLevel(verbatim));
                mepl = new MailExtractProgressLogger(mel.getProgressLogger(), MailExtractLogger.getLevel(verbatim));
                mepl.setDebugFlag(debug);
                String urlString = StoreExtractor.composeStoreURL(type, server, user, password, container);
                storeExtractor = StoreExtractor.createStoreExtractor(urlString, folder, Paths.get(rootPath, outputName).toString(), storeExtractorOptions, mepl);
                if (cmd.hasOption("l") || cmd.hasOption("z")) {
                    storeExtractor.listAllFolders(cmd.hasOption("z"));
                } else {
                    storeExtractor.extractAllFolders();
                }
                storeExtractor.endStoreExtractor();
            }
            catch (MailExtractLibException ee) {
                MailExtractProgressLogger.doProgressLogWithoutInterruption(mepl, 10, "mailextract: extraction error", ee);
                System.exit(1);
            }
            catch (Exception e) {
                MailExtractApp.logFatalError(e, storeExtractor, mel);
                System.exit(1);
            }
        }
    }

    private static final void logFatalError(Exception e, StoreExtractor storeExtractor, MailExtractLogger logger) {
        if (logger == null) {
            logger = MailExtractLogger.getGlobalLogger();
        }
        logger.log(10, "Terminated with unrecoverable error");
        if (!e.getMessage().isEmpty()) {
            logger.log(10, e.getMessage());
        }
        logger.log(10, MailExtractApp.getPrintStackTrace(e));
        if (storeExtractor == null || storeExtractor.getElementCounter(StoreFolder.class, false) + storeExtractor.getElementCounter(StoreMessage.class, false) == 0) {
            logger.log(10, "No writing done");
        } else {
            logger.log(10, "Partial extraction done in " + storeExtractor.getSummary());
        }
    }

    private static final String getPrintStackTrace(Exception e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter p = new PrintWriter(baos);
        e.printStackTrace(p);
        p.close();
        return baos.toString();
    }
}

