/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.javalibpst;

import fr.gouv.vitam.tools.javalibpst.PSTDescriptorItem;
import fr.gouv.vitam.tools.javalibpst.PSTException;
import fr.gouv.vitam.tools.javalibpst.PSTNodeInputStream;
import fr.gouv.vitam.tools.javalibpst.PSTTable;
import fr.gouv.vitam.tools.javalibpst.PSTTable7CItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

class PSTTable7C
extends PSTTable {
    private int BLOCK_SIZE = 8176;
    private List<HashMap<Integer, PSTTable7CItem>> items = null;
    private int numberOfDataSets = 0;
    private int cCols = 0;
    private int TCI_bm = 0;
    private PSTTable.NodeInfo rowNodeInfo = null;
    private int TCI_1b = 0;
    private int overrideCol = -1;
    ColumnDescriptor[] columnDescriptors = null;
    HashMap<Integer, Integer> keyMap = null;

    protected PSTTable7C(PSTNodeInputStream in, HashMap<Integer, PSTDescriptorItem> subNodeDescriptorItems) throws PSTException, IOException {
        this(in, subNodeDescriptorItems, -1);
    }

    protected PSTTable7C(PSTNodeInputStream in, HashMap<Integer, PSTDescriptorItem> subNodeDescriptorItems, int entityToExtract) throws PSTException, IOException {
        super(in, subNodeDescriptorItems);
        if (this.tableTypeByte != 124) {
            throw new PSTException("unable to create PSTTable7C, table does not appear to be a 7c!");
        }
        PSTTable.NodeInfo tcHeaderNode = this.getNodeInfo(this.hidUserRoot);
        int offset = 0;
        this.cCols = (int)tcHeaderNode.seekAndReadLong(offset + 1, 1);
        int TCI_4b = (int)tcHeaderNode.seekAndReadLong(offset + 2, 2);
        int TCI_2b = (int)tcHeaderNode.seekAndReadLong(offset + 4, 2);
        this.TCI_1b = (int)tcHeaderNode.seekAndReadLong(offset + 6, 2);
        this.TCI_bm = (int)tcHeaderNode.seekAndReadLong(offset + 8, 2);
        int hidRowIndex = (int)tcHeaderNode.seekAndReadLong(offset + 10, 4);
        int hnidRows = (int)tcHeaderNode.seekAndReadLong(offset + 14, 4);
        offset += 22;
        if (this.cCols != 0) {
            this.columnDescriptors = new ColumnDescriptor[this.cCols];
            for (int col = 0; col < this.cCols; ++col) {
                this.columnDescriptors[col] = new ColumnDescriptor(tcHeaderNode, offset);
                if (this.columnDescriptors[col].id == entityToExtract) {
                    this.overrideCol = col;
                }
                offset += 8;
            }
        }
        if (this.overrideCol > -1) {
            this.cCols = this.overrideCol + 1;
        }
        this.keyMap = new HashMap();
        PSTTable.NodeInfo keyTableInfo = this.getNodeInfo(this.hidRoot);
        this.numberOfKeys = keyTableInfo.length() / (this.sizeOfItemKey + this.sizeOfItemValue);
        offset = 0;
        for (int x = 0; x < this.numberOfKeys; ++x) {
            int Context2 = (int)keyTableInfo.seekAndReadLong(offset, this.sizeOfItemKey);
            int RowIndex = (int)keyTableInfo.seekAndReadLong(offset += this.sizeOfItemKey, this.sizeOfItemValue);
            offset += this.sizeOfItemValue;
            this.keyMap.put(Context2, RowIndex);
        }
        this.BLOCK_SIZE = in.getPSTFile().getPSTFileType() == 14 ? 8180 : 8176;
        this.rowNodeInfo = this.getNodeInfo(hnidRows);
        this.description = this.description + "Number of keys: " + this.numberOfKeys + "\nNumber of columns: " + this.cCols + "\nRow Size: " + this.TCI_bm + "\nhidRowIndex: " + hidRowIndex + "\nhnidRows: " + hnidRows + "\n";
        int numberOfBlocks = this.rowNodeInfo.length() / this.BLOCK_SIZE;
        int numberOfRowsPerBlock = this.BLOCK_SIZE / this.TCI_bm;
        int blockPadding = this.BLOCK_SIZE - numberOfRowsPerBlock * this.TCI_bm;
        this.numberOfDataSets = numberOfBlocks * numberOfRowsPerBlock + this.rowNodeInfo.length() % this.BLOCK_SIZE / this.TCI_bm;
    }

    List<HashMap<Integer, PSTTable7CItem>> getItems() throws PSTException, IOException {
        if (this.items == null) {
            this.items = this.getItems(-1, -1);
        }
        return this.items;
    }

    List<HashMap<Integer, PSTTable7CItem>> getItems(int startAtRecord, int numberOfRecordsToReturn) throws PSTException, IOException {
        ArrayList<HashMap<Integer, PSTTable7CItem>> itemList = new ArrayList<HashMap<Integer, PSTTable7CItem>>();
        int numberOfBlocks = this.rowNodeInfo.length() / this.BLOCK_SIZE;
        int numberOfRowsPerBlock = this.BLOCK_SIZE / this.TCI_bm;
        int blockPadding = this.BLOCK_SIZE - numberOfRowsPerBlock * this.TCI_bm;
        this.numberOfDataSets = numberOfBlocks * numberOfRowsPerBlock + this.rowNodeInfo.length() % this.BLOCK_SIZE / this.TCI_bm;
        if (startAtRecord == -1) {
            numberOfRecordsToReturn = this.numberOfDataSets;
            startAtRecord = 0;
        }
        int currentValueArrayStart = startAtRecord / numberOfRowsPerBlock * this.BLOCK_SIZE + startAtRecord % numberOfRowsPerBlock * this.TCI_bm;
        if (numberOfRecordsToReturn > this.getRowCount() - startAtRecord) {
            numberOfRecordsToReturn = this.getRowCount() - startAtRecord;
        }
        int dataSetNumber = 0;
        for (int rowCounter = 0; rowCounter < numberOfRecordsToReturn; ++rowCounter) {
            HashMap<Integer, PSTTable7CItem> currentItem = new HashMap<Integer, PSTTable7CItem>();
            currentValueArrayStart = (startAtRecord + rowCounter) / numberOfRowsPerBlock * this.BLOCK_SIZE + (startAtRecord + rowCounter) % numberOfRowsPerBlock * this.TCI_bm;
            byte[] bitmap = new byte[(this.cCols + 7) / 8];
            this.rowNodeInfo.in.seek(this.rowNodeInfo.startOffset + currentValueArrayStart + this.TCI_1b);
            this.rowNodeInfo.in.readCompletely(bitmap);
            int id = (int)this.rowNodeInfo.seekAndReadLong(currentValueArrayStart, 4);
            PSTTable7CItem item = new PSTTable7CItem();
            item.itemIndex = -1;
            item.entryValueType = 3;
            item.entryType = 26610;
            item.entryValueReference = id;
            item.isExternalValueReference = true;
            currentItem.put(item.entryType, item);
            int col = 0;
            if (this.overrideCol > -1) {
                col = this.overrideCol;
            }
            while (col < this.cCols) {
                int bitIndex = this.columnDescriptors[col].iBit / 8;
                int bit = this.columnDescriptors[col].iBit % 8;
                if (bitIndex < bitmap.length && (bitmap[bitIndex] & 1 << bit) != 0) {
                    item = new PSTTable7CItem();
                    item.itemIndex = col;
                    item.entryValueType = this.columnDescriptors[col].type;
                    item.entryType = this.columnDescriptors[col].id;
                    item.entryValueReference = 0;
                    switch (this.columnDescriptors[col].cbData) {
                        case 1: {
                            item.entryValueReference = (int)this.rowNodeInfo.seekAndReadLong(currentValueArrayStart + this.columnDescriptors[col].ibData, 1) & 0xFF;
                            item.isExternalValueReference = true;
                            break;
                        }
                        case 2: {
                            item.entryValueReference = (int)this.rowNodeInfo.seekAndReadLong(currentValueArrayStart + this.columnDescriptors[col].ibData, 2) & 0xFFFF;
                            item.isExternalValueReference = true;
                            break;
                        }
                        case 8: {
                            item.data = new byte[8];
                            this.rowNodeInfo.in.seek(this.rowNodeInfo.startOffset + currentValueArrayStart + this.columnDescriptors[col].ibData);
                            this.rowNodeInfo.in.readCompletely(item.data);
                            break;
                        }
                        default: {
                            item.entryValueReference = (int)this.rowNodeInfo.seekAndReadLong(currentValueArrayStart + this.columnDescriptors[col].ibData, 4);
                            if (this.columnDescriptors[col].type == 3 || this.columnDescriptors[col].type == 4 || this.columnDescriptors[col].type == 10) {
                                item.isExternalValueReference = true;
                                break;
                            }
                            if ((item.entryValueReference & 0x1F) != 0) {
                                item.isExternalValueReference = true;
                                break;
                            }
                            if (item.entryValueReference == 0) {
                                item.data = new byte[0];
                                break;
                            }
                            PSTTable.NodeInfo entryInfo = this.getNodeInfo(item.entryValueReference);
                            item.data = new byte[entryInfo.length()];
                            entryInfo.in.seek(entryInfo.startOffset);
                            entryInfo.in.readCompletely(item.data);
                        }
                    }
                    currentItem.put(item.entryType, item);
                }
                ++col;
            }
            itemList.add(dataSetNumber, currentItem);
            ++dataSetNumber;
        }
        return itemList;
    }

    @Override
    public int getRowCount() {
        return this.numberOfDataSets;
    }

    public String toString() {
        return this.description;
    }

    public String getItemsString() {
        if (this.items == null) {
            return "";
        }
        return this.items.toString();
    }

    class ColumnDescriptor {
        int type;
        int id;
        int ibData;
        int cbData;
        int iBit;

        ColumnDescriptor(PSTTable.NodeInfo nodeInfo, int offset) throws PSTException, IOException {
            this.type = (int)nodeInfo.seekAndReadLong(offset, 2) & 0xFFFF;
            this.id = (int)(nodeInfo.seekAndReadLong(offset + 2, 2) & 0xFFFFL);
            this.ibData = (int)(nodeInfo.seekAndReadLong(offset + 4, 2) & 0xFFFFL);
            this.cbData = nodeInfo.in.read() & 0xFF;
            this.iBit = nodeInfo.in.read() & 0xFF;
        }
    }
}

