/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.javalibpst;

import fr.gouv.vitam.tools.javalibpst.DescriptorIndexNode;
import fr.gouv.vitam.tools.javalibpst.PSTException;
import fr.gouv.vitam.tools.javalibpst.PSTFile;
import fr.gouv.vitam.tools.javalibpst.PSTObject;
import fr.gouv.vitam.tools.javalibpst.PSTTableBCItem;
import java.io.IOException;
import java.util.UUID;

public class PSTMessageStore
extends PSTObject {
    PSTMessageStore(PSTFile theFile, DescriptorIndexNode descriptorIndexNode) throws PSTException, IOException {
        super(theFile, descriptorIndexNode);
    }

    public UUID getTagRecordKeyAsUUID() {
        int guidEntryType = 4089;
        if (this.items.containsKey(4089)) {
            PSTTableBCItem item = (PSTTableBCItem)this.items.get(4089);
            boolean offset = false;
            byte[] bytes = item.data;
            long mostSigBits = PSTObject.convertLittleEndianBytesToLong(bytes, 0, 4) << 32 | PSTObject.convertLittleEndianBytesToLong(bytes, 4, 6) << 16 | PSTObject.convertLittleEndianBytesToLong(bytes, 6, 8);
            long leastSigBits = PSTObject.convertBigEndianBytesToLong(bytes, 8, 16);
            return new UUID(mostSigBits, leastSigBits);
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        int displayNameEntryType = 12289;
        if (this.items.containsKey(12289)) {
            return this.getStringItem(12289);
        }
        return "";
    }

    public String getDetails() {
        return this.items.toString();
    }

    public boolean isPasswordProtected() throws PSTException, IOException {
        return this.getLongItem(26623) != 0L;
    }
}

