/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.javalibpst;

import fr.gouv.vitam.tools.javalibpst.DescriptorIndexNode;
import fr.gouv.vitam.tools.javalibpst.OffsetIndexItem;
import fr.gouv.vitam.tools.javalibpst.PSTByteFileContent;
import fr.gouv.vitam.tools.javalibpst.PSTDescriptorItem;
import fr.gouv.vitam.tools.javalibpst.PSTException;
import fr.gouv.vitam.tools.javalibpst.PSTFileContent;
import fr.gouv.vitam.tools.javalibpst.PSTFolder;
import fr.gouv.vitam.tools.javalibpst.PSTMessageStore;
import fr.gouv.vitam.tools.javalibpst.PSTNodeInputStream;
import fr.gouv.vitam.tools.javalibpst.PSTObject;
import fr.gouv.vitam.tools.javalibpst.PSTRAFileContent;
import fr.gouv.vitam.tools.javalibpst.PSTTableBC;
import fr.gouv.vitam.tools.javalibpst.PSTTableBCItem;
import fr.gouv.vitam.tools.javalibpst.PSTTableItem;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Properties;
import java.util.UUID;

public class PSTFile {
    public static final int ENCRYPTION_TYPE_NONE = 0;
    public static final int ENCRYPTION_TYPE_COMPRESSIBLE = 1;
    private static final int MESSAGE_STORE_DESCRIPTOR_IDENTIFIER = 33;
    private static final int ROOT_FOLDER_DESCRIPTOR_IDENTIFIER = 290;
    public static final int PST_TYPE_ANSI = 14;
    protected static final int PST_TYPE_ANSI_2 = 15;
    public static final int PST_TYPE_UNICODE = 23;
    public static final int PST_TYPE_2013_UNICODE = 36;
    public static final int PS_PUBLIC_STRINGS = 0;
    public static final int PSETID_Common = 1;
    public static final int PSETID_Address = 2;
    public static final int PS_INTERNET_HEADERS = 3;
    public static final int PSETID_Appointment = 4;
    public static final int PSETID_Meeting = 5;
    public static final int PSETID_Log = 6;
    public static final int PSETID_Messaging = 7;
    public static final int PSETID_Note = 8;
    public static final int PSETID_PostRss = 9;
    public static final int PSETID_Task = 10;
    public static final int PSETID_UnifiedMessaging = 11;
    public static final int PS_MAPI = 12;
    public static final int PSETID_AirSync = 13;
    public static final int PSETID_Sharing = 14;
    private static final String[] guidStrings = new String[]{"00020329-0000-0000-C000-000000000046", "00062008-0000-0000-C000-000000000046", "00062004-0000-0000-C000-000000000046", "00020386-0000-0000-C000-000000000046", "00062002-0000-0000-C000-000000000046", "6ED8DA90-450B-101B-98DA-00AA003F1305", "0006200A-0000-0000-C000-000000000046", "41F28F13-83F4-4114-A584-EEDB5A6B0BFF", "0006200E-0000-0000-C000-000000000046", "00062041-0000-0000-C000-000000000046", "00062003-0000-0000-C000-000000000046", "4442858E-A9E3-4E80-B900-317A210CC15B", "00020328-0000-0000-C000-000000000046", "71035549-0739-4DCB-9163-00F0580DBBDF", "00062040-0000-0000-C000-000000000046"};
    private final HashMap<UUID, Integer> guidMap = new HashMap();
    private int encryptionType = 0;
    private LinkedHashMap<Integer, LinkedList<DescriptorIndexNode>> childrenDescriptorTree = null;
    private final HashMap<Long, Integer> nameToId = new HashMap();
    private final HashMap<String, Integer> stringToId = new HashMap();
    private static HashMap<Integer, Long> idToName = new HashMap();
    private final HashMap<Integer, String> idToString = new HashMap();
    private byte[] guids = null;
    private int itemCount = 0;
    private final PSTFileContent in;
    private String globalCodepage;
    private int pstFileType = 0;
    private static Properties propertyInternetCodePages = null;
    private static boolean bCPFirstTime = true;
    private static Properties propertyNames = null;
    private static boolean bFirstTime = true;
    static final int SLBLOCK_ENTRY = 0;
    static final int SIBLOCK_ENTRY = 1;
    private static boolean printErrors = true;

    public PSTFile(String fileName) throws FileNotFoundException, PSTException, IOException {
        this(new File(fileName));
    }

    public PSTFile(File file) throws FileNotFoundException, PSTException, IOException {
        this(new PSTRAFileContent(file), true);
    }

    public PSTFile(byte[] bytes) throws FileNotFoundException, PSTException, IOException {
        this(new PSTByteFileContent(bytes), true);
    }

    public PSTFile(PSTFileContent content) throws FileNotFoundException, PSTException, IOException {
        this(content, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PSTFile(PSTFileContent content, boolean closeFileContant) throws FileNotFoundException, PSTException, IOException {
        PSTFileContent pSTFileContent = this.in = content;
        synchronized (pSTFileContent) {
            try {
                byte[] temp = new byte[4];
                this.in.seek(0L);
                this.in.readCompletely(temp);
                String strValue = new String(temp);
                if (!strValue.equals("!BDN")) {
                    throw new PSTException("Invalid file header: " + strValue + ", expected: !BDN");
                }
                byte[] fileTypeBytes = new byte[2];
                this.in.seek(10L);
                this.in.readCompletely(fileTypeBytes);
                if (fileTypeBytes[0] == 15) {
                    fileTypeBytes[0] = 14;
                }
                if (fileTypeBytes[0] != 14 && fileTypeBytes[0] != 23 && fileTypeBytes[0] != 36) {
                    throw new PSTException("Unrecognised PST File version: " + fileTypeBytes[0]);
                }
                this.pstFileType = fileTypeBytes[0];
                if (this.getPSTFileType() == 14) {
                    this.in.seek(461L);
                } else {
                    this.in.seek(513L);
                }
                this.encryptionType = this.in.readByte();
                if (this.encryptionType == 2) {
                    throw new PSTException("Only unencrypted and compressable PST files are supported at this time");
                }
                this.processNameToIdMap(this.in);
                this.globalCodepage = this.inferGlobalCodepage();
            }
            catch (IOException err) {
                if (closeFileContant) {
                    this.in.close();
                }
                throw new PSTException("Unable to read PST Sig", err);
            }
            catch (Exception overException) {
                if (closeFileContant) {
                    this.in.close();
                }
                throw overException;
            }
        }
    }

    private String inferGlobalCodepage() {
        int codepageIdentifier;
        try {
            codepageIdentifier = this.getMessageStore().getIntItem(26307);
        }
        catch (PSTException | IOException e) {
            return null;
        }
        if (codepageIdentifier != 0) {
            return PSTFile.getInternetCodePageCharset(codepageIdentifier);
        }
        return Charset.defaultCharset().name();
    }

    public void setGlobalCodepage(String codepage) {
        this.globalCodepage = codepage;
    }

    public String getGlobalCodepage() {
        return this.globalCodepage;
    }

    public int getPSTFileType() {
        return this.pstFileType;
    }

    private void processNameToIdMap(PSTFileContent in) throws IOException, PSTException {
        for (int i = 0; i < guidStrings.length; ++i) {
            UUID uuid = UUID.fromString(guidStrings[i]);
            this.guidMap.put(uuid, i);
        }
        DescriptorIndexNode nameToIdMapDescriptorNode = this.getDescriptorIndexNode(97L);
        HashMap<Integer, PSTDescriptorItem> localDescriptorItems = null;
        if (nameToIdMapDescriptorNode.localDescriptorsOffsetIndexIdentifier != 0L) {
            localDescriptorItems = this.getPSTDescriptorItems(nameToIdMapDescriptorNode.localDescriptorsOffsetIndexIdentifier);
        }
        OffsetIndexItem off = this.getOffsetIndexNode(nameToIdMapDescriptorNode.dataOffsetIndexIdentifier);
        PSTNodeInputStream nodein = new PSTNodeInputStream(this, off);
        PSTTableBC bcTable = new PSTTableBC(nodein);
        HashMap<Integer, PSTTableBCItem> tableItems = bcTable.getItems();
        PSTTableBCItem guidEntry = tableItems.get(2);
        this.guids = this.getData(guidEntry, localDescriptorItems);
        int nGuids = this.guids.length / 16;
        UUID[] uuidArray = new UUID[nGuids];
        int[] uuidIndexes = new int[nGuids];
        int offset = 0;
        for (int i = 0; i < nGuids; ++i) {
            long mostSigBits = PSTObject.convertLittleEndianBytesToLong(this.guids, offset, offset + 4) << 32 | PSTObject.convertLittleEndianBytesToLong(this.guids, offset + 4, offset + 6) << 16 | PSTObject.convertLittleEndianBytesToLong(this.guids, offset + 6, offset + 8);
            long leastSigBits = PSTObject.convertBigEndianBytesToLong(this.guids, offset + 8, offset + 16);
            uuidArray[i] = new UUID(mostSigBits, leastSigBits);
            uuidIndexes[i] = this.guidMap.containsKey(uuidArray[i]) ? this.guidMap.get(uuidArray[i]) : -1;
            offset += 16;
        }
        PSTTableBCItem mapEntries = tableItems.get(3);
        byte[] nameToIdByte = this.getData(mapEntries, localDescriptorItems);
        PSTTableBCItem stringMapEntries = tableItems.get(4);
        byte[] stringNameToIdByte = this.getData(stringMapEntries, localDescriptorItems);
        int x = 0;
        while (x + 8 < nameToIdByte.length) {
            int dwPropertyId = (int)PSTObject.convertLittleEndianBytesToLong(nameToIdByte, x, x + 4);
            int wGuid = (int)PSTObject.convertLittleEndianBytesToLong(nameToIdByte, x + 4, x + 6);
            int wPropIdx = (int)PSTObject.convertLittleEndianBytesToLong(nameToIdByte, x + 6, x + 8);
            if ((wGuid & 1) == 0) {
                int guidIndex = (wGuid >>= 1) == 1 ? 12 : (wGuid == 2 ? 0 : uuidIndexes[wGuid - 3]);
                this.nameToId.put((long)dwPropertyId | (long)guidIndex << 32, wPropIdx += 32768);
                idToName.put(wPropIdx, Long.valueOf(dwPropertyId));
            } else {
                int len = (int)PSTObject.convertLittleEndianBytesToLong(stringNameToIdByte, dwPropertyId, dwPropertyId + 4);
                if (len > 0 && len < stringNameToIdByte.length) {
                    byte[] keyByteValue = new byte[len];
                    System.arraycopy(stringNameToIdByte, dwPropertyId + 4, keyByteValue, 0, keyByteValue.length);
                    String key = new String(keyByteValue, "UTF-16LE");
                    this.stringToId.put(key, wPropIdx += 32768);
                    this.idToString.put(wPropIdx, key);
                }
            }
            x += 8;
        }
    }

    private byte[] getData(PSTTableItem item, HashMap<Integer, PSTDescriptorItem> localDescriptorItems) throws IOException, PSTException {
        if (item.data.length != 0) {
            return item.data;
        }
        if (localDescriptorItems == null) {
            throw new PSTException("External reference but no localDescriptorItems in PSTFile.getData()");
        }
        if (item.entryValueType != 258) {
            throw new PSTException("Attempting to get non-binary data in PSTFile.getData()");
        }
        PSTDescriptorItem mapDescriptorItem = localDescriptorItems.get(item.entryValueReference);
        if (mapDescriptorItem == null) {
            throw new PSTException("not here " + item.entryValueReference + "\n" + localDescriptorItems.keySet());
        }
        return mapDescriptorItem.getData();
    }

    int getNameToIdMapItem(int key, int propertySetIndex) {
        long lKey = (long)propertySetIndex << 32 | (long)key;
        Integer i = this.nameToId.get(lKey);
        if (i == null) {
            return -1;
        }
        return i;
    }

    int getPublicStringToIdMapItem(String key) {
        Integer i = this.stringToId.get(key);
        if (i == null) {
            return -1;
        }
        return i;
    }

    static long getNameToIdMapKey(int id) {
        Long i = idToName.get(id);
        if (i == null) {
            return -1L;
        }
        return i;
    }

    static String getInternetCodePageCharset(int propertyId) {
        if (bCPFirstTime) {
            bCPFirstTime = false;
            propertyInternetCodePages = new Properties();
            try {
                InputStream propertyStream = PSTFile.class.getResourceAsStream("/InternetCodepages.txt");
                if (propertyStream != null) {
                    propertyInternetCodePages.load(propertyStream);
                } else {
                    propertyInternetCodePages = null;
                }
            }
            catch (FileNotFoundException e) {
                propertyInternetCodePages = null;
                e.printStackTrace();
            }
            catch (IOException e) {
                propertyInternetCodePages = null;
                e.printStackTrace();
            }
        }
        if (propertyInternetCodePages != null) {
            return propertyInternetCodePages.getProperty("" + propertyId);
        }
        return null;
    }

    static String getPropertyName(int propertyId, boolean bNamed) {
        if (bFirstTime) {
            bFirstTime = false;
            propertyNames = new Properties();
            try {
                InputStream propertyStream = PSTFile.class.getResourceAsStream("/PropertyNames.txt");
                if (propertyStream != null) {
                    propertyNames.load(propertyStream);
                } else {
                    propertyNames = null;
                }
            }
            catch (FileNotFoundException e) {
                propertyNames = null;
                e.printStackTrace();
            }
            catch (IOException e) {
                propertyNames = null;
                e.printStackTrace();
            }
        }
        if (propertyNames != null) {
            String key = String.format(bNamed ? "%08X" : "%04X", propertyId);
            return propertyNames.getProperty(key);
        }
        return null;
    }

    static String getPropertyDescription(int entryType, int entryValueType) {
        long type;
        String name;
        String ret = "";
        ret = entryType < 32768 ? ((name = PSTFile.getPropertyName(entryType, false)) != null ? String.format("%s(code %04X):%04X: ", name, entryType, entryValueType) : String.format("unknown property 0x%04X:%04X: ", entryType, entryValueType)) : ((name = PSTFile.getPropertyName(entryType, false)) != null ? String.format("%s(code %04X):%04X: ", name, entryType, entryValueType) : ((type = PSTFile.getNameToIdMapKey(entryType)) == -1L ? String.format("0xFFFF(%04X):%04X: ", entryType, entryValueType) : ((name = PSTFile.getPropertyName((int)type, true)) != null ? String.format("%s(mapcode %04X):%04X: ", name, entryType, entryValueType) : String.format("not mapped property 0x%04X(%04X):%04X: ", type, entryType, entryValueType))));
        return ret;
    }

    protected void finalize() throws IOException {
        this.in.close();
    }

    public int getEncryptionType() {
        return this.encryptionType;
    }

    public RandomAccessFile getFileHandle() {
        if (this.in instanceof PSTRAFileContent) {
            return ((PSTRAFileContent)this.in).getFile();
        }
        return null;
    }

    public PSTFileContent getContentHandle() {
        return this.in;
    }

    public PSTMessageStore getMessageStore() throws PSTException, IOException {
        DescriptorIndexNode messageStoreDescriptor = this.getDescriptorIndexNode(33L);
        return new PSTMessageStore(this, messageStoreDescriptor);
    }

    public PSTFolder getRootFolder() throws PSTException, IOException {
        DescriptorIndexNode rootFolderDescriptor = this.getDescriptorIndexNode(290L);
        PSTFolder output = new PSTFolder(this, rootFolderDescriptor);
        return output;
    }

    PSTNodeInputStream readLeaf(long bid) throws IOException, PSTException {
        Object ret = null;
        OffsetIndexItem offsetItem = this.getOffsetIndexNode(bid);
        return new PSTNodeInputStream(this, offsetItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLeafSize(long bid) throws IOException, PSTException {
        OffsetIndexItem offsetItem = this.getOffsetIndexNode(bid);
        if ((offsetItem.indexIdentifier & 2L) == 0L) {
            return offsetItem.size;
        }
        byte[] data = new byte[8];
        PSTFileContent pSTFileContent = this.in;
        synchronized (pSTFileContent) {
            this.in.seek(offsetItem.fileOffset);
            this.in.readCompletely(data);
        }
        return (int)PSTObject.convertLittleEndianBytesToLong(data, 4, 8);
    }

    private long extractLEFileOffset(long startOffset) throws IOException {
        long offset = 0L;
        if (this.getPSTFileType() == 14) {
            this.in.seek(startOffset);
            byte[] temp = new byte[4];
            this.in.readCompletely(temp);
            offset |= (long)(temp[3] & 0xFF);
            offset <<= 8;
            offset |= (long)(temp[2] & 0xFF);
            offset <<= 8;
            offset |= (long)(temp[1] & 0xFF);
            offset <<= 8;
            offset |= (long)(temp[0] & 0xFF);
        } else {
            this.in.seek(startOffset);
            byte[] temp = new byte[8];
            this.in.readCompletely(temp);
            offset = temp[7] & 0xFF;
            for (int x = 6; x >= 0; --x) {
                offset <<= 8;
                long tmpLongValue = (long)temp[x] & 0xFFL;
                offset |= tmpLongValue;
            }
        }
        return offset;
    }

    private byte[] findBtreeItem(PSTFileContent in, long index, boolean descTree) throws IOException, PSTException {
        PSTFileContent pSTFileContent = in;
        synchronized (pSTFileContent) {
            long btreeStartOffset;
            if (this.getPSTFileType() == 14) {
                btreeStartOffset = this.extractLEFileOffset(196L);
                if (descTree) {
                    btreeStartOffset = this.extractLEFileOffset(188L);
                }
            } else {
                btreeStartOffset = this.extractLEFileOffset(240L);
                if (descTree) {
                    btreeStartOffset = this.extractLEFileOffset(224L);
                }
            }
            byte[] temp = new byte[2];
            int fileTypeAdjustment = this.getPSTFileType() == 14 ? 500 : (this.getPSTFileType() == 36 ? 4072 : 496);
            in.seek(btreeStartOffset + (long)fileTypeAdjustment);
            in.readCompletely(temp);
            while (temp[0] == -128 && temp[1] == -128 && !descTree || temp[0] == -127 && temp[1] == -127 && descTree) {
                byte[] branchNodeItems = this.getPSTFileType() == 14 ? new byte[496] : (this.getPSTFileType() == 36 ? new byte[4056] : new byte[488]);
                in.seek(btreeStartOffset);
                in.readCompletely(branchNodeItems);
                long numberOfItems = 0L;
                if (this.getPSTFileType() == 36) {
                    byte[] numberOfItemsBytes = new byte[2];
                    in.readCompletely(numberOfItemsBytes);
                    numberOfItems = PSTObject.convertLittleEndianBytesToLong(numberOfItemsBytes);
                    in.readCompletely(numberOfItemsBytes);
                    long l = PSTObject.convertLittleEndianBytesToLong(numberOfItemsBytes);
                } else {
                    numberOfItems = in.read();
                    in.read();
                }
                int itemSize = in.read();
                int levelsToLeaf = in.read();
                if (levelsToLeaf > 0) {
                    boolean found = false;
                    for (long x = 0L; x < numberOfItems; ++x) {
                        long indexIdOfFirstChildNode;
                        if (this.getPSTFileType() == 14) {
                            indexIdOfFirstChildNode = this.extractLEFileOffset(btreeStartOffset + x * 12L);
                            if (indexIdOfFirstChildNode <= index) continue;
                            btreeStartOffset = this.extractLEFileOffset(btreeStartOffset + (x - 1L) * 12L + 8L);
                            in.seek(btreeStartOffset + 500L);
                            in.readCompletely(temp);
                            found = true;
                            break;
                        }
                        indexIdOfFirstChildNode = this.extractLEFileOffset(btreeStartOffset + x * 24L);
                        if (indexIdOfFirstChildNode <= index) continue;
                        btreeStartOffset = this.extractLEFileOffset(btreeStartOffset + (x - 1L) * 24L + 16L);
                        in.seek(btreeStartOffset + (long)fileTypeAdjustment);
                        in.readCompletely(temp);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    if (this.getPSTFileType() == 14) {
                        btreeStartOffset = this.extractLEFileOffset(btreeStartOffset + (numberOfItems - 1L) * 12L + 8L);
                        in.seek(btreeStartOffset + 500L);
                        in.readCompletely(temp);
                        continue;
                    }
                    btreeStartOffset = this.extractLEFileOffset(btreeStartOffset + (numberOfItems - 1L) * 24L + 16L);
                    in.seek(btreeStartOffset + (long)fileTypeAdjustment);
                    in.readCompletely(temp);
                    continue;
                }
                for (long x = 0L; x < numberOfItems; ++x) {
                    long indexIdOfFirstChildNode;
                    if (this.getPSTFileType() == 14) {
                        if (descTree) {
                            in.seek(btreeStartOffset + x * 16L);
                            temp = new byte[4];
                            in.readCompletely(temp);
                            if (PSTObject.convertLittleEndianBytesToLong(temp) != index) continue;
                            in.seek(btreeStartOffset + x * 16L);
                            temp = new byte[16];
                            in.readCompletely(temp);
                            return temp;
                        }
                        indexIdOfFirstChildNode = this.extractLEFileOffset(btreeStartOffset + x * 12L);
                        if (indexIdOfFirstChildNode != index) continue;
                        in.seek(btreeStartOffset + x * 12L);
                        temp = new byte[12];
                        in.readCompletely(temp);
                        return temp;
                    }
                    if (descTree) {
                        in.seek(btreeStartOffset + x * 32L);
                        temp = new byte[4];
                        in.readCompletely(temp);
                        if (PSTObject.convertLittleEndianBytesToLong(temp) != index) continue;
                        in.seek(btreeStartOffset + x * 32L);
                        temp = new byte[32];
                        in.readCompletely(temp);
                        return temp;
                    }
                    indexIdOfFirstChildNode = this.extractLEFileOffset(btreeStartOffset + x * 24L);
                    if (indexIdOfFirstChildNode != index) continue;
                    in.seek(btreeStartOffset + x * 24L);
                    temp = new byte[24];
                    in.readCompletely(temp);
                    return temp;
                }
                throw new PSTException("Unable to find " + index + " is desc: " + descTree);
            }
            throw new PSTException("Unable to find node: " + index + " is desc: " + descTree);
        }
    }

    DescriptorIndexNode getDescriptorIndexNode(long identifier) throws IOException, PSTException {
        return new DescriptorIndexNode(this.findBtreeItem(this.in, identifier, true), this.getPSTFileType());
    }

    OffsetIndexItem getOffsetIndexNode(long identifier) throws IOException, PSTException {
        return new OffsetIndexItem(this.findBtreeItem(this.in, identifier, false), this.getPSTFileType());
    }

    HashMap<Integer, PSTDescriptorItem> getPSTDescriptorItems(long localDescriptorsOffsetIndexIdentifier) throws PSTException, IOException {
        return this.getPSTDescriptorItems(this.readLeaf(localDescriptorsOffsetIndexIdentifier));
    }

    HashMap<Integer, PSTDescriptorItem> getPSTDescriptorItems(PSTNodeInputStream pstNodeInputStream) throws PSTException, IOException {
        pstNodeInputStream.seek(0L);
        int sig = pstNodeInputStream.read();
        if (sig != 2) {
            throw new PSTException("Unable to process descriptor node, bad signature: " + sig);
        }
        int blockType = pstNodeInputStream.read();
        if (blockType != 0 && blockType != 1) {
            throw new PSTException("Unable to process descriptor node, unknown BLOCK type: " + blockType);
        }
        HashMap<Integer, PSTDescriptorItem> output = new HashMap<Integer, PSTDescriptorItem>();
        int numberOfItems = (int)pstNodeInputStream.seekAndReadLong(2L, 2);
        int offset = this.getPSTFileType() == 14 ? 4 : 8;
        byte[] data = new byte[(int)pstNodeInputStream.length()];
        pstNodeInputStream.seek(0L);
        pstNodeInputStream.readCompletely(data);
        for (int x = 0; x < numberOfItems; ++x) {
            PSTDescriptorItem item = new PSTDescriptorItem(data, offset, this, blockType);
            if (blockType == 0) {
                output.put(item.descriptorIdentifier, item);
            } else {
                output.putAll(this.getPSTDescriptorItems(item.offsetIndexIdentifier));
            }
            if (this.getPSTFileType() == 14) {
                if (blockType == 0) {
                    offset += 12;
                    continue;
                }
                offset += 8;
                continue;
            }
            if (blockType == 0) {
                offset += 24;
                continue;
            }
            offset += 16;
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LinkedHashMap<Integer, LinkedList<DescriptorIndexNode>> getChildDescriptorTree() throws IOException, PSTException {
        PSTFileContent pSTFileContent = this.in;
        synchronized (pSTFileContent) {
            if (this.childrenDescriptorTree == null) {
                long btreeStartOffset = 0L;
                btreeStartOffset = this.getPSTFileType() == 14 ? this.extractLEFileOffset(188L) : this.extractLEFileOffset(224L);
                this.childrenDescriptorTree = new LinkedHashMap();
                this.processDescriptorBTree(btreeStartOffset);
            }
        }
        return this.childrenDescriptorTree;
    }

    private void processDescriptorBTree(long btreeStartOffset) throws IOException, PSTException {
        byte[] temp = new byte[2];
        int fileTypeAdjustment = this.getPSTFileType() == 14 ? 500 : (this.getPSTFileType() == 36 ? 4072 : 496);
        this.in.seek(btreeStartOffset + (long)fileTypeAdjustment);
        this.in.readCompletely(temp);
        if (temp[0] == -127 && temp[1] == -127) {
            long x;
            if (this.getPSTFileType() == 14) {
                this.in.seek(btreeStartOffset + 496L);
            } else if (this.getPSTFileType() == 36) {
                this.in.seek(btreeStartOffset + 4056L);
            } else {
                this.in.seek(btreeStartOffset + 488L);
            }
            long numberOfItems = 0L;
            if (this.getPSTFileType() == 36) {
                byte[] numberOfItemsBytes = new byte[2];
                this.in.readCompletely(numberOfItemsBytes);
                numberOfItems = PSTObject.convertLittleEndianBytesToLong(numberOfItemsBytes);
                this.in.readCompletely(numberOfItemsBytes);
                long l = PSTObject.convertLittleEndianBytesToLong(numberOfItemsBytes);
            } else {
                numberOfItems = this.in.read();
                this.in.read();
            }
            this.in.read();
            int levelsToLeaf = this.in.read();
            if (levelsToLeaf > 0) {
                for (x = 0L; x < numberOfItems; ++x) {
                    long nextLevelStartsAt;
                    long branchNodeItemStartIndex;
                    if (this.getPSTFileType() == 14) {
                        branchNodeItemStartIndex = btreeStartOffset + 12L * x;
                        nextLevelStartsAt = this.extractLEFileOffset(branchNodeItemStartIndex + 8L);
                        this.processDescriptorBTree(nextLevelStartsAt);
                        continue;
                    }
                    branchNodeItemStartIndex = btreeStartOffset + 24L * x;
                    nextLevelStartsAt = this.extractLEFileOffset(branchNodeItemStartIndex + 16L);
                    this.processDescriptorBTree(nextLevelStartsAt);
                }
            } else {
                for (x = 0L; x < numberOfItems; ++x) {
                    if (this.getPSTFileType() == 14) {
                        this.in.seek(btreeStartOffset + x * 16L);
                        temp = new byte[16];
                        this.in.readCompletely(temp);
                    } else {
                        this.in.seek(btreeStartOffset + x * 32L);
                        temp = new byte[32];
                        this.in.readCompletely(temp);
                    }
                    DescriptorIndexNode tempNode = new DescriptorIndexNode(temp, this.getPSTFileType());
                    if (tempNode.parentDescriptorIndexIdentifier != tempNode.descriptorIdentifier) {
                        LinkedList<Object> children;
                        if (this.childrenDescriptorTree.containsKey(tempNode.parentDescriptorIndexIdentifier)) {
                            children = this.childrenDescriptorTree.get(tempNode.parentDescriptorIndexIdentifier);
                            children.add(tempNode);
                        } else {
                            children = new LinkedList<DescriptorIndexNode>();
                            children.add(tempNode);
                            this.childrenDescriptorTree.put(tempNode.parentDescriptorIndexIdentifier, children);
                        }
                    }
                    ++this.itemCount;
                }
            }
        } else {
            PSTObject.printHexFormatted(temp, true);
            throw new PSTException("Unable to read descriptor node, is not a descriptor");
        }
    }

    public void close() throws IOException {
        this.in.close();
    }

    public static boolean isPrintErrors() {
        return printErrors;
    }

    public static void setPrintErrors(boolean printErrors) {
        PSTFile.printErrors = printErrors;
    }
}

