/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.javalibpst;

import fr.gouv.vitam.tools.javalibpst.PSTObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class PSTConversationIndex {
    private static final int HUNDRED_NS_TO_MS = 1000;
    private static final int MINIMUM_HEADER_SIZE = 22;
    private static final int RESPONSE_LEVEL_SIZE = 5;
    private Date deliveryTime;
    private UUID guid;
    private List<ResponseLevel> responseLevels = new ArrayList<ResponseLevel>();

    public Date getDeliveryTime() {
        return this.deliveryTime;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public List<ResponseLevel> getResponseLevels() {
        return this.responseLevels;
    }

    public String toString() {
        return this.guid + "@" + this.deliveryTime + " " + this.responseLevels.size() + " ResponseLevels";
    }

    protected PSTConversationIndex(byte[] rawConversationIndex) {
        if (rawConversationIndex != null && rawConversationIndex.length >= 22) {
            this.decodeHeader(rawConversationIndex);
            if (rawConversationIndex.length >= 27) {
                this.decodeResponseLevel(rawConversationIndex);
            }
        }
    }

    private void decodeHeader(byte[] rawConversationIndex) {
        long deliveryTimeHigh = PSTObject.convertBigEndianBytesToLong(rawConversationIndex, 0, 4);
        long deliveryTimeLow = PSTObject.convertBigEndianBytesToLong(rawConversationIndex, 4, 6) << 16;
        this.deliveryTime = PSTObject.filetimeToDate((int)deliveryTimeHigh, (int)deliveryTimeLow);
        long guidHigh = PSTObject.convertBigEndianBytesToLong(rawConversationIndex, 6, 14);
        long guidLow = PSTObject.convertBigEndianBytesToLong(rawConversationIndex, 14, 22);
        this.guid = new UUID(guidHigh, guidLow);
    }

    private void decodeResponseLevel(byte[] rawConversationIndex) {
        int responseLevelCount = (rawConversationIndex.length - 22) / 5;
        this.responseLevels = new ArrayList<ResponseLevel>(responseLevelCount);
        int responseLevelIndex = 0;
        int position = 22;
        while (responseLevelIndex < responseLevelCount) {
            long responseLevelValue = PSTObject.convertBigEndianBytesToLong(rawConversationIndex, position, position + 5);
            short deltaCode = (short)(responseLevelValue >> 39);
            short random = (short)(responseLevelValue & 0xFFL);
            long deltaTime = responseLevelValue >> 8 & Integer.MAX_VALUE;
            deltaTime = deltaCode == 0 ? (deltaTime <<= 18) : (deltaTime <<= 23);
            this.responseLevels.add(responseLevelIndex, new ResponseLevel(deltaCode, deltaTime /= 1000L, random));
            ++responseLevelIndex;
            position += 5;
        }
    }

    public class ResponseLevel {
        short deltaCode;
        long timeDelta;
        short random;

        public ResponseLevel(short deltaCode, long timeDelta, short random) {
            this.deltaCode = deltaCode;
            this.timeDelta = timeDelta;
            this.random = random;
        }

        public short getDeltaCode() {
            return this.deltaCode;
        }

        public long getTimeDelta() {
            return this.timeDelta;
        }

        public short getRandom() {
            return this.random;
        }

        public Date withOffset(Date anchorDate) {
            return new Date(anchorDate.getTime() + this.timeDelta);
        }
    }
}

