/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.javalibpst;

import fr.gouv.vitam.tools.javalibpst.PSTAppointment;
import fr.gouv.vitam.tools.javalibpst.PSTAppointmentException;
import fr.gouv.vitam.tools.javalibpst.PSTMessage;
import fr.gouv.vitam.tools.javalibpst.PSTObject;
import fr.gouv.vitam.tools.javalibpst.PSTTimeZone;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.SimpleTimeZone;

public class PSTAppointmentRecurrence {
    private final Date StartDate;
    private final Date EndDate;
    private final short RecurFrequency;
    private final short PatternType;
    private final short CalendarType;
    private final Date FirstDateTime;
    private final int Period;
    private final int SlidingFlag;
    private int PatternSpecific;
    private int PatternSpecificNth;
    private final int EndType;
    private final int OccurrenceCount;
    private final int FirstDOW;
    private final int DeletedInstanceCount;
    private Date[] DeletedInstanceDates = null;
    private final int ModifiedInstanceCount;
    private Date[] ModifiedInstanceDates = null;
    private final int writerVersion2;
    private final int StartTimeOffset;
    private final int EndTimeOffset;
    private final short ExceptionCount;
    private PSTAppointmentException[] Exceptions = null;
    private PSTTimeZone RecurrenceTimeZone = null;

    public short getExceptionCount() {
        return this.ExceptionCount;
    }

    public PSTAppointmentException getException(int i) {
        if (i < 0 || i >= this.ExceptionCount) {
            return null;
        }
        return this.Exceptions[i];
    }

    public Date[] getDeletedInstanceDates() {
        return this.DeletedInstanceDates;
    }

    public Date[] getModifiedInstanceDates() {
        return this.ModifiedInstanceDates;
    }

    public short getCalendarType() {
        return this.CalendarType;
    }

    public short getPatternType() {
        return this.PatternType;
    }

    public int getPeriod() {
        return this.Period;
    }

    public int getPatternSpecific() {
        return this.PatternSpecific;
    }

    public int getFirstDOW() {
        return this.FirstDOW;
    }

    public int getPatternSpecificNth() {
        return this.PatternSpecificNth;
    }

    public Date getFirstDateTime() {
        return this.FirstDateTime;
    }

    public int getEndType() {
        return this.EndType;
    }

    public int getOccurrenceCount() {
        return this.OccurrenceCount;
    }

    public Date getEndDate() {
        return this.EndDate;
    }

    public int getStartTimeOffset() {
        return this.StartTimeOffset;
    }

    public PSTTimeZone getTimeZone() {
        return this.RecurrenceTimeZone;
    }

    public int getRecurFrequency() {
        return this.RecurFrequency;
    }

    public int getSlidingFlag() {
        return this.SlidingFlag;
    }

    public Date getStartDate() {
        return this.StartDate;
    }

    public int getEndTimeOffset() {
        return this.EndTimeOffset;
    }

    public PSTAppointmentRecurrence(byte[] recurrencePattern, PSTAppointment appt, PSTTimeZone tz) {
        int i;
        int i2;
        this.RecurrenceTimeZone = tz;
        SimpleTimeZone stz = tz == null ? PSTTimeZone.utcTimeZone : this.RecurrenceTimeZone.getSimpleTimeZone();
        this.RecurFrequency = (short)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, 4, 6);
        this.PatternType = (short)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, 6, 8);
        this.CalendarType = (short)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, 8, 10);
        this.FirstDateTime = PSTAppointment.apptTimeToUTCDate((int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, 10, 14), this.RecurrenceTimeZone);
        this.Period = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, 14, 18);
        this.SlidingFlag = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, 18, 22);
        int offset = 22;
        if (this.PatternType != 0) {
            this.PatternSpecific = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4);
            offset += 4;
            if (this.PatternType == 3 || this.PatternType == 11) {
                this.PatternSpecificNth = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4);
                offset += 4;
            }
        }
        this.EndType = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4);
        this.OccurrenceCount = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset += 4, offset + 4);
        this.FirstDOW = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset += 4, offset + 4);
        this.DeletedInstanceCount = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset += 4, offset + 4);
        offset += 4;
        this.DeletedInstanceDates = new Date[this.DeletedInstanceCount];
        for (i2 = 0; i2 < this.DeletedInstanceCount; ++i2) {
            this.DeletedInstanceDates[i2] = PSTAppointment.apptTimeToUTCDate((int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4), this.RecurrenceTimeZone);
            offset += 4;
        }
        this.ModifiedInstanceCount = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4);
        offset += 4;
        this.ModifiedInstanceDates = new Date[this.ModifiedInstanceCount];
        for (i2 = 0; i2 < this.ModifiedInstanceCount; ++i2) {
            this.ModifiedInstanceDates[i2] = PSTAppointment.apptTimeToUTCDate((int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4), this.RecurrenceTimeZone);
            offset += 4;
        }
        this.StartDate = PSTAppointment.apptTimeToUTCDate((int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4), this.RecurrenceTimeZone);
        this.EndDate = PSTAppointment.apptTimeToUTCDate((int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset += 4, offset + 4), this.RecurrenceTimeZone);
        this.writerVersion2 = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset += 8, offset + 4);
        this.StartTimeOffset = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset += 4, offset + 4);
        this.EndTimeOffset = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset += 4, offset + 4);
        this.ExceptionCount = (short)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset += 4, offset + 2);
        offset += 2;
        this.Exceptions = new PSTAppointmentException[this.ExceptionCount];
        for (i2 = 0; i2 < this.ExceptionCount; ++i2) {
            this.Exceptions[i2] = new PSTAppointmentException(recurrencePattern, offset, this.writerVersion2, appt);
            offset += this.Exceptions[i2].getLength();
        }
        if (offset + 4 <= recurrencePattern.length) {
            int ReservedBlock1Size = (int)PSTObject.convertLittleEndianBytesToLong(recurrencePattern, offset, offset + 4);
            offset += 4 + ReservedBlock1Size * 4;
        }
        for (i2 = 0; i2 < this.ExceptionCount; ++i2) {
            this.Exceptions[i2].ExtendedException(recurrencePattern, offset);
            offset += this.Exceptions[i2].getExtendedLength();
        }
        PSTAppointment embeddedMessage = null;
        HashMap<String, PSTAppointmentException> modifiedDateMap = new HashMap<String, PSTAppointmentException>();
        SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd");
        f.setTimeZone(stz);
        Calendar c = Calendar.getInstance(stz);
        for (i = 0; i < this.ExceptionCount; ++i) {
            modifiedDateMap.put(f.format(this.ModifiedInstanceDates[i].getTime()), this.Exceptions[i]);
        }
        for (i = 0; i < appt.getNumberOfAttachments(); ++i) {
            try {
                PSTMessage message = appt.getAttachment(i).getEmbeddedPSTMessage();
                if (!(message instanceof PSTAppointment)) continue;
                embeddedMessage = (PSTAppointment)message;
                c.setTime(embeddedMessage.getRecurrenceBase());
                PSTAppointmentException modifiedException = (PSTAppointmentException)modifiedDateMap.get(f.format(c.getTime()));
                if (modifiedException == null) continue;
                modifiedException.setEmbeddedMessage(embeddedMessage);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String toString() {
        String result = "  Start date:" + this.getStartDate();
        result = result + "\n  End date:" + this.getEndDate();
        result = result + "\n  Changes:";
        result = result + "\n    " + this.getExceptionCount() + " exceptions";
        result = result + "\n    " + this.getDeletedInstanceDates().length + " delete";
        for (Date d : this.getDeletedInstanceDates()) {
            result = result + "\n      " + d.toString();
        }
        result = result + "\n    " + this.getModifiedInstanceDates().length + " modified";
        int excount = 0;
        for (Date d : this.getModifiedInstanceDates()) {
            result = result + "\n      " + d.toString();
            result = result + "\n" + this.getException(excount++);
        }
        result = result + "\n";
        return result;
    }
}

